/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageOverlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageType;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchGroup;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.FilterOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingWidgets;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.add.ItemOverlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.ItemListing;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.function.BooleanConsumer;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.world.ItemFilter;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public abstract class ItemListingOverlay<V, L extends ItemListing<V, L>>
implements ListingOverlay<V, L> {
    @Nullable
    private FilterOverlay filter = null;
    @Nullable
    private ButtonWidget abacus = null;
    @Nullable
    private ButtonWidget quick = null;
    private final ListingWidgets<V, L> widgets;
    private final TweakListing<V, L> tweak;
    private final Overlay overlay;
    private final L itemListing;
    protected final Overlay wildcardHelp;

    public ItemListingOverlay(TweakListing<V, L> tweak) {
        this.tweak = tweak;
        this.itemListing = (ItemListing)tweak.fromCache();
        this.overlay = this.getDefaultOverlay().build();
        this.widgets = new ListingWidgets(this);
        this.wildcardHelp = MessageOverlay.create(MessageType.HELP, Lang.Button.HELP, Lang.Listing.WILDCARD_HELP).setResizePercentage(0.5).alignLeft().build();
    }

    @Override
    public TweakListing<V, L> getTweak() {
        return this.tweak;
    }

    @Override
    public ListingWidgets<V, L> getWidgets() {
        return this.widgets;
    }

    @Override
    public ItemListing<V, L> getListing() {
        return this.itemListing;
    }

    @Override
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Override
    public void onAdd() {
        new ItemOverlay((ItemListing)this.tweak.fromCache(), this::createListRows, this::addItem).open();
    }

    private void addItem(ItemStack itemStack) {
        this.onRowAdd(ItemUtil.getResourceKey(itemStack));
        this.createListRows();
        this.widgets.findAndHighlight(ItemUtil.getLocalizedItem(itemStack));
    }

    private void onQuickAdd() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.addItem(Minecraft.m_91087_().f_91074_.m_21205_());
        }
    }

    protected SwitchGroup.Widgets getWildcardWidgets(Row row, String key) {
        MutableComponent wildcardHead = Lang.Listing.WILDCARD_TITLE.get(new Object[0]);
        MutableComponent wildcardInfo = Lang.Listing.WILDCARD_MESSAGE.get(ItemUtil.getLocalizedItem(key));
        BooleanSupplier isWildcard = () -> ((ItemListing)this.getListing()).containsWildcard(key);
        BooleanConsumer setWildcard = state -> {
            if (state) {
                ((ItemListing)this.getListing()).addWildcard(key);
            } else {
                ((ItemListing)this.getListing()).removeWildcard(key);
            }
        };
        return SwitchGroup.create((WidgetHolder)row, (Component)wildcardHead, (Component)wildcardInfo, isWildcard, setWildcard).getWidgets();
    }

    protected boolean isWildcardChanged(String key) {
        ItemListing mode = (ItemListing)this.tweak.fromMode();
        ItemListing cache = (ItemListing)this.tweak.fromCache();
        boolean isRemoved = mode.containsWildcard(key) && !cache.containsWildcard(key);
        boolean isAdded = cache.containsWildcard(key) && !mode.containsWildcard(key);
        return isAdded || isRemoved;
    }

    @Override
    public String getLocalizedKey(String listKey) {
        if (ItemUtil.getOptionalItem(listKey).isPresent()) {
            return ItemUtil.getLocalizedItem(listKey);
        }
        return listKey;
    }

    @Override
    public HashMap<Pair<String, V>, String> getLocalizedEntries(Collection<Pair<String, V>> collection) {
        HashMap<Pair<String, String>, String> localized = new HashMap<Pair<String, String>, String>();
        for (Pair pair : this.getEntries()) {
            Optional<Item> item = ItemUtil.getOptionalItem(pair.left());
            if (item.isPresent() && this.filter != null && this.filter.isFiltered(item.get())) continue;
            localized.put(pair, this.getLocalizedKey(pair.left()));
        }
        return localized;
    }

    @Override
    public TextureIcon getRowIcon(String listKey) {
        return TextureIcon.fromItem(ItemUtil.getOptionalItem(listKey).orElse(Items.f_42127_));
    }

    @Override
    public Component appendToRowTitle(String listKey, MutableComponent rowTitle) {
        if (ItemUtil.getOptionalItem(listKey).isEmpty()) {
            return rowTitle.m_7220_((Component)Component.m_237113_((String)" [")).m_7220_((Component)Lang.Listing.INVALID_ITEM.withStyle(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.RESET));
        }
        return rowTitle;
    }

    @Override
    public void createExtraWidgets(ListingWidgets<V, L> widgets) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            BooleanSupplier isMainHandItemInvalid = () -> {
                ItemStack item = Minecraft.m_91087_().f_91074_.m_21205_();
                return ItemFilter.isFiltered(item, this.itemListing);
            };
            this.quick = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.QUICK).disableIf(CollectionUtil.areAnyTrue(isMainHandItemInvalid, this::isLocked))).onPress(this::onQuickAdd)).rightOf(widgets.add, 1)).icon(Icons.LIGHTNING)).tooltip(Lang.Button.QUICK, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.QUICK, 35)).iconTextPadding(4)).padding(5)).useTextWidth()).skipFocusOnClick()).build(this.overlay::addWidget);
            ((ButtonBuilder)widgets.undo.getBuilder()).rightOf(this.quick, 1);
            widgets.shrinkable.add(this.quick);
        }
        if (((ItemListing)this.itemListing).areRulesEmpty()) {
            this.abacus = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.FILTER).onPress(() -> NullableAction.attempt(this.filter, FilterOverlay::open))).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.FILTER)).tooltip(Lang.Button.FILTER, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.FILTER, 35)).build(this.overlay::addWidget);
            if (this.quick == null) {
                ((ButtonBuilder)this.abacus.getBuilder()).rightOf(widgets.add, 1);
            } else {
                ((ButtonBuilder)this.abacus.getBuilder()).rightOf(this.quick, 1);
            }
            this.filter = new FilterOverlay(this.abacus, this::createListRows);
            ((ButtonBuilder)widgets.undo.getBuilder()).rightOf(this.abacus, 1);
            widgets.shrinkable.add(this.abacus);
        }
    }

    @Override
    public void setTabOrder(ListingWidgets<V, L> widgets) {
        widgets.add.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        if (this.quick != null) {
            this.quick.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        }
        if (this.abacus != null) {
            this.abacus.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        }
        widgets.undo.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.search.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.manage.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.finish.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.rowList.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
    }
}

