/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.OverlayBuilder;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingWidgets;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public interface ListingOverlay<V, L extends Listing<V, L>> {
    public TweakListing<V, L> getTweak();

    public ListingWidgets<V, L> getWidgets();

    public Overlay getOverlay();

    default public OverlayBuilder getDefaultOverlay() {
        return Overlay.create(this.getTweak().getTranslation()).icon(this.getTweak().getIcon().orElse(Icons.GENERIC_OVERLAY)).resizeHeightUsingPercentage(0.9).resizeWidthUsingPercentage(0.6, 425).minWidth(380);
    }

    default public Listing<V, L> getListing() {
        return (Listing)this.getTweak().fromCache();
    }

    default public boolean isLocked() {
        return this.getTweak().isNetworkLocked();
    }

    default public boolean isUnlocked() {
        return !this.isLocked();
    }

    public void onAdd();

    public void onRowAdd(Object var1);

    public Collection<Pair<String, V>> getEntries();

    public String getLocalizedKey(String var1);

    public HashMap<Pair<String, V>, String> getLocalizedEntries(Collection<Pair<String, V>> var1);

    @Nullable
    public AbstractRow<?, ?> getRow(String var1, V var2);

    default public void open() {
        this.getOverlay().open();
    }

    default public void setTabOrder(ListingWidgets<V, L> widgets) {
        widgets.add.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.undo.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.search.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.manage.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.finish.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
        widgets.rowList.setTabOrderGroup(widgets.tabOrder.getAndIncrement());
    }

    default public void createExtraWidgets(ListingWidgets<V, L> defaultWidgets) {
    }

    default public void onUndo() {
        this.getWidgets().database.clear();
        this.getWidgets().rowList.clear();
        this.getTweak().sync();
        this.createListRows();
    }

    default public TextureIcon getRowIcon(String listKey) {
        return TextureIcon.EMPTY;
    }

    default public Component getRowTitle(String listKey) {
        MutableComponent formatted = Component.m_237113_((String)this.getLocalizedKey(listKey));
        boolean isAdded = this.isAdded(listKey);
        if (isAdded) {
            formatted.m_7220_((Component)Component.m_237113_((String)" (")).m_7220_((Component)Lang.Tag.NEW.withStyle(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.RESET));
        }
        return this.appendToRowTitle(listKey, formatted);
    }

    private boolean isAdded(String listKey) {
        Object disk;
        Object cache;
        TweakListing<V, L> tweak = this.getTweak();
        boolean isAdded = false;
        Object object = tweak.fromCache();
        if (object instanceof Map) {
            cache = (Map)object;
            object = tweak.fromDisk();
            if (object instanceof Map) {
                disk = (Map)object;
                if (cache.containsKey(listKey) && !disk.containsKey(listKey)) {
                    isAdded = true;
                }
            }
        }
        if ((object = tweak.fromCache()) instanceof Set) {
            cache = (Set)object;
            object = tweak.fromDisk();
            if (object instanceof Set) {
                disk = (Set)object;
                if (cache.contains(listKey) && !disk.contains(listKey)) {
                    isAdded = true;
                }
            }
        }
        return isAdded;
    }

    default public Component appendToRowTitle(String listKey, MutableComponent rowTitle) {
        return rowTitle;
    }

    default public void createListRows() {
        HashMap<Pair<String, V>, String> localized = this.getLocalizedEntries(this.getEntries());
        this.getWidgets().rowList.clear();
        localized.entrySet().stream().sorted(Map.Entry.comparingByValue(String::compareToIgnoreCase)).forEach(this::addRowToBottom);
        this.getWidgets().sorted.clear();
        this.getWidgets().sorted.addAll(this.getWidgets().rowList.getRows());
    }

    private void addRowToBottom(Map.Entry<Pair<String, V>, String> entry) {
        V value;
        String key = entry.getKey().left();
        AbstractRow<?, ?> row = this.getRow(key, value = entry.getKey().right());
        if (row != null) {
            this.getWidgets().database.put(this.getLocalizedKey(key), row);
            this.getWidgets().rowList.addBottomRow(row);
        }
    }
}

