/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ManageListOverlay;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButton;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInput;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.client.search.GenericDatabase;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ListingWidgets<V, L extends Listing<V, L>> {
    private final Overlay overlay;
    public final RowList rowList;
    public final ButtonWidget add;
    public final ButtonWidget manage;
    public final ButtonWidget undo;
    public final GenericInput search;
    public final ButtonWidget finish;
    public final SeparatorWidget separator;
    public final IntegerHolder tabOrder;
    public final LinkedHashSet<ButtonWidget> shrinkable;
    final ListingOverlay<V, L> listingOverlay;
    final LinkedHashSet<AbstractRow<?, ?>> sorted;
    final GenericDatabase<AbstractRow<?, ?>> database;
    @Nullable
    AbstractRow<?, ?> highlighted;

    public ListingWidgets(ListingOverlay<V, L> listingOverlay) {
        this.listingOverlay = listingOverlay;
        this.overlay = listingOverlay.getOverlay();
        this.sorted = new LinkedHashSet();
        this.shrinkable = new LinkedHashSet();
        this.database = new GenericDatabase();
        this.tabOrder = IntegerHolder.create(0);
        BlankWidget anchor = ((BlankBuilder)((BlankBuilder)BlankWidget.create().size(0)).pos(this.overlay::getInsideX, this.overlay::getInsideY)).build(this.overlay::addWidget);
        TextWidget disabled = ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(Lang.Listing.DISABLED_WARNING).posY(1)).widthOfScreen(0.8f)).centerInScreenX()).centerAligned().icon(Icons.WARNING).visibleIf(this::isListingDisabled)).build(this.overlay::addWidget);
        ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).height(1)).below(disabled, 1)).extendWidthToScreenEnd(0)).visibleIf(this::isListingDisabled)).build(this.overlay::addWidget);
        BlankWidget.create().renderer((widget, graphics, mouseX, mouseY, partialTick) -> {
            if (this.isListingDisabled()) {
                int x0 = this.overlay.getInsideX();
                int y0 = this.overlay.getInsideY();
                int x1 = this.overlay.getInsideEndX();
                int y1 = disabled.getEndY() + 1;
                RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, Color.ALERT_RED.fromAlpha(0.3f));
            }
        }).build(this.overlay::addWidget);
        this.add = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.ADD).posX(1)).fromScreenEndY(1)).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.ADD)).tooltip(Lang.Button.ADD, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.ADD, 35)).tabOrderGroup(this.tabOrder.getAndIncrement())).disableIf(listingOverlay::isLocked)).onPress(listingOverlay::onAdd)).build(List.of(this.overlay::addWidget, this.shrinkable::add));
        this.separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).above(this.add, 1)).height(1)).extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.rowList = ((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().belowAll(() -> this.isListingDisabled() ? 2 : 0, anchor, disabled)).highlight(0.15, Animate.linear(150L, TimeUnit.MILLISECONDS)).emptyMessage(this::getEmptyMessage).extendHeightTo(this.separator, 0)).extendWidthToScreenEnd(0)).heightOverflowMargin(1).showSelectionBorder().horizontalMargin(2).verticalMargin(2).useSeparators().build(this.overlay::addWidget);
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[2];
        booleanSupplierArray[0] = listingOverlay.getTweak()::isCacheUndoable;
        booleanSupplierArray[1] = listingOverlay::isUnlocked;
        this.undo = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.UNDO).enableIf(CollectionUtil.areAllTrue(booleanSupplierArray))).onPress(listingOverlay::onUndo)).rightOf(this.add, 1)).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.UNDO)).hoverIcon(Icons.UNDO_HOVER)).tooltip(Lang.Button.UNDO, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.UNDO, 35)).build();
        this.finish = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_DONE).icon(Icons.GREEN_CHECK)).onPress(this.overlay::close)).fromScreenEndX(1)).fromScreenEndY(1)).useTextWidth()).padding(5)).build();
        this.manage = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.MANAGE).onPress(() -> new ManageListOverlay(listingOverlay).open())).leftOf(this.finish, 1)).skipFocusOnClick()).useTextWidth()).padding(5)).icon(Icons.MECHANICAL_TOOLS)).tooltip(Lang.Button.MANAGE, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.MANAGE_LISTING, 35)).disableIf(listingOverlay::isLocked)).build(this.overlay::addWidget);
        this.search = (GenericInput)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)GenericInput.create().onInput(this::find)).icon(Icons.SEARCH)).whenEmpty(Lang.Input.SEARCH)).border(Color.BLACK, Color.WHITE)).background(Color.OLIVE_BLACK, Color.OLIVE_BLACK)).maxLength(100)).searchShortcut()).extendWidthTo(this.manage, 1)).rightOf(this.undo, 1)).afterSync(this::resizeSearch)).build();
        listingOverlay.createExtraWidgets(this);
        listingOverlay.setTabOrder(this);
        this.overlay.addWidgets(new DynamicWidget[]{this.undo, this.finish, this.manage, this.search});
        this.shrinkable.add(this.undo);
    }

    private void resizeSearch(GenericInput search) {
        if (search.m_5711_() >= 120) {
            return;
        }
        this.shrinkable.forEach(AbstractButton::shrink);
        ((GenericInputBuilder)search.getBuilder()).sync();
    }

    private boolean isListingDisabled() {
        return this.listingOverlay.getListing().isDisabled();
    }

    public void findAndHighlight(String string, boolean smoothScroll) {
        AbstractRow<?, ?> row = this.database.getFromDatabase(string);
        if (row == null) {
            return;
        }
        this.highlighted = row;
        this.rowList.setFocused(row, smoothScroll);
    }

    public void findAndHighlight(String string) {
        this.findAndHighlight(string, true);
    }

    public Color getColor(AbstractRow<?, ?> row, String key, BooleanSupplier isDeleted) {
        return new Color(() -> {
            if (isDeleted.getAsBoolean()) {
                return Color.fromFormatting(ChatFormatting.RED);
            }
            if (row.isWidgetFocused()) {
                return Color.FRENCH_SKY_BLUE;
            }
            if (row == this.highlighted) {
                return Color.GREEN_APPLE;
            }
            boolean isAdded = switch (this.listingOverlay.getTweak().getCacheMode()) {
                default -> throw new IncompatibleClassChangeError();
                case CacheMode.LOCAL -> {
                    if (!this.listingOverlay.getTweak().fromDisk().containsKey(key)) {
                        yield true;
                    }
                    yield false;
                }
                case CacheMode.NETWORK -> !this.listingOverlay.getTweak().fromServer().containsKey(key);
            };
            return isAdded ? Color.MUGHAL_GREEN : Color.TRANSPARENT;
        });
    }

    private void find(String query) {
        if (query.isEmpty()) {
            this.rowList.clear();
            this.rowList.addAll(this.sorted);
            return;
        }
        this.rowList.clear();
        this.rowList.addAll(this.database.findValues(query));
    }

    private Component getEmptyMessage() {
        if (this.search == null) {
            return Component.m_237119_();
        }
        if (this.search.getInput().isEmpty() && this.rowList.getVisibleRows().isEmpty()) {
            return Lang.Listing.NOTHING_SAVED.get(new Object[0]);
        }
        return Lang.Listing.NOTHING_FOUND.get(new Object[0]);
    }

    public void renderOutline(AbstractRow<?, ?> row, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color color = row.getHighlightColor();
        if (color.isEmpty()) {
            return;
        }
        RenderUtil.outline(graphics, (float)row.m_252754_(), (float)row.m_252907_(), (float)row.m_5711_(), (float)row.m_93694_(), color);
    }
}

