/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.add;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.add.SuggestionOverlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInput;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.suggestion.InputSuggester;
import mod.adrenix.nostalgic.client.gui.widget.input.suggestion.ParticleSuggester;
import mod.adrenix.nostalgic.client.gui.widget.input.suggestion.SoundSuggester;
import mod.adrenix.nostalgic.tweak.listing.ListingSuggestion;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class StringOverlay {
    private final StringSet stringSet;
    private final Consumer<String> onFinish;
    private final Runnable onEmpty;
    private final String startWith;
    final ButtonWidget suggestion;
    final ButtonWidget cancel;
    final ButtonWidget done;
    final GenericInput input;
    final Overlay overlay;

    public StringOverlay(StringSet stringSet, Runnable onEmpty, Consumer<String> onFinish, @Nullable String startWith) {
        int padding = 2;
        this.stringSet = stringSet;
        this.onEmpty = onEmpty;
        this.onFinish = onFinish;
        this.startWith = startWith;
        this.overlay = Overlay.create(Lang.Listing.ADD).icon(Icons.SMALL_ADD).runOnKeyPressed(this::onKeyPressed).resizeWidthUsingPercentage(0.6, 215).resizeHeightForWidgets().padding(padding).build();
        Function<GenericInput, InputSuggester> suggester = switch (stringSet.getSuggestion()) {
            default -> throw new IncompatibleClassChangeError();
            case ListingSuggestion.PARTICLE -> ParticleSuggester::new;
            case ListingSuggestion.SOUND -> SoundSuggester::new;
            case ListingSuggestion.NONE -> null;
        };
        this.input = ((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)GenericInput.create().suggester(suggester)).startWith(startWith == null ? "" : startWith)).whenEmpty(Lang.Input.TYPE)).background(Color.BLACK, Color.INK_BLACK)).extendWidthToScreenEnd(0)).border(this::getUnfocusedColor, this::getFocusedColor)).tooltip(this::getTooltip, 45)).build(this.overlay::addWidget);
        this.suggestion = suggester != null ? ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SUGGESTIONS).icon(Icons.SMALL_INFO)).hoverIcon(Icons.SMALL_INFO_HOVER)).tooltip(Lang.Listing.OPEN_SUGGESTIONS, 35, 1L, TimeUnit.SECONDS)).extendWidthToScreenEnd(0)).onPress(() -> new SuggestionOverlay(this.input).open())).below(this.input, padding)).build(this.overlay::addWidget) : null;
        this.cancel = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_CANCEL).icon(Icons.RED_X)).onPress(this.overlay::close)).build();
        this.done = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_DONE).onPress(this::close)).disableIf(this::isInputAdded)).icon(Icons.GREEN_CHECK)).build();
        ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.overlay, 2).extendWidthToScreenEnd(0)).columnSpacing(padding).below(this.suggestion == null ? this.input : this.suggestion, padding)).addCells(this.cancel, this.done).build(this.overlay::addWidget);
        this.overlay.m_7522_(this.input);
        this.input.moveCursorToEnd(false);
    }

    public StringOverlay(StringSet stringSet, Runnable onEmpty, Consumer<String> onFinish) {
        this(stringSet, onEmpty, onFinish, null);
    }

    public void open() {
        this.overlay.open();
    }

    private void close() {
        String input = this.input.getInput();
        if (this.isInputAdded() || input.isEmpty() || input.isBlank()) {
            this.onEmpty.run();
        } else {
            this.onFinish.accept(input);
        }
        this.overlay.close();
    }

    private boolean isInputAdded() {
        String input = this.input.getInput();
        return !input.equals(this.startWith) && this.stringSet.containsKey(input);
    }

    private int getUnfocusedColor() {
        if (this.input == null) {
            return 0;
        }
        return this.isInputAdded() ? Color.RED.get() : Color.GRAY.get();
    }

    private int getFocusedColor() {
        if (this.input == null) {
            return 0;
        }
        return this.isInputAdded() ? Color.RED.get() : Color.WHITE.get();
    }

    private boolean onKeyPressed(Overlay overlay, int keyCode, int scanCode, int modifiers) {
        if (KeyboardUtil.isReturnOrEnter(keyCode) && this.input.m_93696_()) {
            this.close();
            return true;
        }
        if (KeyboardUtil.isSearching(keyCode) && this.suggestion != null) {
            this.suggestion.onPress();
            return true;
        }
        return false;
    }

    private Component getTooltip() {
        return this.isInputAdded() ? Lang.Listing.INPUT_COPIED.get(new Object[0]) : Component.m_237119_();
    }
}

