/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchGroup;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageGroup;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.client.search.SearchTag;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class GroupToggleAll
extends ManageGroup {
    @Override
    void define(ManageOverlay manager) {
        Group heading = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).forceRelativeY()).icon(Icons.LIGHTNING).title(Lang.Button.TOGGLE_ALL_TWEAKS).border(Color.SCHOOL_BUS).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        ((TextBuilder)TextWidget.create(Lang.Manage.TOGGLE_ALL_HEADER).width(heading::getInsideWidth)).build(heading::addWidget);
        Group toggles = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.FILTER).title(Lang.Button.FILTER).border(Color.NOSTALGIC_GRAY).below(heading, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        NullableHolder below = NullableHolder.empty();
        record FilterTag(SearchTag tag, FlagHolder holder, SwitchGroup group) {
            public static FilterTag create(WidgetHolder parent, SearchTag tag) {
                FlagHolder holder = FlagHolder.off();
                Translation title = Lang.literal(TextUtil.toTitleCase(tag.toString()));
                Translation description = tag.getDescription();
                SwitchGroup group = SwitchGroup.create(parent, title, description, holder::get, holder::set);
                return new FilterTag(tag, holder, group);
            }

            public boolean isActive() {
                return (Boolean)this.holder.get();
            }
        }
        LinkedHashSet<FilterTag> tagFilters = new LinkedHashSet<FilterTag>();
        record FilterCategory(Container category, FlagHolder holder) {
            public static FilterCategory create(Container category) {
                if (!category.isCategory()) {
                    throw new AssertionError((Object)"Given container is not a category!");
                }
                return new FilterCategory(category, FlagHolder.off());
            }

            public void checkbox(ManageOverlay overlay, Group group, @Nullable DynamicWidget<?, ?> below) {
                ButtonWidget checkbox = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.EMPTY, this.holder::get).skipFocusOnClick()).below(below, overlay.padding * 2)).onPress(this.holder::toggle)).build(group::addWidget);
                BlankWidget guide = ((BlankBuilder)((BlankBuilder)BlankWidget.create().pos(checkbox::m_252754_, checkbox::m_252907_)).size(Icons.CHECKBOX::getWidth, Icons.CHECKBOX::getHeight)).build(group::addWidget);
                TextWidget text = ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.category.toString()).icon(this.category.getIcon()).color(this.category.getColor()).brightenIconOnHover(1.2f).useTextWidth().centerVertical().rightOf(guide, 4)).height(Icons.CHECKBOX::getHeight)).hoverOrFocusColor(this.category.getColor().brighten(0.35)).hoverOrFocusSync(checkbox)).centerInWidgetY(checkbox)).build(group::addWidget);
                ((ButtonBuilder)checkbox.getBuilder()).extendWidthToEnd(text, -1);
            }

            public boolean isActive() {
                return (Boolean)this.holder.get();
            }
        }
        LinkedHashSet<FilterCategory> categoryFilters = new LinkedHashSet<FilterCategory>();
        for (Container container : Container.CATEGORIES) {
            categoryFilters.add(FilterCategory.create(container));
        }
        ForEachWithPrevious.create(categoryFilters).applyToFirst(category -> category.checkbox(manager, toggles, null)).forEach((prev, next) -> next.checkbox(manager, toggles, (DynamicWidget)((UniqueArrayList)toggles.getWidgets()).getLast())).run();
        SeparatorWidget separateToggles = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(toggles.getColor()).height(1)).below((DynamicWidget)((UniqueArrayList)toggles.getWidgets()).getLast(), manager.padding * 2)).width(toggles::getInsideWidth)).build(toggles::addWidget);
        below.set(separateToggles);
        for (SearchTag tag : SearchTag.values()) {
            FilterTag filter = FilterTag.create(toggles, tag);
            TextWidget info = (TextWidget)((TextBuilder)((TextBuilder)filter.group().getDescription().extendWidthToEnd(toggles, toggles.getInsidePaddingX())).below((DynamicWidget)below.get(), 4)).build();
            ((ButtonBuilder)filter.group().getToggle().getBuilder()).below((DynamicWidget)below.get(), 4);
            toggles.addWidget(filter.group().getToggle());
            toggles.addWidget(info);
            tagFilters.add(filter);
            below.set(info);
        }
        Group group = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.CLIPBOARD).title(Lang.Button.APPLY).border(Color.DEER_BROWN).below(toggles, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        TextWidget applyInfo = ((TextBuilder)TextWidget.create(Lang.Manage.TOGGLE_ALL_APPLY_INFO).width(group::getInsideWidth)).build(group::addWidget);
        FlagHolder isEnabled = FlagHolder.off();
        ButtonWidget enable = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Manage.TOGGLE_ALL_ENABLE, isEnabled::get).skipFocusOnClick()).tooltip(Lang.Button.ENABLE_ALL, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Manage.TOGGLE_ALL_ENABLE_INFO, 35)).extendWidthToEnd(group, group.getInsidePaddingX())).below(applyInfo, manager.padding * 2)).onPress(isEnabled::toggle)).build(group::addWidget);
        FlagHolder isDisabled = FlagHolder.off();
        ButtonWidget disable = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Manage.TOGGLE_ALL_DISABLE, isDisabled::get).skipFocusOnClick()).tooltip(Lang.Button.DISABLE_ALL, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Manage.TOGGLE_ALL_DISABLE_INFO, 35)).extendWidthToEnd(group, group.getInsidePaddingX())).below(enable, manager.padding)).onPress(isDisabled::toggle)).build(group::addWidget);
        FlagHolder.radio(isEnabled, isDisabled);
        SeparatorWidget stateSeparator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(group.getColor()).height(1)).below(disable, manager.padding * 2)).width(group::getInsideWidth)).build(group::addWidget);
        FlagHolder isLocal = FlagHolder.on();
        ButtonWidget local = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Manage.TOGGLE_ALL_LOCAL, isLocal::get).skipFocusOnClick()).tooltip(Lang.Button.LOCAL, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Manage.TOGGLE_ALL_LOCAL_INFO, 35)).extendWidthToEnd(group, group.getInsidePaddingX())).below(stateSeparator, manager.padding * 2)).onPress(isLocal::toggle)).build(group::addWidget);
        FlagHolder isNetwork = FlagHolder.off();
        ButtonWidget network = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Manage.TOGGLE_ALL_NETWORK, isNetwork::get).skipFocusOnClick()).tooltip(Lang.Button.NETWORK, 35, 500L, TimeUnit.MILLISECONDS)).disabledTooltip(Lang.Tooltip.NOT_CONNECTED_OR_OPERATOR, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Manage.TOGGLE_ALL_NETWORK_INFO, 35)).enableIf(NetUtil::isConnectedAndOperator)).extendWidthToEnd(group, group.getInsidePaddingX())).below(local, manager.padding)).onPress(isNetwork::toggle)).build(group::addWidget);
        FlagHolder.radio(isLocal, isNetwork);
        SeparatorWidget sideSeparator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(group.getColor()).height(1)).below(network, manager.padding * 2)).width(group::getInsideWidth)).build(group::addWidget);
        Grid grid = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)manager.overlay, 2).columnSpacing(1).extendWidthToEnd(group, group.getInsidePaddingX())).below(sideSeparator, manager.padding * 2)).build(group::addWidget);
        BooleanSupplier isToggleEnabled = () -> {
            boolean isStatePicked = (Boolean)isEnabled.get() != false || (Boolean)isDisabled.get() != false;
            boolean isCachePicked = (Boolean)isLocal.get() != false || (Boolean)isNetwork.get() != false;
            return isStatePicked && isCachePicked;
        };
        Runnable onToggleAll = () -> {
            List<Predicate> tagPredicates = tagFilters.stream().filter(FilterTag::isActive).map(FilterTag::tag).map(SearchTag::getPredicate).toList();
            UniqueArrayList predicates = new UniqueArrayList(tagPredicates);
            if (categoryFilters.stream().anyMatch(FilterCategory::isActive)) {
                predicates.add(tweak -> categoryFilters.stream().filter(FilterCategory::isActive).map(FilterCategory::category).anyMatch(category -> category == tweak.getCategory()));
            }
            BiConsumer<Tweak, Object> consumer = (tweak, value) -> {
                TweakListing listing = ClassUtil.cast(tweak, TweakListing.class).orElse(null);
                if (listing != null) {
                    if (((Boolean)isLocal.get()).booleanValue()) {
                        ((Listing)listing.fromLocal()).setDisabled((Boolean)isDisabled.get());
                    } else if (((Boolean)isNetwork.get()).booleanValue()) {
                        ((Listing)listing.fromNetwork()).setDisabled((Boolean)isDisabled.get());
                    }
                } else if (((Boolean)isLocal.get()).booleanValue()) {
                    tweak.setLocal(value);
                } else if (((Boolean)isNetwork.get()).booleanValue()) {
                    tweak.setNetwork(value);
                }
            };
            if (((Boolean)isEnabled.get()).booleanValue()) {
                TweakPool.automated(predicates).forEach(tweak -> consumer.accept((Tweak)tweak, tweak.getDefault()));
            }
            if (((Boolean)isDisabled.get()).booleanValue()) {
                TweakPool.automated(predicates).forEach(tweak -> consumer.accept((Tweak)tweak, tweak.getDisabled()));
            }
        };
        Consumer<ConfigScreen> onReviewAll = config -> {
            RowProvider.ALL.use();
            config.getWidgetManager().setQuery("");
            config.getWidgetManager().setQuery(SearchTag.SAVE.query());
            config.getWidgetManager().populateFromQuery();
            Screen patt13455$temp = manager.overlay.getParentScreen();
            if (patt13455$temp instanceof ConfigScreen) {
                ConfigScreen screen = (ConfigScreen)patt13455$temp;
                screen.m_7522_(config.getWidgetManager().getSearch());
            }
            GuiUtil.getScreenAs(Overlay.class).ifPresent(Overlay::close);
        };
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.TOGGLE_ALL_TWEAKS).icon(Icons.LIGHTNING)).tooltip(Lang.Button.TOGGLE_ALL_TWEAKS, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Manage.TOGGLE_ALL_APPLY_INFO, 35)).enableIf(isToggleEnabled)).onPress(onToggleAll)).build(grid::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.REVIEW_CHANGES).icon(Icons.SEARCH)).tooltip(Lang.Button.REVIEW_CHANGES, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.REVIEW_CHANGES, 35)).onPress(() -> ClassUtil.cast(manager.overlay.getParentScreen(), ConfigScreen.class).ifPresent(onReviewAll))).build(grid::addCell);
    }
}

