/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageOverlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageType;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.FileInspector;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageGroup;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageOverlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.DownloadType;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundApplyBackup;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundDeleteAllBackups;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundDeleteBackup;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundDownloadRequest;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundRequestBackups;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;

public class GroupViewBackups
extends ManageGroup {
    private Viewing viewing = Viewing.CLIENT;
    private ButtonWidget client;
    private ButtonWidget server;
    private RowList clientList;
    private RowList serverList;
    private final ArrayList<BackupObject> backupsForClient = new ArrayList();
    private final ArrayList<BackupObject> backupsForServer = new ArrayList();
    private final int padding = 2;

    @Override
    void define(ManageOverlay manager) {
        this.clear();
        this.client = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Tag.CLIENT).icon(Icons.CLIENT)).onPress(this::setClientView)).backgroundRenderer(this::renderHeader)).build();
        this.server = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Tag.SERVER).icon(Icons.SERVER)).disableIf(NetUtil::isNotConnectedOrOperator)).disabledTooltip(Lang.Manage.VIEW_BACKUPS_DISCONNECTED, 45, 1L, TimeUnit.SECONDS)).onPress(this::setServerView)).backgroundRenderer(this::renderHeader)).build();
        Grid header = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)manager.overlay, 2).forceRelativeY()).columnSpacing(0).extendWidthToScreenEnd(0)).rightOf(manager.separator, manager.padding)).addCells(this.client, this.server).build(this::register);
        Grid footer = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)manager.overlay, 3).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).fromScreenEndY(0)).columnSpacing(1).build(this::register);
        SeparatorWidget separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.WHITE).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).above(footer, 1)).height(1)).build(this::register);
        this.clientList = ((RowListBuilder)((RowListBuilder)((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().below(header, 0)).extendHeightTo(separator, 0)).extendWidthToScreenEnd(0)).rightOf(manager.separator, manager.padding)).emptyMessage(Lang.Manage.VIEW_BACKUPS_EMPTY).highlight(0.15, Animate.linear(150L, TimeUnit.MILLISECONDS)).invisibleIf(CollectionUtil.areAnyTrue(this::isViewingServer, this::isGroupInvisible))).heightOverflowMargin(this.padding).showSelectionBorder().useSeparators().build(this::register);
        this.serverList = ((RowListBuilder)((RowListBuilder)((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().below(header, 0)).extendHeightTo(separator, 0)).extendWidthToScreenEnd(0)).rightOf(manager.separator, manager.padding)).emptyMessage(Lang.Manage.VIEW_BACKUPS_EMPTY).highlight(0.15, Animate.linear(150L, TimeUnit.MILLISECONDS)).invisibleIf(CollectionUtil.areAnyTrue(this::isViewingClient, this::isGroupInvisible))).heightOverflowMargin(this.padding).showSelectionBorder().useSeparators().build(this::register);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.openFolder(PathUtil.getBackupPath()).tooltip(Lang.Button.OPEN_FOLDER, 40, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.OPEN_BACKUP_FOLDER, 40)).disableIf(this::isViewingServer)).build(footer::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.REFRESH).icon(Icons.BOOK_CLOSED)).tooltip(Lang.Button.REFRESH, 40, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.REFRESH_VIEW, 40)).onPress(this::refreshAll)).build(footer::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE_ALL).icon(Icons.RED_TRASH_CAN)).tooltip(Lang.Button.DELETE_ALL, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.DELETE_ALL_BACKUPS, 40)).holdFor(2L, TimeUnit.SECONDS)).onPress(this::deleteAll)).build(footer::addCell);
        this.setClientView();
    }

    private void clear() {
        this.viewing = Viewing.CLIENT;
        this.backupsForClient.clear();
        this.backupsForServer.clear();
        NullableAction.attempt(this.clientList, RowList::clear);
        NullableAction.attempt(this.serverList, RowList::clear);
    }

    @Override
    public void setInvisible() {
        super.setInvisible();
        this.clear();
        this.setClientView();
    }

    private boolean isViewingClient() {
        return this.viewing == Viewing.CLIENT;
    }

    private boolean isViewingServer() {
        return this.viewing == Viewing.SERVER;
    }

    private DynamicWidget<?, ?> getBackupRowInformation(Row row, BackupObject backup) {
        IconWidget book = ((IconFactory)IconTemplate.text(Icons.BOOK_OPEN).pos(this.padding, this.padding)).build(row::addWidget);
        TextWidget filename = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Manage.VIEW_BACKUPS_FILENAME).color(Color.fromFormatting(ChatFormatting.GRAY)).extendWidthToEnd(row, this.padding)).rightOf(book, this.padding * 2)).build(row::addWidget);
        TextWidget json = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(backup.getFilename()).extendWidthToEnd(row, this.padding)).alignFlushTo(filename)).below(filename, this.padding)).build(row::addWidget);
        IconWidget floppy = ((IconFactory)((IconFactory)IconTemplate.text(Icons.SAVE_FLOPPY).alignFlushTo(book)).below(json, this.padding * 2)).build(row::addWidget);
        TextWidget created = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(Lang.Manage.VIEW_BACKUPS_LAST_MODIFIED).color(Color.fromFormatting(ChatFormatting.GRAY)).extendWidthToEnd(row, this.padding)).rightOf(floppy, this.padding * 2)).below(json, this.padding * 2)).build(row::addWidget);
        return ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(PathUtil.parseEpochTime(backup.getTimestamp())).extendWidthToEnd(row, this.padding)).alignFlushTo(created)).below(created, this.padding)).build(row::addWidget);
    }

    private void setClientView() {
        this.viewing = Viewing.CLIENT;
        this.backupsForClient.clear();
        this.clientList.clear();
        try {
            List<Path> files = PathUtil.getNewestModified(PathUtil.getBackupPath(), PathUtil::isJsonFile);
            for (Path path : files) {
                this.backupsForClient.add(BackupObject.create(path));
            }
        }
        catch (IOException exception) {
            MessageOverlay.create(MessageType.RED_WARNING, Lang.Error.IO_TITLE, Lang.Error.VIEW_CLIENT_BACKUPS).addButton(ButtonTemplate.openFolder(PathUtil.getLogsPath())).setResizePercentage(0.65).build().open();
            NostalgicTweaks.LOGGER.error("[I/O Error] Could not read files within backup directory\n%s", exception);
        }
        for (BackupObject backup : this.backupsForClient) {
            Row row = (Row)Row.create(this.clientList).build();
            DynamicWidget<?, ?> bottom = this.getBackupRowInformation(row, backup);
            Grid grid = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)row, 2).below(bottom, this.padding)).alignFlushTo(bottom)).extendWidthToEnd(row, this.padding)).columnSpacing(1).build(row::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.INSPECT).icon(Icons.SEARCH)).tooltip(Lang.Button.INSPECT, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.INSPECT_BACKUP, 40)).holdFor(500L, TimeUnit.MILLISECONDS)).onPress(() -> this.inspectBackup(backup))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.EDIT).icon(Icons.PENCIL)).tooltip(Lang.Button.EDIT, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.EDIT_BACKUP, 40)).holdFor(500L, TimeUnit.MILLISECONDS)).onPress(() -> Util.m_137581_().m_137644_(backup.getPath().toFile()))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.APPLY).icon(Icons.GREEN_CHECK)).tooltip(Lang.Button.APPLY, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.APPLY_CLIENT_BACKUP, 40)).holdFor(1L, TimeUnit.SECONDS)).onPress(() -> this.applyClientBackup(backup))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE).icon(Icons.TRASH_CAN)).tooltip(Lang.Button.DELETE, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.DELETE_BACKUP, 40)).holdFor(1L, TimeUnit.SECONDS)).onPress(() -> this.deleteClientBackup(backup))).build(grid::addCell);
            this.clientList.addBottomRow(row);
        }
    }

    private void waitForServer() {
        this.backupsForServer.clear();
        this.serverList.clear();
        ((RowListBuilder)this.serverList.getBuilder()).emptyMessage(Lang.Manage.VIEW_BACKUPS_WAITING);
    }

    private void setServerView() {
        this.viewing = Viewing.SERVER;
        this.waitForServer();
        PacketUtil.sendToServer(new ServerboundRequestBackups());
    }

    void setReceiveFailed() {
        ((RowListBuilder)this.serverList.getBuilder()).emptyMessage(Lang.Manage.VIEW_BACKUPS_EMPTY);
        MessageOverlay.create(MessageType.RED_WARNING, Lang.Error.SERVER_TITLE, Lang.Error.SERVER_BACKUPS).setResizePercentage(0.65).build().open();
    }

    void setServerBackups(Set<BackupObject> backups) {
        ((RowListBuilder)this.serverList.getBuilder()).emptyMessage(Lang.Manage.VIEW_BACKUPS_EMPTY);
        this.backupsForServer.addAll(backups);
        for (BackupObject backup : this.backupsForServer) {
            Row row = (Row)Row.create(this.serverList).build();
            DynamicWidget<?, ?> bottom = this.getBackupRowInformation(row, backup);
            Grid grid = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)row, 2).below(bottom, this.padding)).alignFlushTo(bottom)).extendWidthToEnd(row, this.padding)).columnSpacing(1).build(row::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.INSPECT).icon(Icons.SEARCH)).tooltip(Lang.Button.INSPECT, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.INSPECT_BACKUP, 40)).holdFor(500L, TimeUnit.MILLISECONDS)).onPress(() -> PacketUtil.sendToServer(new ServerboundDownloadRequest(backup, DownloadType.VIEW)))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DOWNLOAD).icon(Icons.EXPORT_FLOPPY)).tooltip(Lang.Button.DOWNLOAD, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.DOWNLOAD_BACKUP, 40)).holdFor(500L, TimeUnit.MILLISECONDS)).onPress(() -> PacketUtil.sendToServer(new ServerboundDownloadRequest(backup, DownloadType.SAVE)))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.APPLY).icon(Icons.GREEN_CHECK)).tooltip(Lang.Button.APPLY, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.APPLY_SERVER_BACKUP, 40)).holdFor(1L, TimeUnit.SECONDS)).onPress(() -> this.applyServerBackup(backup))).build(grid::addCell);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE).icon(Icons.TRASH_CAN)).tooltip(Lang.Button.DELETE, 40, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.DELETE_BACKUP, 40)).holdFor(1L, TimeUnit.SECONDS)).onPress(() -> this.deleteServerBackup(backup))).build(grid::addCell);
            this.serverList.addBottomRow(row);
        }
    }

    private void refreshAll() {
        switch (this.viewing) {
            case CLIENT: {
                this.setClientView();
                break;
            }
            case SERVER: {
                this.setServerView();
            }
        }
    }

    private void applyClientBackup(BackupObject backup) {
        ConfigHandler<ClientConfig> imported = ConfigBuilder.temp(ClientConfig.class, backup.getPath());
        if (imported.load()) {
            ConfigHandler<ClientConfig> handler = ConfigBuilder.getHandler();
            ConfigBuilder.getHandler().backup();
            handler.setLoaded(imported.getLoaded());
            handler.save();
            TweakPool.values().forEach(TweakMeta::sync);
            AfterConfigSave.reloadAndRun();
            NostalgicTweaks.LOGGER.info("[Config Import] Imported a new client config using backup (%s)", backup.getFilename());
            this.setClientView();
        } else {
            MessageOverlay.create(MessageType.RED_WARNING, Lang.Error.APPLY_TITLE, Lang.Error.APPLY_MESSAGE).setResizePercentage(0.65).build().open();
        }
    }

    private void applyServerBackup(BackupObject backup) {
        this.waitForServer();
        PacketUtil.sendToServer(new ServerboundApplyBackup(backup));
    }

    private void deleteClientBackup(BackupObject backup) {
        try {
            PathUtil.deleteWithoutCatch(backup.getPath());
        }
        catch (IOException exception) {
            MessageOverlay.create(MessageType.RED_WARNING, Lang.Error.IO_TITLE, Lang.Error.DELETE_CLIENT_BACKUP).addButton(ButtonTemplate.openFolder(PathUtil.getLogsPath())).setResizePercentage(0.65).build().open();
            NostalgicTweaks.LOGGER.error("[I/O Exception] Could not delete config backup file\n%s", exception);
        }
        this.setClientView();
    }

    private void deleteServerBackup(BackupObject backup) {
        this.waitForServer();
        PacketUtil.sendToServer(new ServerboundDeleteBackup(backup));
    }

    private void deleteAll() {
        switch (this.viewing) {
            case CLIENT: {
                try {
                    List<Path> files = PathUtil.getNewestFiles(PathUtil.getBackupPath(), PathUtil::isJsonFile);
                    for (Path path : files) {
                        PathUtil.deleteWithoutCatch(path);
                    }
                }
                catch (IOException exception) {
                    MessageOverlay.create(MessageType.RED_WARNING, Lang.Error.IO_TITLE, Lang.Error.DELETE_ALL_BACKUPS).addButton(ButtonTemplate.openFolder(PathUtil.getLogsPath())).setResizePercentage(0.65).build().open();
                }
                this.setClientView();
                break;
            }
            case SERVER: {
                this.waitForServer();
                PacketUtil.sendToServer(new ServerboundDeleteAllBackups());
            }
        }
    }

    private void inspectBackup(BackupObject backup) {
        FileInspector.open(backup::getPath, backup::getFilename);
    }

    private void renderHeader(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isActive = false;
        if (this.client.equals(button)) {
            isActive = this.isViewingClient();
        } else if (this.server.equals(button)) {
            isActive = this.isViewingServer();
        }
        Color barColor = isActive ? Color.fromFormatting(ChatFormatting.GOLD) : Color.AZURE_WHITE;
        Color fillColor = barColor.fromAlpha(0.2f);
        if (button.isHoveredOrFocused() && isActive) {
            barColor = Color.RIPE_MANGO;
            fillColor = Color.RIPE_MANGO.fromAlpha(0.2f);
        }
        float startX = button.m_252754_();
        float endX = button.getEndX();
        float barStartY = button.getEndY() - 1;
        float barEndY = button.getEndY();
        float fillStartY = button.m_252907_();
        Color top = barColor.fromAlpha(0.0);
        Color bottom = barColor.fromAlpha(0.3f);
        if (button.isInactive() && button.isHoveredOrFocused()) {
            RenderUtil.gradient(Gradient.vertical(top, bottom), graphics, startX, fillStartY, endX, barStartY);
        } else if (isActive || button.isHoveredOrFocused()) {
            RenderUtil.fill(graphics, startX, fillStartY, endX, barStartY, fillColor.get());
        }
        RenderUtil.fill(graphics, startX, barStartY, endX, barEndY, barColor.get());
    }

    private static enum Viewing {
        CLIENT,
        SERVER;

    }
}

