/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb;

import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb.CrumbWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

class Crumb {
    private final Container container;
    private final CrumbWidget widget;
    private final IconWidget icon;
    private final int index;
    private final int padding;
    private int line = 0;
    private int offset = 0;
    private boolean isLast;

    Crumb(CrumbWidget widget, Container container) {
        this.padding = 3;
        this.widget = widget;
        this.container = container;
        this.index = widget.crumbs.size() + 1;
        this.icon = (IconWidget)IconTemplate.text(container.getIcon()).build();
    }

    public static void setFromPrev(Crumb prev, Crumb next) {
        next.offset = prev.offset + prev.getWidthWithSlash();
        next.line = prev.line;
        int endX = GuiUtil.getScreenWidth();
        if (next.widget.row != null) {
            endX = next.widget.row.getEndX();
        }
        if (next.getX() + next.getWidthWithSlash() > endX) {
            next.offset = 0;
            ++next.line;
        }
    }

    public void setAsLast() {
        this.isLast = true;
    }

    public int getX() {
        return this.widget.m_252754_() + this.offset;
    }

    public int getY() {
        return this.widget.m_252907_() + this.line * this.widget.getLineHeight();
    }

    public int getWidth() {
        int iconWidth = this.icon.m_5711_();
        int textWidth = this.padding + GuiUtil.font().m_92895_(this.container.toString());
        return iconWidth + textWidth;
    }

    public int getWidthWithSlash() {
        return this.getWidth() + GuiUtil.font().m_92852_((FormattedText)CrumbWidget.SLASH);
    }

    public int getMaxWidthFromCrumbLine() {
        return this.widget.crumbs.stream().filter(crumb -> crumb.line == this.line).mapToInt(Crumb::getWidthWithSlash).sum();
    }

    public int getHeight() {
        return this.widget.getLineHeight();
    }

    public int getLineHeight() {
        return (this.line + 1) * this.widget.getLineHeight();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.isWithinBox(mouseX, mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void onClick() {
        GuiUtil.getScreenAs(ConfigScreen.class).ifPresent(screen -> {
            screen.setCategory(this.container.getCategory());
            screen.jumpTo(this.container);
        });
    }

    private ChatFormatting getColor() {
        ChatFormatting color = ChatFormatting.GOLD;
        if (this.index % 6 == 0) {
            color = ChatFormatting.LIGHT_PURPLE;
        } else if (this.index % 5 == 0) {
            color = ChatFormatting.BLUE;
        } else if (this.index % 4 == 0) {
            color = ChatFormatting.AQUA;
        } else if (this.index % 3 == 0) {
            color = ChatFormatting.GREEN;
        } else if (this.index % 2 == 0) {
            color = ChatFormatting.YELLOW;
        }
        return color;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent title = Component.m_237113_((String)this.container.toString());
        if (this.container.isColorEmpty()) {
            title = title.m_6881_().m_130940_(this.getColor());
        }
        if (this.isMouseOver(mouseX, mouseY) && this.widget.isHoveredOrFocused()) {
            title.m_130940_(ChatFormatting.UNDERLINE);
        }
        int x = this.getX();
        int y = this.getY();
        int color = this.container.getColor().get();
        this.icon.pos(x, y);
        this.icon.m_88315_(graphics, mouseX, mouseY, partialTick);
        int nextX = DrawText.begin(graphics, (Component)title).pos(this.icon.getEndX() + this.padding, y).color(color).draw();
        if (!this.isLast) {
            DrawText.begin(graphics, (Component)CrumbWidget.SLASH).pos(nextX, this.getY()).draw();
        }
    }
}

