/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list;

import java.util.Arrays;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.tweak.FavoriteTweak;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;

public enum RowProvider {
    DEFAULT(Tweak::isNotIgnored, Lang.EMPTY, Lang.EMPTY),
    ALL(Tweak::isNotIgnored, Lang.Tooltip.ALL, Lang.Tooltip.ALL_DISABLED),
    FAVORITE(FavoriteTweak::isPresent, Lang.Tooltip.FAVORITE, Lang.Tooltip.FAVORITE_DISABLED);

    private final Predicate<Tweak<?>> predicate;
    private final Translation enabledKey;
    private final Translation disabledKey;
    private boolean providing;

    private RowProvider(Predicate<Tweak<?>> predicate, Translation enabledKey, Translation disabledKey) {
        this.predicate = predicate;
        this.enabledKey = enabledKey;
        this.disabledKey = disabledKey;
        this.providing = false;
    }

    public static RowProvider get() {
        return Arrays.stream(RowProvider.values()).filter(RowProvider::isProviding).findFirst().orElse(DEFAULT);
    }

    private static void reset() {
        Arrays.stream(RowProvider.values()).forEach(provider -> {
            provider.providing = false;
        });
    }

    public void use() {
        RowProvider.reset();
        this.providing = true;
    }

    public void useAndThen(Runnable runnable) {
        this.use();
        runnable.run();
    }

    public Predicate<Tweak<?>> useAndGetPredicate() {
        this.use();
        return this.predicate;
    }

    public boolean test(Tweak<?> tweak) {
        return this.predicate.test(tweak);
    }

    public boolean isProviding() {
        return this.providing;
    }

    public Component getInfoTooltip() {
        return this.isProviding() ? this.disabledKey.get(new Object[0]) : this.enabledKey.get(new Object[0]);
    }
}

