/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list.controller;

import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.controller.Controller;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.enums.EnumTweak;
import mod.adrenix.nostalgic.tweak.factory.TweakEnum;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EnumController {
    private final TweakEnum<?> tweak;
    private final ButtonWidget widget;
    private final Overlay overlay;
    private final int padding = 6;
    private boolean initialized;

    public EnumController(Controller controller, TweakEnum<?> tweak) {
        this.tweak = tweak;
        this.widget = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().width(120)).leftOf(controller.getLeftOf(), 1)).title(this::getTitle)).onPress(this::open)).disableIf(this.tweak::isNetworkLocked)).build();
        this.overlay = Overlay.create().size(183, 130).setX(this.widget::m_252754_).padding(this.padding).aboveOrBelow(this.widget, 1).backgroundColor(new Color(0, 0, 0, 235)).shadowColor(new Color(0, 0, 0, 80)).scissorPadding(3).resizeHeightForWidgets().unmovable().borderless().build();
    }

    public ButtonWidget getWidget() {
        return this.widget;
    }

    private void open() {
        if (this.initialized) {
            this.overlay.open();
        } else {
            this.initialized = true;
            this.build();
            this.overlay.open();
        }
    }

    private Component getTitle() {
        return ((EnumTweak)((Object)((Enum)this.tweak.fromCache()))).getTitle().get(new Object[0]);
    }

    private void fromEnum(Enum<?> value, NullableHolder<SeparatorWidget> separator) {
        MutableComponent title = ClassUtil.cast(value, EnumTweak.class).map(EnumTweak::getTitle).orElse(Lang.literal(value.name())).get(new Object[0]);
        ButtonWidget checkbox = ((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox((Component)title, () -> ((Enum)this.tweak.fromCache()).equals(value)).onPress(() -> this.tweak.setCacheValue(value))).iconTextPadding(this.padding)).build(this.overlay::addWidget);
        if (separator.isEmpty()) {
            ((ButtonBuilder)checkbox.getBuilder()).pos(0, 0);
        } else {
            ((ButtonBuilder)checkbox.getBuilder()).below((DynamicWidget)separator.get(), this.padding);
        }
        TextWidget description = (TextWidget)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.tweak.getEnumDescription(value)).posX(checkbox::m_252754_)).below(checkbox, this.padding)).extendWidthToScreenEnd(this.padding)).build();
        boolean isDescribed = this.tweak.isEnumDescribed(value);
        if (isDescribed) {
            this.overlay.addWidget(description);
        }
        separator.set(((SeparatorBuilder)SeparatorWidget.create(Color.GRAY).extendWidthToScreenEnd(this.padding)).build(this.overlay::addWidget));
        if (isDescribed) {
            separator.map(DynamicWidget::getBuilder).ifPresent(builder -> ((SeparatorBuilder)builder.below(description, this.padding)).posX(description::m_252754_));
        } else {
            separator.map(DynamicWidget::getBuilder).ifPresent(builder -> ((SeparatorBuilder)builder.below(checkbox, this.padding)).posX(checkbox::m_252754_));
        }
    }

    private void build() {
        NullableHolder holder = NullableHolder.empty();
        Stream.of((Enum[])((Enum)this.tweak.fromCache()).getDeclaringClass().getEnumConstants()).forEach(value -> this.fromEnum((Enum<?>)value, holder));
        this.overlay.removeWidget((DynamicWidget)holder.get());
    }
}

