/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list.controller;

import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.controller.Controller;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInput;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInputMaker;
import mod.adrenix.nostalgic.client.gui.widget.input.ColorInput;
import mod.adrenix.nostalgic.client.gui.widget.input.ColorInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInput;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakColor;
import mod.adrenix.nostalgic.tweak.factory.TweakText;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import org.jetbrains.annotations.Nullable;

public class StringController {
    private final Controller controller;
    @Nullable
    private final TweakText text;
    @Nullable
    private final TweakColor color;

    public StringController(Controller controller, @Nullable TweakText text) {
        this.controller = controller;
        this.text = text;
        this.color = null;
    }

    public StringController(Controller controller, @Nullable TweakColor color) {
        this.controller = controller;
        this.color = color;
        this.text = null;
    }

    private Tweak<String> getTweak() {
        if (this.text != null) {
            return this.text;
        }
        return this.color;
    }

    private void onPickerClose(ColorPicker picker) {
        if (this.color == null) {
            return;
        }
        int[] storage = this.color.isOpaque() ? new int[3] : new int[4];
        this.color.setCacheValue(HexUtil.parseString(picker.getColor().getIntComponents(storage)));
    }

    public AbstractInput<?, ?> getWidget() {
        Object builder = GenericInput.create().maxLength(100);
        if (this.color != null) {
            builder = ColorInput.create(new Color(HexUtil.parseInt((String)this.color.get()))).colorPicker(this::onPickerClose);
            if (this.color.isOpaque()) {
                ((ColorInputBuilder)builder).opaque();
            }
        }
        return (AbstractInput)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)((AbstractInputMaker)builder).onInput(this.getTweak()::setCacheValue)).onSync(this.getTweak()::fromCache)).startWith((String)this.getTweak().fromCache()).disableIf(this.getTweak()::isNetworkLocked)).leftOf(this.controller.getLeftOf(), 1)).width(this.color == null ? 120 : 99)).background(Color.BLACK)).border(Color.WHITE)).hover(Color.FRENCH_SKY_BLUE, Color.BLACK).build();
    }
}

