/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.tab;

import java.util.List;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tab.TabBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButton;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TabButton
extends AbstractButton<TabBuilder, TabButton> {
    public static final Color DARK_BORDER = Color.BLACK.fromAlpha(0.7f);
    public static final Color WHITE_BORDER = Color.WHITE;
    public static final Color LIGHT_BORDER = Color.SILVER_CHALICE;
    public static final Color TAB_BACKGROUND = Color.PHILIPPINE_GRAY;
    public static final Color TAB_OVER_BACKGROUND = Color.QUICK_SILVER;
    private final Container category;
    private final ConfigScreen configScreen;
    private boolean isLeftHidden = false;
    private boolean isRightHidden = false;

    public static TabBuilder create(ConfigScreen configScreen, Container category) {
        if (!category.isCategory()) {
            throw new AssertionError((Object)"Tab buttons must point to a category");
        }
        return new TabBuilder(configScreen, category);
    }

    protected TabButton(TabBuilder builder, Consumer<TabButton> onPress) {
        super(builder, onPress);
        this.configScreen = builder.configScreen;
        this.category = builder.category;
        builder.onPress(this::select);
        builder.renderer(this::renderer);
        builder.icon(this.category.getIcon(), GuiUtil.textHeight() - 1);
        builder.width(GuiUtil.textHeight() + 1 + GuiUtil.font().m_92852_((FormattedText)this.getTitle()) + 30);
        class Overflow
        implements DynamicFunction<TabBuilder, TabButton> {
            Overflow() {
            }

            @Override
            public void apply(TabButton button, TabBuilder builder) {
            }

            @Override
            public boolean isReapplyNeeded(TabButton button, TabBuilder builder, WidgetCache cache) {
                if (button.isOverflow()) {
                    button.setHiddenRight();
                } else {
                    button.setVisibleRight();
                }
                return false;
            }

            @Override
            public List<DynamicField> getManaging(TabBuilder builder) {
                return List.of();
            }
        }
        ((TabBuilder)this.getBuilder()).addFunction(new Overflow());
    }

    public Container getCategory() {
        return this.category;
    }

    public void select() {
        this.configScreen.setCategory(this.category);
    }

    public boolean isSelected() {
        return this.category == this.configScreen.getCategory() && RowProvider.DEFAULT.isProviding();
    }

    public boolean isOverflow() {
        return this.getEndX() > this.configScreen.f_96543_;
    }

    public boolean isRealignNeeded() {
        return this.isSelected() && (this.isOverflow() || this.isLeftHidden);
    }

    public boolean isHiddenRight() {
        return this.isRightHidden;
    }

    public boolean isHiddenLeft() {
        return this.isLeftHidden;
    }

    public void setHiddenRight() {
        this.isRightHidden = true;
    }

    public void setVisibleRight() {
        this.isRightHidden = false;
    }

    public void setHiddenLeft() {
        this.isLeftHidden = true;
    }

    public void setVisibleLeft() {
        this.isLeftHidden = false;
    }

    public void setAtStartPosition() {
        this.m_252865_(this.configScreen.getWidgetManager().getTabRight().getEndX() + 1);
    }

    @Override
    public boolean isVisible() {
        return !this.isLeftHidden;
    }

    public void renderer(TabButton button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int endY;
        boolean isSelected = this.isSelected();
        boolean isHoverOrFocused = this.isHoveredOrFocused();
        int startY = isSelected ? this.y : this.y + 5 - (isHoverOrFocused ? 1 : 0);
        int startX = this.m_252754_();
        int height = this.m_93694_();
        int width = this.m_5711_();
        int endX = startX + width;
        int n = isSelected ? startY + height : (endY = startY + height - (isHoverOrFocused ? 5 : 6));
        if (!this.isVisible()) {
            if (isSelected) {
                RenderUtil.hLine(graphics, 0.0f, (float)(endY - 1), (float)GuiUtil.getScreenWidth(), LIGHT_BORDER);
            }
            return;
        }
        RenderUtil.beginBatching();
        int background = this.category.getColor(TAB_BACKGROUND).darken(0.25).get();
        int overBackground = this.category.getColor(TAB_OVER_BACKGROUND).darken(0.2).get();
        if (isSelected) {
            int dx = this.getEndX();
            int dy = this.getEndY();
            int selectOverBackground = new Color(overBackground).brighten(0.05).get();
            RenderUtil.fill(graphics, (float)this.m_252754_(), (float)this.m_252907_(), (float)dx, (float)dy, isHoverOrFocused ? selectOverBackground : overBackground);
            RenderUtil.hLine(graphics, 0.0f, (float)(endY - 1), (float)startX, LIGHT_BORDER);
            RenderUtil.hLine(graphics, (float)endX, (float)(endY - 1), (float)this.configScreen.f_96543_, LIGHT_BORDER);
        } else {
            RenderUtil.fill(graphics, (float)startX, (float)startY, (float)endX, (float)endY, isHoverOrFocused ? overBackground : background);
        }
        RenderUtil.vLine(graphics, (float)startX, (float)startY, (float)endY, 0x5CFFFFFF);
        RenderUtil.hLine(graphics, (float)(startX + 1), (float)startY, (float)endX, 0x5CFFFFFF);
        RenderUtil.vLine(graphics, (float)(endX - 1), (float)startY, (float)endY, DARK_BORDER);
        int iconWidth = this.getIconManager().getWidth() + 3;
        int textWidth = GuiUtil.font().m_92852_((FormattedText)this.getTitle());
        int centerX = Math.round(MathUtil.center(startX, textWidth + iconWidth, width)) - 1;
        int centerY = Math.round(DrawText.centerY(startY, isSelected ? height : height - 3));
        this.getIconManager().pos(centerX, centerY);
        this.getIconManager().render(graphics, mouseX, mouseY, partialTick);
        ChatFormatting style = isSelected ? ChatFormatting.UNDERLINE : ChatFormatting.RESET;
        MutableComponent title = Component.m_237113_((String)this.getTitle().getString()).m_130940_(style);
        Color color = isHoverOrFocused ? Color.LEMON_YELLOW : Color.WHITE;
        DrawText.begin(graphics, (Component)title).pos(centerX + iconWidth, centerY).color(color).draw();
        RenderUtil.endBatching();
    }

    public static void arrowRenderer(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color fill;
        boolean isHoveredOrFocused = button.isHoveredOrFocused();
        int startX = button.m_252754_();
        int startY = button.m_252907_();
        int endX = button.getEndX();
        int endY = button.getEndY();
        Color color = fill = isHoveredOrFocused ? TAB_OVER_BACKGROUND : TAB_BACKGROUND;
        if (button.isInactive()) {
            fill = Color.DARK_GRAY;
        }
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, (float)startX, (float)startY, (float)endX, (float)endY, fill);
        RenderUtil.vLine(graphics, (float)startX, (float)startY, (float)endY, button.isActive() ? WHITE_BORDER : TAB_BACKGROUND);
        RenderUtil.hLine(graphics, (float)(startX + 1), (float)startY, (float)endX, button.isActive() ? WHITE_BORDER : TAB_BACKGROUND);
        RenderUtil.vLine(graphics, (float)(endX - 1), (float)startY, (float)endY, DARK_BORDER);
        float textX = DrawText.centerX(button.m_252754_(), button.m_5711_(), button.getTitle());
        float textY = DrawText.centerY(button.m_252907_(), button.m_93694_()) + 1.0f;
        Color color2 = isHoveredOrFocused ? Color.LEMON_YELLOW : Color.WHITE;
        DrawText.begin(graphics, button.getTitle()).pos(textX, textY).color(button.isActive() ? color2 : Color.TAUPE_GRAY).draw();
        RenderUtil.endBatching();
    }
}

