/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.tag;

import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.Tag;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagBuilder;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagType;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakBinding;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import net.minecraft.client.gui.GuiGraphics;

public class TagWidget
extends DynamicWidget<TagBuilder, TagWidget> {
    final LinkedHashSet<Tag> tags = new LinkedHashSet();
    final Tweak<?> tweak;
    final int padding = 2;

    public static TagBuilder create(Tweak<?> tweak) {
        return new TagBuilder(tweak);
    }

    TagWidget(TagBuilder builder) {
        super(builder);
        this.tweak = builder.tweak;
        if (this.tweak.isNew() && ((Boolean)ModTweak.DISPLAY_NEW_TAGS.fromCache()).booleanValue()) {
            this.addTag(TagType.NEW);
        }
        if (this.tweak.isClient()) {
            this.addTag(TagType.CLIENT);
        }
        if (this.tweak.isServer()) {
            this.addTag(TagType.SERVER);
        }
        if (this.tweak.isDynamic()) {
            this.addTag(TagType.DYNAMIC);
        }
        if (this.tweak instanceof TweakBinding) {
            this.addTag(TagType.SYNC);
        }
        if (this.tweak.isResourceReloadRequired()) {
            this.addTag(TagType.RELOAD);
        }
        if (this.tweak.isWarningTag()) {
            this.addTag(TagType.WARNING);
        }
        if (this.tweak.isAlertTag()) {
            this.addTag(TagType.ALERT);
        }
        if (this.tweak.isNotSSO()) {
            this.addTag(TagType.NO_SSO);
        }
        this.setSize();
    }

    private void addTag(TagType tag) {
        this.tags.add(new Tag(this, tag));
    }

    private void setSize() {
        ((TagBuilder)this.getBuilder()).width(this.tags.stream().mapToInt(Tag::getWidth).sum() + this.padding * this.tags.size());
        ((TagBuilder)this.getBuilder()).height(GuiUtil.textHeight() + 2);
        ForEachWithPrevious.create(this.tags).forEach(Tag::setFromPrev).run();
    }

    public Tweak<?> getTweak() {
        return this.tweak;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        if (this.tweak.isAlertTag() && this.tags.stream().noneMatch(Tag::isAlertTag)) {
            this.addTag(TagType.ALERT);
            this.setSize();
        } else if (!this.tweak.isAlertTag() && this.tags.stream().anyMatch(Tag::isAlertTag)) {
            this.tags.removeIf(Tag::isAlertTag);
            this.setSize();
        }
        if (((Boolean)ModTweak.DISPLAY_TAG_TOOLTIPS.fromCache()).booleanValue()) {
            this.tags.forEach(tag -> tag.setTooltip(mouseX, mouseY));
        }
        RenderUtil.beginBatching();
        this.tags.forEach(tag -> tag.render(graphics));
        this.renderDebug(graphics);
        RenderUtil.endBatching();
    }
}

