/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home;

import com.mojang.math.Axis;
import mod.adrenix.nostalgic.client.gui.GearSpinner;
import mod.adrenix.nostalgic.client.gui.screen.EnhancedScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.home.HomeSplash;
import mod.adrenix.nostalgic.client.gui.screen.home.HomeWidgets;
import mod.adrenix.nostalgic.client.gui.screen.home.Panorama;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.SetupOverlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.SodiumOverlay;
import mod.adrenix.nostalgic.client.gui.screen.packs.PacksListScreen;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.enums.MenuOption;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class HomeScreen
extends EnhancedScreen<HomeScreen, HomeWidgets> {
    private static final TextureLocation TITLE_LOCATION = TextureLocation.NOSTALGIC_TWEAKS;
    private boolean isRedirected;
    private HomeWidgets homeWidgets;
    private String splash;

    public HomeScreen(@Nullable Screen parentScreen, boolean isRedirected) {
        super(HomeWidgets::new, parentScreen, (Component)Lang.TITLE.get(new Object[0]));
        this.isRedirected = isRedirected;
    }

    @Override
    public HomeScreen self() {
        return this;
    }

    @Override
    public HomeWidgets getWidgetManager() {
        return this.homeWidgets;
    }

    @Override
    public void setWidgetManager(HomeWidgets widgetManager) {
        this.homeWidgets = widgetManager;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.splash = HomeSplash.getInstance().get();
        this.focusFirst();
        if (this.isRedirected) {
            this.isRedirected = false;
            switch ((MenuOption)ModTweak.DEFAULT_SCREEN.get()) {
                case CONFIG_SCREEN: {
                    this.minecraft.m_91152_((Screen)new ConfigScreen(this));
                    break;
                }
                case PACKS_SCREEN: {
                    this.minecraft.m_91152_((Screen)new PacksListScreen(this));
                    break;
                }
                default: {
                    this.minecraft.m_91152_((Screen)this);
                }
            }
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (!((Boolean)ModTweak.OPENED_CONFIG_SCREEN.get()).booleanValue() && !((Boolean)SodiumOverlay.OPENED.get()).booleanValue()) {
            ModTweak.OPENED_CONFIG_SCREEN.setDiskAndSave(true);
            SetupOverlay.open();
        }
        if (!((Boolean)ModTweak.OPENED_SODIUM_SCREEN.get()).booleanValue() && !((Boolean)SetupOverlay.OPENED.get()).booleanValue() && ModTracker.SODIUM.isInstalled()) {
            ModTweak.OPENED_SODIUM_SCREEN.setDiskAndSave(true);
            SodiumOverlay.open();
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96637_() && KeyboardUtil.match(keyCode, 32)) {
            if (Panorama.isPaused()) {
                Panorama.unpause();
            } else {
                Panorama.pause();
            }
            return true;
        }
        if (KeyboardUtil.isGoingRight(keyCode)) {
            Panorama.forward();
            return true;
        }
        if (KeyboardUtil.isGoingLeft(keyCode)) {
            Panorama.backward();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.f_91073_ == null) {
            Panorama.render(graphics, partialTick);
        } else {
            graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        }
        this.renderTextures(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderTextures(GuiGraphics graphics) {
        float pulseScale = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        float modScale = pulseScale * 12.0f / (float)this.f_96547_.m_92895_("N.T");
        float splashScale = pulseScale * 100.0f / (float)(this.f_96547_.m_92895_(this.splash) + 32);
        float titleScale = 0.15f;
        float gearScale = 0.07f;
        int titleW = Math.round((float)TITLE_LOCATION.getWidth() * titleScale);
        int titleH = Math.round((float)TITLE_LOCATION.getHeight() * titleScale);
        int titleX = Math.round(MathUtil.center(titleW, this.f_96543_));
        int titleY = Math.round((float)GuiUtil.getGuiHeight() * 0.09f);
        int gearY = Math.round((float)GuiUtil.getGuiHeight() - gearScale * 512.0f);
        int gearX = 0;
        float splashX = (float)(titleX + titleW) - 20.0f;
        float splashY = (float)(titleY + titleH) - 2.0f;
        float modX = (float)gearX + gearScale * 512.0f - 12.0f;
        float modY = (float)gearY + gearScale * 512.0f - 9.0f;
        GearSpinner.getInstance().render(graphics, gearScale, gearX, gearY);
        RenderUtil.beginBatching();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)modX, (double)modY, 0.0);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-20.0f));
        graphics.m_280168_().m_85841_(modScale, modScale, modScale);
        DrawText.begin(graphics, "N.T").pos(1, -6).color(Color.YELLOW).center().draw();
        graphics.m_280168_().m_85849_();
        RenderUtil.blitTexture(TITLE_LOCATION, graphics, titleScale, titleX, titleY);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)splashX, (double)splashY, 0.0);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-20.0f));
        graphics.m_280168_().m_85841_(splashScale, splashScale, splashScale);
        DrawText.begin(graphics, this.splash).pos(0, -8).color(Color.YELLOW).center().draw();
        graphics.m_280168_().m_85849_();
        RenderUtil.endBatching();
    }
}

