/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.array.CycleIndex;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public enum Panorama implements PreparableReloadListener
{
    ALPHA,
    BETA,
    CAVE,
    NETHER,
    CLASSIC,
    SLIDE;

    private static final Animation FADE_IN_ANIMATION;
    private static final SimpleTimer SWITCH_TIMER;
    private static final FlagHolder PAUSE_TIMER;
    private static final CycleIndex CYCLE_INDEX;
    private final PanoramaRenderer panorama;
    private final CubeMap cubeMap;

    private static Panorama getDisplaying() {
        return Panorama.values()[CYCLE_INDEX.get()];
    }

    private static Panorama getLastDisplaying() {
        return Panorama.values()[CYCLE_INDEX.getLast()];
    }

    public static void render(GuiGraphics graphics, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (FADE_IN_ANIMATION.isNotFinished()) {
            Panorama.getLastDisplaying().draw(graphics, partialTick);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)FADE_IN_ANIMATION.getValue()));
        Panorama.getDisplaying().draw(graphics, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onTick() {
        if (SWITCH_TIMER.hasElapsed() && !((Boolean)PAUSE_TIMER.get()).booleanValue()) {
            CYCLE_INDEX.cycle();
            FADE_IN_ANIMATION.reset();
            FADE_IN_ANIMATION.play();
        }
    }

    public static void forward() {
        CYCLE_INDEX.forward();
        SWITCH_TIMER.reset();
        FADE_IN_ANIMATION.reset();
        FADE_IN_ANIMATION.play();
    }

    public static void backward() {
        CYCLE_INDEX.backward();
        SWITCH_TIMER.reset();
        FADE_IN_ANIMATION.reset();
        FADE_IN_ANIMATION.play();
    }

    public static void pause() {
        PAUSE_TIMER.enable();
    }

    public static void unpause() {
        PAUSE_TIMER.disable();
    }

    public static boolean isPaused() {
        return (Boolean)PAUSE_TIMER.get();
    }

    private Panorama() {
        String root = "nostalgic_tweaks:textures/panorama/";
        String branch = this.toString().toLowerCase(Locale.ROOT);
        this.cubeMap = new CubeMap(new ResourceLocation(root + branch + "/panorama"));
        this.panorama = new PanoramaRenderer(this.cubeMap);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller prepareProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        return CompletableFuture.runAsync(() -> this.cubeMap.m_108854_(textureManager, backgroundExecutor), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0));
    }

    private void draw(GuiGraphics graphics, float partialTick) {
        this.panorama.m_110003_(partialTick, 1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        graphics.m_280163_(TextureLocation.PANORAMA_OVERLAY, 0, 0, (float)GuiUtil.getScreenWidth(), (float)GuiUtil.getScreenHeight(), 16, 128, 16, 128);
    }

    static {
        FADE_IN_ANIMATION = Animate.linear(4L, TimeUnit.SECONDS);
        SWITCH_TIMER = SimpleTimer.create(15L, TimeUnit.SECONDS).immediate().build();
        PAUSE_TIMER = FlagHolder.off();
        CYCLE_INDEX = new CycleIndex(Panorama.values(), true);
    }
}

