/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home.overlay;

import java.util.function.BiConsumer;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;

public abstract class SetupOverlay {
    public static final FlagHolder OPENED = FlagHolder.off();

    public static Overlay open() {
        Overlay overlay = SetupOverlay.getOverlay();
        OPENED.enable();
        overlay.runOnClose(OPENED::disable);
        return overlay.open();
    }

    private static Overlay getOverlay() {
        int padding = 2;
        Overlay overlay = Overlay.create(Lang.Home.INIT_CONFIG).icon(Icons.SAVE_FLOPPY).padding(padding).resizeUsingPercentage(0.6).resizeHeightForWidgets().build();
        Group setup = ((GroupBuilder)Group.create(overlay).icon(Icons.CLIPBOARD).title(Lang.Home.SETUP).border(Color.DEER_BROWN).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        TextWidget setupInfo = ((TextBuilder)TextWidget.create(Lang.Home.SETUP_INFO).width(setup::getInsideWidth)).build(setup::addWidget);
        SeparatorWidget top = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(setup.getColor()).height(1)).below(setupInfo, padding * 2)).width(setup::getInsideWidth)).build(setup::addWidget);
        FlagHolder defaultFlag = FlagHolder.on();
        FlagHolder disableFlag = FlagHolder.off();
        FlagHolder.radio(defaultFlag, disableFlag);
        ButtonWidget defaultSetup = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Home.DEFAULT, defaultFlag::get).extendWidthToEnd(setup, setup.getInsidePaddingX())).below(top, padding * 2)).onPress(defaultFlag::toggle)).build(setup::addWidget);
        TextWidget defaultInfo = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(Lang.Home.DEFAULT_INFO).posX(Icons.CHECKBOX.getWidth() + 5)).extendWidthToEnd(setup, setup.getInsidePaddingX())).below(defaultSetup, padding)).build(setup::addWidget);
        ButtonWidget disableSetup = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.Home.DISABLE, disableFlag::get).extendWidthToEnd(setup, setup.getInsidePaddingX())).below(defaultInfo, padding * 2)).onPress(disableFlag::toggle)).build(setup::addWidget);
        TextWidget disableInfo = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(Lang.Home.DISABLE_INFO).posX(Icons.CHECKBOX.getWidth() + 5)).extendWidthToEnd(setup, setup.getInsidePaddingX())).below(disableSetup, padding)).build(setup::addWidget);
        SeparatorWidget separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(setup.getColor()).height(1)).below(disableInfo, padding * 2)).width(setup::getInsideWidth)).build(setup::addWidget);
        Grid grid = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)setup, 2).columnSpacing(1).extendWidthToEnd(setup, setup.getInsidePaddingX())).below(separator, padding * 2)).build(setup::addWidget);
        Runnable apply = () -> {
            BiConsumer<Tweak, Object> processor = (tweak, value) -> {
                TweakListing listing = ClassUtil.cast(tweak, TweakListing.class).orElse(null);
                if (listing != null) {
                    ((Listing)listing.fromLocal()).setDisabled((Boolean)disableFlag.get());
                } else {
                    tweak.setLocal(value);
                }
            };
            if (((Boolean)defaultFlag.get()).booleanValue()) {
                TweakPool.automated().forEach(tweak -> processor.accept((Tweak)tweak, tweak.getDefault()));
            }
            if (((Boolean)disableFlag.get()).booleanValue()) {
                TweakPool.automated().forEach(tweak -> processor.accept((Tweak)tweak, tweak.getDisabled()));
            }
            TweakPool.stream().filter(Tweak::isNotIgnored).filter(TweakMeta::isAnyCacheSavable).forEach(Tweak::applyCacheAndSend);
            ConfigCache.save();
            AfterConfigSave.run();
            overlay.close();
        };
        ((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.APPLY).icon(Icons.GREEN_CHECK)).onPress(apply)).build(grid::addCell);
        ((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_CANCEL).icon(Icons.RED_X)).onPress(overlay::close)).build(grid::addCell);
        overlay.m_7522_(defaultSetup);
        return overlay;
    }
}

