/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter;

import com.google.gson.Gson;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.GithubJson;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.PlayerFace;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.SupporterRow;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.InternetTexture;
import mod.adrenix.nostalgic.util.common.LinkLocation;
import mod.adrenix.nostalgic.util.common.ThreadMaker;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.ModAsset;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SupporterOverlay {
    private static final int JSON_VERSION = 2;
    @Nullable
    private static GithubJson cache = null;
    private static boolean isConnecting = false;
    private static boolean isDataInvalid = false;
    private static boolean isVersionWrong = false;
    static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    static final HashSet<String> NAME_KEYS = new HashSet();
    static final HashMap<String, Color> NAMES = new HashMap();
    static final HashMap<String, PlayerFace> FACES = new HashMap();
    final Overlay overlay = Overlay.create(Lang.Home.SUPPORTERS).icon(Icons.HEART).resizeUsingPercentage(0.7).runOnKeyPressed(this::keyPressed).build();
    final RowList rowList = ((RowListBuilder)((RowListBuilder)RowList.create().useSeparators(Color.GRAY, 1, 2).emptyMessage(this::getEmptyMessage).defaultRowHeight(GuiUtil.textHeight()).extendWidthToScreenEnd(0)).extendHeightToScreenEnd(0)).build(this.overlay::addWidget);

    public SupporterOverlay() {
        ButtonWidget reconnect = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.RECONNECT).icon(Icons.REDO)).hoverIcon(Icons.REDO_HOVER)).useTextWidth()).centerInScreenX()).cooldown(4L, TimeUnit.SECONDS)).onPress(this::clearAndReconnect)).visibleIf(this::isReconnectVisible)).enableIf(this::isReconnectActive)).below(this.rowList.getEmptyMessage(), 2)).build(this.overlay::addWidget);
        ((TextBuilder)this.rowList.getEmptyMessage().getBuilder()).centerInWidgetY(this.rowList, () -> reconnect.isVisible() ? 22 : 0);
    }

    private static void checkIfNamesNeedBuilt() {
        if (cache == null && !isConnecting) {
            isConnecting = true;
            ThreadMaker.create(SupporterOverlay.getThreadName(), SupporterOverlay::getSupporterJson, () -> {
                isConnecting = false;
            }).start();
        } else if (cache != null && NAMES.isEmpty()) {
            for (Map.Entry<String, GithubJson.Supporter> entry : SupporterOverlay.cache.supporters.entrySet()) {
                NAME_KEYS.add(entry.getKey());
                NAMES.put(entry.getKey(), new Color(entry.getValue().color));
            }
        }
    }

    public static HashMap<String, Color> getNames() {
        SupporterOverlay.checkIfNamesNeedBuilt();
        return NAMES;
    }

    public static HashSet<String> getNameKeys() {
        SupporterOverlay.checkIfNamesNeedBuilt();
        return NAME_KEYS;
    }

    public void open() {
        if (!((Boolean)ModTweak.OPENED_SUPPORTER_SCREEN.get()).booleanValue()) {
            ModTweak.OPENED_SUPPORTER_SCREEN.setDiskAndSave(true);
        }
        if (cache == null) {
            this.connect();
        } else {
            this.build();
        }
        this.overlay.open();
    }

    private void clearAndReconnect() {
        cache = null;
        isVersionWrong = false;
        isDataInvalid = false;
        FACES.clear();
        this.rowList.clear();
        this.connect();
    }

    private boolean keyPressed(Overlay overlay, int keyCode, int scanCode, int modifiers) {
        if (NostalgicTweaks.isDeveloping() && Screen.m_96638_() && Screen.m_96637_() && keyCode == 73) {
            this.clearAndReconnect();
            return true;
        }
        return false;
    }

    private boolean isReconnectActive() {
        return !isConnecting && !isVersionWrong && !isDataInvalid;
    }

    private boolean isReconnectVisible() {
        return this.rowList.getVisibleRows().isEmpty();
    }

    private Component getEmptyMessage() {
        if (!isConnecting) {
            if (isVersionWrong) {
                return Lang.Home.WRONG_VERSION.withStyle(ChatFormatting.RED);
            }
            if (isDataInvalid) {
                return Lang.Home.INVALID_DATA.withStyle(ChatFormatting.RED);
            }
            return Lang.Home.DISCONNECTED.withStyle(ChatFormatting.RED);
        }
        return Lang.Home.CONNECTING.withStyle(ChatFormatting.YELLOW);
    }

    private static String getThreadName() {
        return "Supporter Connector #" + THREAD_ID.incrementAndGet();
    }

    private static void getSupporterJson() {
        isConnecting = true;
        try {
            Thread.sleep(1000L);
            NostalgicTweaks.LOGGER.info("Connecting to %s", "https://raw.githubusercontent.com/Adrenix/Nostalgic-Tweaks/data/supporters-v2.json");
            URL url = new URI("https://raw.githubusercontent.com/Adrenix/Nostalgic-Tweaks/data/supporters-v2.json").toURL();
            InputStreamReader reader = new InputStreamReader(url.openStream());
            cache = (GithubJson)new Gson().fromJson((Reader)reader, GithubJson.class);
            NostalgicTweaks.LOGGER.info("Successfully downloaded supporter data from GitHub");
            if (cache == null) {
                return;
            }
            if (2L < SupporterOverlay.cache.version) {
                isVersionWrong = true;
                return;
            }
            Map<String, GithubJson.Supporter> fromJson = SupporterOverlay.cache.supporters;
            for (Map.Entry<String, GithubJson.Supporter> supporter : fromJson.entrySet()) {
                String name = supporter.getKey();
                String uuid = supporter.getValue().uuid;
                if (uuid == null) continue;
                ResourceLocation location = ModAsset.supporter(name);
                InternetTexture texture = new InternetTexture(LinkLocation.getSupporterFace(uuid), location);
                FACES.putIfAbsent(name, new PlayerFace(location, texture));
            }
        }
        catch (Exception exception) {
            NostalgicTweaks.LOGGER.error("Could not gather needed supporter data\n%s", exception);
            isDataInvalid = true;
        }
    }

    private void callback() {
        RenderSystem.recordRenderCall(() -> {
            this.build();
            isConnecting = false;
        });
    }

    private void connect() {
        ThreadMaker.create(SupporterOverlay.getThreadName(), SupporterOverlay::getSupporterJson, this::callback).start();
    }

    private void build() {
        if (cache == null || isVersionWrong || isDataInvalid) {
            return;
        }
        FACES.forEach((username, face) -> face.register());
        for (Map.Entry<String, GithubJson.Supporter> entry : SupporterOverlay.cache.supporters.entrySet()) {
            new SupporterRow(this, entry.getKey(), entry.getValue());
        }
    }
}

