/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.pause;

import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.pause.NostalgicPauseScreen;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.mixin.access.PauseScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.PauseLayout;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PauseWidgets
implements WidgetManager {
    private static final int WIDGET_MARGIN = 4;
    private static final int LARGE_MARGIN = 28;
    private static final int LARGE_BUTTON = 200;
    private static final int SMALL_BUTTON = 98;
    private final NostalgicPauseScreen pauseScreen;
    private final Minecraft minecraft;
    private final PauseLayout layout;

    PauseWidgets(NostalgicPauseScreen pauseScreen) {
        this.pauseScreen = pauseScreen;
        this.layout = pauseScreen.getLayout();
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void init() {
        switch (this.layout) {
            case LAN: {
                this.setLanLayout();
                break;
            }
            case ALPHA_BETA: {
                this.setAlphaLayout();
                break;
            }
            case ADVANCEMENT: {
                this.setAdvancementLayout();
                break;
            }
            case ACHIEVE_LOWER: {
                this.setLowerAchieveLayout();
                break;
            }
            case ACHIEVE_UPPER: {
                this.setUpperAchieveLayout();
            }
        }
    }

    private int getX() {
        return this.pauseScreen.f_96543_ / 2 - 100;
    }

    private int getY() {
        return this.pauseScreen.f_96544_ / 4 + 8;
    }

    private boolean isMultiplayer() {
        return NetUtil.isMultiplayer() && !NetUtil.isLocalHost();
    }

    private Component getSaveMessage(boolean isLowercase) {
        MutableComponent lower = Lang.Pause.SAVE_LOWER.get(new Object[0]);
        MutableComponent upper = Lang.Vanilla.MENU_RETURN_TO_TITLE.get(new Object[0]);
        return this.isMultiplayer() ? Lang.Vanilla.MENU_DISCONNECT.get(new Object[0]) : (isLowercase ? lower : upper);
    }

    private void returnToGame() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.m_91152_(null);
        this.minecraft.f_91067_.m_91601_();
    }

    private void saveOrQuit() {
        ((PauseScreenAccess)((Object)this.pauseScreen)).nt$onDisconnect();
    }

    private void gotoOptions() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new OptionsScreen((Screen)this.pauseScreen, this.minecraft.f_91066_));
        }
    }

    private void gotoAdvancements() {
        if (this.minecraft != null && this.minecraft.f_91074_ != null) {
            this.minecraft.m_91152_((Screen)new AdvancementsScreen(this.minecraft.f_91074_.f_108617_.m_105145_()));
        }
    }

    private void gotoStats() {
        if (this.minecraft != null && this.minecraft.f_91074_ != null) {
            this.minecraft.m_91152_((Screen)new StatsScreen((Screen)this.pauseScreen, this.minecraft.f_91074_.m_108630_()));
        }
    }

    private void gotoLan() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new ShareToLanScreen((Screen)this.pauseScreen));
        }
    }

    private void gotoMods() {
        if (this.minecraft != null && GuiUtil.modListScreen != null) {
            this.minecraft.m_91152_(GuiUtil.modListScreen.apply((Screen)this.pauseScreen));
        }
    }

    private void setAlphaLayout() {
        ButtonWidget returnToGame = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Pause.RETURN_LOWER).pos(this.getX(), this.getY() + 16)).width(200)).onPress(this::returnToGame)).build(this.pauseScreen::addWidget);
        ButtonWidget saveAndQuit = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.getSaveMessage(true)).posX(this.getX())).below(returnToGame, 4)).width(200)).onPress(this::saveOrQuit)).build(this.pauseScreen::addWidget);
        if (((Boolean)CandyTweak.INCLUDE_MODS_ON_PAUSE.get()).booleanValue() && GuiUtil.modListScreen != null) {
            ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(saveAndQuit, 28)).width(98)).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).rightOf(options, 4)).width(98)).onPress(this::gotoMods)).build(this.pauseScreen::addWidget);
        } else {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(saveAndQuit, 28)).width(200)).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
        }
    }

    private void setLowerAchieveLayout() {
        ButtonWidget options;
        ButtonWidget returnToGame = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Pause.RETURN_LOWER).pos(this.getX(), this.getY())).width(200)).onPress(this::returnToGame)).build(this.pauseScreen::addWidget);
        ButtonWidget achievements = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Pause.ACHIEVEMENTS).posX(this.getX())).below(returnToGame, 4)).width(98)).onPress(this::gotoAdvancements)).build(this.pauseScreen::addWidget);
        ButtonWidget statistics = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_STATS).rightOf(achievements, 4)).width(98)).onPress(this::gotoStats)).build(this.pauseScreen::addWidget);
        if (((Boolean)CandyTweak.INCLUDE_MODS_ON_PAUSE.get()).booleanValue() && GuiUtil.modListScreen != null) {
            options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).rightOf(options, 4)).width(98)).onPress(this::gotoMods)).build(this.pauseScreen::addWidget);
        } else {
            options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(200)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.getSaveMessage(true)).posX(this.getX())).below(options, 4)).width(200)).onPress(this::saveOrQuit)).build(this.pauseScreen::addWidget);
    }

    private void setUpperAchieveLayout() {
        ButtonWidget options;
        ButtonWidget returnToGame = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_RETURN_TO_GAME).pos(this.getX(), this.getY())).width(200)).onPress(this::returnToGame)).build(this.pauseScreen::addWidget);
        ButtonWidget achievements = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Pause.ACHIEVEMENTS).posX(this.getX())).below(returnToGame, 4)).width(98)).onPress(this::gotoAdvancements)).build(this.pauseScreen::addWidget);
        ButtonWidget statistics = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_STATS).rightOf(achievements, 4)).width(98)).onPress(this::gotoStats)).build(this.pauseScreen::addWidget);
        if (((Boolean)CandyTweak.INCLUDE_MODS_ON_PAUSE.get()).booleanValue() && GuiUtil.modListScreen != null) {
            options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).rightOf(options, 4)).width(98)).onPress(this::gotoMods)).build(this.pauseScreen::addWidget);
        } else {
            options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(200)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.getSaveMessage(false)).posX(this.getX())).below(options, 4)).width(200)).onPress(this::saveOrQuit)).build(this.pauseScreen::addWidget);
    }

    private void setLanLayout() {
        ButtonWidget returnToGame = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_RETURN_TO_GAME).pos(this.getX(), this.getY())).width(200)).onPress(this::returnToGame)).build(this.pauseScreen::addWidget);
        ButtonWidget achievements = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Pause.ACHIEVEMENTS).posX(this.getX())).below(returnToGame, 4)).width(98)).onPress(this::gotoAdvancements)).build(this.pauseScreen::addWidget);
        ButtonWidget statistics = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_STATS).rightOf(achievements, 4)).width(98)).onPress(this::gotoStats)).build(this.pauseScreen::addWidget);
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
        ButtonWidget lan = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_LAN).rightOf(options, 4)).width(98)).disableIf(NetUtil::isMultiplayer)).onPress(this::gotoLan)).build(this.pauseScreen::addWidget);
        ButtonWidget mods = null;
        if (((Boolean)CandyTweak.INCLUDE_MODS_ON_PAUSE.get()).booleanValue() && GuiUtil.modListScreen != null) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).below(lan, 4)).width(200)).posX(this.getX())).onPress(this::gotoMods)).build(this.pauseScreen::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.getSaveMessage(false)).posX(this.getX())).below(mods != null ? mods : lan, 4)).width(200)).onPress(this::saveOrQuit)).build(this.pauseScreen::addWidget);
    }

    private void setAdvancementLayout() {
        ButtonWidget returnToGame = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_RETURN_TO_GAME).pos(this.getX(), this.getY())).width(200)).onPress(this::returnToGame)).build(this.pauseScreen::addWidget);
        ButtonWidget advancements = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_ADVANCEMENTS).posX(this.getX())).below(returnToGame, 4)).width(98)).onPress(this::gotoAdvancements)).build(this.pauseScreen::addWidget);
        ButtonWidget statistics = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_STATS).rightOf(advancements, 4)).width(98)).onPress(this::gotoStats)).build(this.pauseScreen::addWidget);
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(statistics, 28)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.pauseScreen::addWidget);
        ButtonWidget lan = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_LAN).rightOf(options, 4)).width(98)).disableIf(NetUtil::isMultiplayer)).onPress(this::gotoLan)).build(this.pauseScreen::addWidget);
        ButtonWidget mods = null;
        if (((Boolean)CandyTweak.INCLUDE_MODS_ON_PAUSE.get()).booleanValue() && GuiUtil.modListScreen != null) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).below(lan, 4)).width(200)).posX(this.getX())).onPress(this::gotoMods)).build(this.pauseScreen::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.getSaveMessage(false)).posX(this.getX())).below(mods != null ? mods : lan, 4)).width(200)).onPress(this::saveOrQuit)).build(this.pauseScreen::addWidget);
    }
}

