/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.progress;

import mod.adrenix.nostalgic.client.gui.screen.vanilla.progress.ProgressRenderer;
import mod.adrenix.nostalgic.mixin.access.ProgressScreenAccess;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NostalgicProgressScreen
extends ProgressScreen
implements ProgressListener {
    public static final NullableHolder<ResourceKey<Level>> PREVIOUS_DIMENSION = NullableHolder.empty();
    public static final NullableHolder<ResourceKey<Level>> CURRENT_DIMENSION = NullableHolder.empty();
    @Nullable
    private Component header;
    @Nullable
    private Component stage;
    private int progress = -1;
    private boolean stop = false;
    private final ProgressScreenAccess progressScreen;

    public NostalgicProgressScreen(ProgressScreen progressScreen) {
        super(((ProgressScreenAccess)progressScreen).nt$clearScreenAfterStop());
        this.progressScreen = (ProgressScreenAccess)progressScreen;
    }

    public void setHeader(@Nullable Component header) {
        this.header = header;
    }

    public void setStage(@Nullable Component stage) {
        this.stage = stage;
    }

    public boolean hasStage() {
        return this.stage != null;
    }

    private void setHeaderAndStage() {
        boolean isChangingLevel;
        if (this.f_96541_ == null) {
            return;
        }
        if (this.header != null && this.header.getString().equals(Lang.Vanilla.SAVE_LEVEL.getString(new Object[0]))) {
            this.setHeader(null);
            this.setStage((Component)Lang.Level.SAVING.get(new Object[0]));
        }
        ResourceKey<Level> currentDimension = CURRENT_DIMENSION.get();
        ResourceKey<Level> previousDimension = PREVIOUS_DIMENSION.get();
        boolean isTextNeeded = this.header == null && this.stage == null;
        boolean isMultiplayer = this.f_96541_.m_91403_() != null;
        boolean isConnectedLevel = this.f_96541_.f_91073_ != null && isMultiplayer;
        boolean bl = isChangingLevel = this.f_96541_.f_91074_ != null && currentDimension != null && previousDimension != null;
        if (isTextNeeded && (!isMultiplayer || isConnectedLevel) && isChangingLevel) {
            if (currentDimension == Level.f_46429_) {
                this.setHeader((Component)Lang.Level.ENTER_NETHER.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            } else if (currentDimension == Level.f_46430_) {
                this.setHeader((Component)Lang.Level.ENTER_END.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            } else if (currentDimension == Level.f_46428_) {
                if (previousDimension == Level.f_46429_) {
                    this.setHeader((Component)Lang.Level.LEAVING_NETHER.get(new Object[0]));
                    this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
                } else if (previousDimension == Level.f_46430_) {
                    this.setHeader((Component)Lang.Level.LEAVING_END.get(new Object[0]));
                    this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
                }
            }
            if (this.stage == null) {
                this.setHeader((Component)Lang.Level.LOADING.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7730_() {
        this.stop = true;
    }

    public void m_7861_() {
        this.m_7730_();
    }

    public void m_86600_() {
        if (this.progress < 100) {
            ++this.progress;
        }
        super.m_86600_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ == null) {
            return;
        }
        if (this.stop || this.progressScreen.nt$stop()) {
            if (this.progressScreen.nt$clearScreenAfterStop()) {
                this.f_96541_.m_91152_(null);
            }
            return;
        }
        this.setHeaderAndStage();
        if (this.header == null && this.stage == null) {
            return;
        }
        this.m_280039_(graphics);
        ProgressRenderer.renderProgressWithInt(this.progress);
        if (this.header != null) {
            ProgressRenderer.drawHeaderText(graphics, this.header, this.f_96543_);
        }
        if (this.stage != null) {
            ProgressRenderer.drawStageText(graphics, this.stage, this.f_96543_);
        }
    }

    public void m_6309_(Component component) {
        this.m_6308_(component);
    }

    public void m_6308_(Component header) {
        this.setHeader(header);
        this.m_6307_((Component)Component.m_237115_((String)"progress.working"));
    }

    public void m_6307_(Component stage) {
        this.setStage(stage);
        this.m_6952_(0);
    }

    public void m_6952_(int progress) {
        this.progress = progress;
    }
}

