/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.List;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicLogoText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.MatrixUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import org.joml.Matrix4f;

class NostalgicLogoRenderer {
    private LogoEffectRandomizer[][] logoEffects;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final List<String> logo = NostalgicLogoText.getInstance().logo();
    private final int height = NostalgicLogoText.getInstance().size();
    private final int width = NostalgicLogoText.getInstance().longestLine();

    NostalgicLogoRenderer() {
    }

    public void render(float partialTick) {
        int y;
        BakedModel blockModel = this.minecraft.m_91291_().m_115103_().m_109394_(Blocks.f_50069_.m_5456_());
        if (this.logo.isEmpty() || blockModel == null) {
            return;
        }
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[this.width][this.height];
            for (int x = 0; x < this.logoEffects.length; ++x) {
                for (y = 0; y < this.logoEffects[x].length; ++y) {
                    this.logoEffects[x][y] = new LogoEffectRandomizer(x, y);
                }
            }
        }
        LogoEffectRandomizer[][] x = this.logoEffects;
        y = x.length;
        for (int i = 0; i < y; ++i) {
            LogoEffectRandomizer[] logoEffect;
            for (LogoEffectRandomizer logoEffectRandomizer : logoEffect = x[i]) {
                logoEffectRandomizer.update(partialTick);
            }
        }
        Window window = GuiUtil.getWindow();
        int scaleHeight = (int)(120.0 * window.m_85449_());
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().perspective(70.341f, (float)window.m_85441_() / (float)scaleHeight, 0.05f, 100.0f), (VertexSorting)VertexSorting.f_276450_);
        RenderSystem.viewport((int)0, (int)(window.m_85442_() - scaleHeight), (int)window.m_85441_(), (int)scaleHeight);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        float zOffset = MatrixUtil.getZ(modelViewStack);
        modelViewStack.m_252880_(-0.05f, 0.78f, -1.0f * zOffset - 10.0f);
        modelViewStack.m_85841_(1.32f, 1.32f, 1.32f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)true);
        for (int pass = 0; pass < 3; ++pass) {
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
            modelViewStack.m_85836_();
            if (pass == 0) {
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                modelViewStack.m_252880_(0.0f, -0.4f, 0.0f);
                modelViewStack.m_85841_(0.98f, 1.0f, 1.0f);
            }
            if (pass == 1) {
                RenderSystem.disableBlend();
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
            }
            if (pass == 2) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
            modelViewStack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
            modelViewStack.m_85841_(0.89f, 1.0f, 0.4f);
            modelViewStack.m_252880_((float)(-this.width) * 0.5f, (float)(-this.height) * 0.5f, 0.0f);
            if (pass == 0) {
                RenderSystem.setShader(GameRenderer::m_172646_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureLocation.BLOCK_SHADOW);
            } else {
                RenderSystem.setShader(GameRenderer::m_172835_);
                RenderStateShard.f_110146_.m_110185_();
            }
            for (int y2 = 0; y2 < this.height; ++y2) {
                for (int x2 = 0; x2 < this.logo.get(y2).length(); ++x2) {
                    if (this.logo.get(y2).charAt(x2) == ' ') continue;
                    modelViewStack.m_85836_();
                    float z = this.logoEffects[x2][y2].position;
                    float scale = 1.0f;
                    float alpha = 1.0f;
                    if (pass == 0) {
                        scale = z * 0.04f + 1.0f;
                        alpha = 1.0f / scale;
                        z = 0.0f;
                    }
                    modelViewStack.m_252880_((float)x2, (float)y2, z);
                    modelViewStack.m_85841_(scale, scale, scale);
                    this.renderBlock(modelViewStack, (VertexConsumer)builder, blockModel, pass, alpha);
                    modelViewStack.m_85849_();
                }
            }
            Tesselator.m_85913_().m_85914_();
            modelViewStack.m_85849_();
        }
        RenderSystem.disableBlend();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        modelViewStack.m_166856_();
        modelViewStack.m_252880_(0.0f, 0.0f, zOffset);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableCull();
    }

    private void renderBlock(PoseStack modelViewStack, VertexConsumer vertexConsumer, BakedModel blockModel, int pass, float alpha) {
        for (Direction direction : Direction.values()) {
            float brightness = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> 1.0f;
                case Direction.UP -> 0.5f;
                case Direction.NORTH -> 0.0f;
                case Direction.SOUTH -> 0.8f;
                case Direction.WEST, Direction.EAST -> 0.6f;
            };
            for (BakedQuad quad : blockModel.m_213637_(null, direction, RandomSource.m_216327_())) {
                if (pass == 0) {
                    RenderUtil.putTransparentBulkData(modelViewStack.m_85850_(), vertexConsumer, quad, brightness, alpha);
                    continue;
                }
                vertexConsumer.m_85987_(modelViewStack.m_85850_(), quad, brightness, brightness, brightness, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
    }

    private static class LogoEffectRandomizer {
        public float position;
        public float speed;

        public LogoEffectRandomizer(int x, int y) {
            this.position = (float)(10 + y) + RandomSource.m_216327_().m_188501_() * 32.0f + (float)x;
        }

        public void update(float partialTick) {
            if (this.position > 0.0f) {
                this.speed -= 0.4f;
            }
            this.position += this.speed * partialTick;
            this.speed *= 0.9f;
            if (this.position < 0.0f) {
                this.position = 0.0f;
                this.speed = 0.0f;
            }
        }
    }
}

