/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicLogoRenderer;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicLogoText;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.TitleWidgets;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.mixin.access.TitleScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.TitleLayout;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class NostalgicTitleScreen
extends TitleScreen
implements DynamicScreen<NostalgicTitleScreen> {
    private static final ResourceLocation OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private NostalgicLogoRenderer blockLogo;
    private final LogoRenderer imageLogo;
    private final PanoramaRenderer panorama;
    private final UniqueArrayList<DynamicWidget<?, ?>> widgets = new UniqueArrayList();
    private final TitleWidgets titleWidgets = new TitleWidgets(this);
    private final TitleScreenAccess titleAccess;
    private boolean isLayoutSet;

    public NostalgicTitleScreen() {
        this.panorama = new PanoramaRenderer(TitleScreen.f_96716_);
        this.blockLogo = new NostalgicLogoRenderer();
        this.imageLogo = new LogoRenderer(false);
        this.titleAccess = (TitleScreenAccess)((Object)this);
    }

    public TitleLayout getLayout() {
        return (TitleLayout)CandyTweak.TITLE_BUTTON_LAYOUT.get();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.getLayout() != TitleLayout.MODERN) {
            this.m_169413_();
            this.titleWidgets.init();
        }
        for (Renderable widget : this.f_169369_) {
            ImageButton imageButton;
            ImageButton imageButton2;
            if (widget instanceof ImageButton && (imageButton2 = (ImageButton)widget).m_252754_() == this.f_96543_ / 2 - 124) {
                imageButton2.f_93624_ = (Boolean)CandyTweak.REMOVE_TITLE_LANGUAGE_BUTTON.get() == false;
                continue;
            }
            if (widget instanceof ImageButton && (imageButton = (ImageButton)widget).m_252754_() == this.f_96543_ / 2 + 104) {
                imageButton.f_93624_ = (Boolean)CandyTweak.REMOVE_TITLE_ACCESSIBILITY_BUTTON.get() == false;
                continue;
            }
            if (!(widget instanceof Button)) continue;
            Button button = (Button)widget;
            boolean isRealms = button.m_6035_().getString().equals(Lang.Vanilla.MENU_ONLINE.getString(new Object[0]));
            boolean isRemovable = (Boolean)CandyTweak.REMOVE_TITLE_REALMS_BUTTON.get();
            button.f_93624_ = !isRealms || !isRemovable;
        }
    }

    @Override
    public NostalgicTitleScreen self() {
        return this;
    }

    @Override
    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    @Override
    @Nullable
    public Screen getParentScreen() {
        return null;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.getLayout() == TitleLayout.MODERN ? this.f_96540_ : this.widgets;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ == null) {
            return false;
        }
        if (keyCode == 77) {
            this.f_96541_.m_91152_((Screen)new NostalgicTitleScreen());
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.getLayout() != TitleLayout.MODERN && !this.isLayoutSet) {
            if (((Boolean)CandyTweak.REMOVE_EXTRA_TITLE_BUTTONS.get()).booleanValue()) {
                this.m_169413_();
                this.m_7856_();
            }
            this.isLayoutSet = true;
        }
        if (((Boolean)CandyTweak.OLD_TITLE_BACKGROUND.get()).booleanValue()) {
            this.m_280039_(graphics);
        } else {
            this.panorama.m_110003_(partialTick, 1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280411_(OVERLAY, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        }
        if (this.f_96541_ == null || this.f_96541_.m_91265_() != null) {
            return;
        }
        if (NostalgicLogoText.LOGO_CHANGED.ifEnabledThenDisable()) {
            this.blockLogo = new NostalgicLogoRenderer();
        }
        if (((Boolean)CandyTweak.OLD_ALPHA_LOGO.get()).booleanValue()) {
            this.blockLogo.render(partialTick);
        } else {
            this.imageLogo.m_280037_(graphics, this.f_96543_, 1.0f);
        }
        if (this.titleAccess.nt$getSplash() != null) {
            this.titleAccess.nt$getSplash().m_280672_(graphics, this.f_96543_, this.f_96547_, 0xFFFF00);
        }
        Component copyright = switch (this.getLayout()) {
            case TitleLayout.ALPHA -> Lang.Title.COPYRIGHT_ALPHA.get(new Object[0]);
            case TitleLayout.BETA -> Lang.Title.COPYRIGHT_BETA.get(new Object[0]);
            default -> f_169438_;
        };
        Object minecraft = CandyTweak.TITLE_VERSION_TEXT.parse(GameUtil.getVersion());
        if (Minecraft.m_193589_().m_184597_() && !((Boolean)CandyTweak.REMOVE_TITLE_MOD_LOADER_TEXT.get()).booleanValue()) {
            minecraft = (String)minecraft + "/" + this.f_96541_.m_91389_() + Lang.Vanilla.MENU_MODDED.getString(new Object[0]);
        }
        int versionColor = (Boolean)CandyTweak.OLD_TITLE_BACKGROUND.get() != false && !((String)minecraft).contains("\u00a7") ? 0x505050 : 0xFFFFFF;
        int height = (Boolean)CandyTweak.TITLE_BOTTOM_LEFT_TEXT.get() != false ? this.f_96544_ - 10 : 2;
        graphics.m_280488_(this.f_96547_, (String)minecraft, 2, height, versionColor);
        graphics.m_280430_(this.f_96547_, copyright, this.f_96543_ - this.f_96547_.m_92852_((FormattedText)copyright) - 2, this.f_96544_ - 10, 0xFFFFFF);
        if (((Boolean)CandyTweak.TITLE_TOP_RIGHT_DEBUG_TEXT.get()).booleanValue()) {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            String memory = String.format("Free memory: %s%% of %sMB", used * 100L / max, MathUtil.bytesToMegabytes(max));
            String allocated = String.format("Allocated memory: %s%% (%sMB)", total * 100L / max, MathUtil.bytesToMegabytes(total));
            int memX = this.f_96543_ - this.f_96547_.m_92895_(memory) - 2;
            int allX = this.f_96543_ - this.f_96547_.m_92895_(allocated) - 2;
            graphics.m_280488_(this.f_96547_, memory, memX, 2, 0x808080);
            graphics.m_280488_(this.f_96547_, allocated, allX, GuiUtil.textHeight() + 3, 0x808080);
        }
        if (this.getLayout() != TitleLayout.MODERN) {
            DynamicWidget.render(this.widgets, graphics, mouseX, mouseY, partialTick);
        } else {
            this.f_169369_.forEach(renderable -> renderable.m_88315_(graphics, mouseX, mouseY, partialTick));
        }
        RenderSystem.enableDepthTest();
        if (this.titleAccess.nt$getRealmsNotificationsEnabled() && this.getLayout() == TitleLayout.MODERN) {
            this.titleAccess.nt$getRealmsNotificationsScreen().m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }
}

