/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title;

import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicTitleScreen;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.TitleLayout;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;

class TitleWidgets
implements WidgetManager {
    private static final int WIDGET_MARGIN = 4;
    private static final int LARGE_MARGIN = 28;
    private static final int LARGE_BUTTON = 200;
    private static final int SMALL_BUTTON = 98;
    private final NostalgicTitleScreen titleScreen;
    private final Minecraft minecraft;

    TitleWidgets(NostalgicTitleScreen titleScreen) {
        this.titleScreen = titleScreen;
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void init() {
        switch (this.titleScreen.getLayout()) {
            case ALPHA: {
                this.setAlphaLayout();
                break;
            }
            case BETA: {
                this.setBetaLayout();
                break;
            }
            default: {
                this.setReleaseLayout();
            }
        }
    }

    private boolean hasModsButton() {
        return (Boolean)CandyTweak.INCLUDE_MODS_ON_TITLE.get() != false && GuiUtil.modListScreen != null;
    }

    private int getX() {
        return this.titleScreen.f_96543_ / 2 - 100;
    }

    private int getY() {
        return this.titleScreen.f_96544_ / 4 + 48 - (this.hasModsButton() ? 12 : 0);
    }

    private void gotoSelectWorld() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new SelectWorldScreen((Screen)this.titleScreen));
        }
    }

    private void gotoMultiplayer() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this.titleScreen));
        }
    }

    private void gotoOptions() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new OptionsScreen((Screen)this.titleScreen, this.minecraft.f_91066_));
        }
    }

    private void gotoMods() {
        if (this.minecraft != null && GuiUtil.modListScreen != null) {
            this.minecraft.m_91152_(GuiUtil.modListScreen.apply((Screen)this.titleScreen));
        }
    }

    private void updatePackList(PackRepository packRepository) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.f_91066_.m_274546_(packRepository);
        this.minecraft.m_91152_((Screen)this.titleScreen);
    }

    private void gotoResourcePacks() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new PackSelectionScreen(this.minecraft.m_91099_(), this::updatePackList, this.minecraft.m_245161_(), (Component)Lang.Vanilla.RESOURCE_PACK_TITLE.get(new Object[0])));
        }
    }

    private void gotoLanguage() {
        if (this.minecraft != null) {
            this.minecraft.m_91152_((Screen)new LanguageSelectScreen((Screen)this.titleScreen, this.minecraft.f_91066_, this.minecraft.m_91102_()));
        }
    }

    private void setAlphaLayout() {
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        ButtonWidget tutorial = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create((Component)Lang.Title.TUTORIAL.withStyle(ChatFormatting.GRAY)).disableIf(BooleanSupplier.ALWAYS)).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).build(this.titleScreen::addWidget);
        boolean canStop = (Boolean)CandyTweak.ADD_QUIT_BUTTON.get();
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(tutorial, 16)).width(canStop ? 98 : 200)).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        if (canStop) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).m_91395_())).build(this.titleScreen::addWidget);
        }
    }

    private void setBetaLayout() {
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        ButtonWidget packs = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.hasModsButton() ? Lang.Title.TEXTURE_PACK : Lang.Title.MODS_TEXTURE).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).onPress(this::gotoResourcePacks)).build(this.titleScreen::addWidget);
        boolean canStop = (Boolean)CandyTweak.ADD_QUIT_BUTTON.get();
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(packs, canStop ? 16 : 4)).width(canStop ? 98 : 200)).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        if (canStop) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).m_91395_())).build(this.titleScreen::addWidget);
        }
    }

    private void setReleaseLayout() {
        if (this.minecraft == null) {
            return;
        }
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        ButtonWidget packs = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        if (this.titleScreen.getLayout() == TitleLayout.RELEASE_TEXTURE_PACK) {
            packs = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.TEXTURE_PACK).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).onPress(this::gotoResourcePacks)).build(this.titleScreen::addWidget);
        }
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(packs != null ? packs : (mods != null ? mods : multiplayer), packs == null && mods == null ? 40 : 16)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).m_91395_())).build(this.titleScreen::addWidget);
        if (!((Boolean)CandyTweak.REMOVE_TITLE_LANGUAGE_BUTTON.get()).booleanValue()) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().leftOf(options, 4)).icon(TextureIcon.fromSprite(new ResourceLocation("icon/language"), 15))).iconCenterOffset(-1)).onPress(this::gotoLanguage)).build(this.titleScreen::addWidget);
        }
    }
}

