/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select;

import java.util.ArrayList;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.SelectWorldWidgets;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.mixin.access.SelectWorldScreenAccess;
import mod.adrenix.nostalgic.mixin.access.WorldSelectionListAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class NostalgicSelectWorldScreen
extends SelectWorldScreen
implements DynamicScreen<NostalgicSelectWorldScreen> {
    private final UniqueArrayList<DynamicWidget<?, ?>> widgets;
    private final SelectWorldWidgets selectWorldWidgets;
    private final Screen parentScreen;
    private final Generic layout = (Generic)CandyTweak.OLD_WORLD_SELECT_SCREEN.get();
    private final String title;
    private WorldSelectionList selectionList;
    private boolean isListLoaded;
    private int alphaListIndex;

    public NostalgicSelectWorldScreen(Screen parentScreen) {
        super(parentScreen);
        this.widgets = new UniqueArrayList();
        this.selectWorldWidgets = new SelectWorldWidgets(this);
        this.parentScreen = parentScreen;
        this.title = switch (this.layout) {
            default -> throw new IncompatibleClassChangeError();
            case Generic.ALPHA -> TextUtil.uppercaseFirstLetter(Lang.Vanilla.WORLD_SELECT_TITLE.getString(new Object[0]).toLowerCase());
            case Generic.BETA, Generic.MODERN -> Lang.Vanilla.WORLD_SELECT_TITLE.getString(new Object[0]);
        };
    }

    public Generic getLayout() {
        return this.layout;
    }

    public WorldSelectionList getSelectionList() {
        return this.selectionList;
    }

    public WorldSelectionListAccess getAccessToSelectionList() {
        return (WorldSelectionListAccess)this.getSelectionList();
    }

    public ArrayList<WorldSelectionList.WorldListEntry> getAllWorlds() {
        ArrayList<WorldSelectionList.WorldListEntry> entries = new ArrayList<WorldSelectionList.WorldListEntry>();
        for (Object entry : this.selectionList.m_6702_()) {
            if (!(entry instanceof WorldSelectionList.WorldListEntry)) continue;
            WorldSelectionList.WorldListEntry worldEntry = (WorldSelectionList.WorldListEntry)entry;
            entries.add(worldEntry);
        }
        return entries;
    }

    public ArrayList<WorldSelectionList.WorldListEntry> getPagedWorldsForAlpha() {
        return this.getAllWorlds().stream().skip((long)this.alphaListIndex * 5L).limit(5L).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean canMoveAlphaLeft() {
        return this.alphaListIndex > 0;
    }

    public boolean canMoveAlphaRight() {
        int listed = this.getPagedWorldsForAlpha().size();
        if (listed == 0) {
            return false;
        }
        return this.alphaListIndex < this.getMaxAlphaListIndex() - 1 || listed % 5 == 0;
    }

    public int getMaxAlphaListIndex() {
        return (int)Math.ceil((double)this.getAllWorlds().size() / 5.0);
    }

    public void moveAlphaListIndexLeft() {
        if (this.canMoveAlphaLeft()) {
            this.alphaListIndex = Math.max(this.alphaListIndex - 1, 0);
            this.refreshWidgets();
        }
    }

    public void moveAlphaListIndexRight() {
        if (this.canMoveAlphaRight()) {
            this.alphaListIndex = Math.min(this.alphaListIndex + 1, this.getMaxAlphaListIndex());
            this.refreshWidgets();
        }
    }

    public void moveAlphaListHome() {
        this.alphaListIndex = 0;
    }

    public void refreshWidgets() {
        this.m_169413_();
        this.selectWorldWidgets.init();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (this.f_96541_ == null) {
            return;
        }
        this.alphaListIndex = 0;
        this.isListLoaded = false;
        this.selectionList = ((SelectWorldScreenAccess)((Object)this)).nt$getList();
        this.selectWorldWidgets.init();
    }

    @Override
    public NostalgicSelectWorldScreen self() {
        return this;
    }

    @Override
    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    @Override
    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.selectWorldWidgets.keyPressed(keyCode)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.selectionList.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280039_(graphics);
        if (this.selectionList.m_6702_().contains(this.getAccessToSelectionList().nt$getLoadingHeader())) {
            int y = this.f_96544_ / 2 - 20;
            RenderUtil.beginBatching();
            DrawText.begin(graphics, (Component)Lang.Vanilla.WORLD_LOADING_LIST.get(new Object[0])).pos(this.f_96543_ / 2, y).center().draw();
            DrawText.begin(graphics, LoadingDotsText.m_232744_((long)Util.m_137550_())).pos(this.f_96543_ / 2, y + 11).center().draw();
            RenderUtil.endBatching();
        } else {
            if (!this.isListLoaded) {
                this.isListLoaded = true;
                this.refreshWidgets();
            }
            int maxAlphaListIndex = this.getMaxAlphaListIndex();
            int y = 20;
            Object title = this.selectWorldWidgets.isDeleteMode() ? Lang.Worlds.ALPHA_DELETE_TITLE.getString(new Object[0]) : this.title;
            String page = Lang.Worlds.ALPHA_PAGE_TITLE.getString(this.alphaListIndex + 1, this.getMaxAlphaListIndex());
            if (this.getLayout() == Generic.ALPHA && maxAlphaListIndex > 1) {
                title = (String)title + " (" + page + ")";
            }
            DynamicWidget.render(this.widgets, graphics, mouseX, mouseY, partialTick);
            DrawText.begin(graphics, (String)title).pos(this.f_96543_ / 2, y).center().draw();
        }
    }
}

