/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.NostalgicSelectWorldScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.WorldRow;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.WorldRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.mixin.access.WorldListEntryAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SymlinkWarningScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import org.jetbrains.annotations.Nullable;

class SelectWorldWidgets
implements WidgetManager {
    private static final int ALPHA_BUTTON = 200;
    private static final int BETA_LARGE_BUTTON = 150;
    private static final int BETA_SMALL_BUTTON = 70;
    private final FlagHolder deleteMode = FlagHolder.off();
    private final NullableHolder<WorldRow> selected = NullableHolder.empty();
    private final NostalgicSelectWorldScreen selectWorldScreen;
    private final Minecraft minecraft;
    private final Generic layout;

    SelectWorldWidgets(NostalgicSelectWorldScreen selectWorldScreen) {
        this.selectWorldScreen = selectWorldScreen;
        this.layout = selectWorldScreen.getLayout();
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void init() {
        this.deleteMode.disable();
        this.selected.clear();
        if (this.layout == Generic.ALPHA) {
            this.setAlphaLayout();
        } else {
            this.setBetaLayout();
        }
    }

    public boolean isDeleteMode() {
        return (Boolean)this.deleteMode.get();
    }

    public boolean keyPressed(int keyCode) {
        if (this.layout == Generic.ALPHA && Screen.m_96637_()) {
            if (keyCode == 263) {
                this.selectWorldScreen.moveAlphaListIndexLeft();
                return true;
            }
            if (keyCode == 262) {
                this.selectWorldScreen.moveAlphaListIndexRight();
                return true;
            }
        }
        if (this.layout == Generic.BETA && KeyboardUtil.isEnterLike(keyCode)) {
            if (this.selected.isPresent()) {
                this.selected.ifPresent(row -> row.getEntry().m_101704_());
            }
            return true;
        }
        return false;
    }

    @Nullable
    private LevelStorageSource.LevelStorageAccess getLevelStorageAccess(LevelSummary levelSummary) {
        block10: {
            LevelStorageSource.LevelStorageAccess levelStorageAccess;
            block9: {
                String levelId = levelSummary.m_78358_();
                LevelStorageSource levelSource = this.minecraft.m_91392_();
                LevelStorageSource.LevelStorageAccess levelStorageAccess2 = levelSource.m_289864_(levelId);
                try {
                    levelStorageAccess = levelStorageAccess2;
                    if (levelStorageAccess2 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (levelStorageAccess2 != null) {
                            try {
                                levelStorageAccess2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        SystemToast.m_94852_((Minecraft)this.minecraft, (String)levelId);
                        NostalgicTweaks.LOGGER.error("Failed to access level (%s)\n%s", levelId, exception);
                        break block10;
                    }
                    catch (ContentValidationException exception) {
                        NostalgicTweaks.LOGGER.error("%s", exception.getMessage());
                        this.minecraft.m_91152_((Screen)new SymlinkWarningScreen((Screen)this.selectWorldScreen));
                    }
                }
                levelStorageAccess2.close();
            }
            return levelStorageAccess;
        }
        return null;
    }

    private Supplier<String> getLevelSize(LevelSummary levelSummary) {
        if (((Boolean)CandyTweak.IGNORE_WORLD_SIZE.get()).booleanValue()) {
            return () -> "0 MB";
        }
        LevelStorageSource.LevelStorageAccess levelStorageAccess = this.getLevelStorageAccess(levelSummary);
        if (levelStorageAccess == null) {
            return () -> "0 MB";
        }
        CompletableFuture<Long> futureSize = PathUtil.getFutureSizeOfDirectory(levelStorageAccess.m_78283_(LevelResource.f_78182_));
        return () -> {
            if (futureSize.isDone()) {
                long sizeInBytes;
                long l = sizeInBytes = futureSize.isCompletedExceptionally() ? -1L : futureSize.getNow(-1L);
                if (sizeInBytes == -1L) {
                    return "0 B";
                }
                return String.format("%s", PathUtil.getFormattedFileSize(sizeInBytes));
            }
            return String.format("%s", LoadingDotsText.m_232744_((long)Util.m_137550_()));
        };
    }

    private void getAlphaWorldOnPress(@Nullable WorldSelectionList.WorldListEntry world) {
        if (((Boolean)this.deleteMode.get()).booleanValue()) {
            if (world != null) {
                world.m_101738_();
            }
            this.deleteMode.disable();
            this.selectWorldScreen.moveAlphaListHome();
            return;
        }
        if (world != null) {
            world.m_101704_();
        } else {
            CreateWorldScreen.m_232896_((Minecraft)this.minecraft, (Screen)this.selectWorldScreen);
        }
    }

    private void runAlphaOnCancel() {
        if (((Boolean)this.deleteMode.get()).booleanValue()) {
            this.deleteMode.disable();
        } else {
            this.selectWorldScreen.m_7379_();
        }
    }

    private boolean isAlphaWorldDisabled(NullableHolder<WorldSelectionList.WorldListEntry> world, NullableHolder<LevelSummary> levelSummary) {
        if (((Boolean)this.deleteMode.get()).booleanValue()) {
            return world.isEmpty();
        }
        return levelSummary.isPresent() && levelSummary.getOrThrow().m_164916_();
    }

    private Component getAlphaWorldDisabledTooltip(NullableHolder<LevelSummary> levelSummary) {
        if (((Boolean)this.deleteMode.get()).booleanValue()) {
            return Lang.Worlds.ALPHA_CANNOT_DELETE.get(new Object[0]);
        }
        if (levelSummary.isEmpty()) {
            return Component.m_237119_();
        }
        return levelSummary.getOrThrow().m_78376_();
    }

    private void setAlphaLayout() {
        int x = this.selectWorldScreen.f_96543_ / 2 - 100;
        int y = 40;
        int numberOfWorlds = this.selectWorldScreen.getAllWorlds().size();
        ArrayList<WorldSelectionList.WorldListEntry> worlds = this.selectWorldScreen.getPagedWorldsForAlpha();
        NullableHolder lastButton = NullableHolder.empty();
        for (int i = 0; i < 5; ++i) {
            Supplier<Component> title = () -> Lang.Worlds.ALPHA_EMPTY.get(new Object[0]);
            NullableHolder world = NullableHolder.empty();
            NullableHolder levelSummary = NullableHolder.empty();
            if (i < worlds.size()) {
                world.set(worlds.get(i));
            }
            if (world.isPresent()) {
                String levelName = ((WorldSelectionList.WorldListEntry)world.getOrThrow()).m_170324_();
                levelSummary.set(((WorldListEntryAccess)world.getOrThrow()).nt$getLevelSummary());
                Supplier<String> levelSize = this.getLevelSize((LevelSummary)levelSummary.getOrThrow());
                title = () -> Component.m_237113_((String)String.format("%s (%s)", levelName, levelSize.get()));
            }
            ButtonWidget button = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(title).pos(x, 40)).below((DynamicWidget)lastButton.get(), 4)).width(200)).disabledTooltip(() -> this.getAlphaWorldDisabledTooltip(levelSummary), 45)).disableIf(() -> this.isAlphaWorldDisabled(world, levelSummary))).onPress(() -> this.getAlphaWorldOnPress((WorldSelectionList.WorldListEntry)world.get()))).build(this.selectWorldScreen::addWidget);
            lastButton.set(button);
            if (i != 2 || numberOfWorlds <= 4) continue;
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.literal("<")).leftOf(button, 4)).tooltip(Lang.Tooltip.KEYBOARD_SHORTCUT, 800L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Worlds.ALPHA_MOVE_LEFT, 45)).enableIf(this.selectWorldScreen::canMoveAlphaLeft)).onPress(this.selectWorldScreen::moveAlphaListIndexLeft)).build(this.selectWorldScreen::addWidget);
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.literal(">")).rightOf(button, 4)).tooltip(Lang.Tooltip.KEYBOARD_SHORTCUT, 800L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Worlds.ALPHA_MOVE_RIGHT, 45)).enableIf(this.selectWorldScreen::canMoveAlphaRight)).onPress(this.selectWorldScreen::moveAlphaListIndexRight)).build(this.selectWorldScreen::addWidget);
        }
        ButtonWidget deleteWorld = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Worlds.ALPHA_DELETE_BUTTON).posX(x)).below((DynamicWidget)lastButton.getOrThrow(), 16)).width(200)).invisibleIf(this.deleteMode::get)).onPress(this.deleteMode::enable)).build(this.selectWorldScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_CANCEL).posX(x)).below(deleteWorld, 16)).width(200)).onPress(this::runAlphaOnCancel)).build(this.selectWorldScreen::addWidget);
    }

    private void setBetaLayout() {
        int x = this.selectWorldScreen.f_96543_ / 2 - 154;
        int listHeight = this.selectWorldScreen.f_96544_ - 96;
        ArrayList<WorldSelectionList.WorldListEntry> worlds = this.selectWorldScreen.getAllWorlds();
        RowList rowList = ((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().posY(32)).height(listHeight)).heightOverflowMargin(2).defaultRowHeight(36).defaultRowWidth(220).verticalMargin(0).topMargin(2).centerRows().renderBackgroundDirt().renderBackgroundOpacity().renderTopAndBottomShadow().extendWidthToScreenEnd(0)).leftAlignedScrollbar(14).scrollbarBackground(Color.BLACK).build(this.selectWorldScreen::addWidget);
        for (WorldSelectionList.WorldListEntry world : worlds) {
            LevelSummary summary = ((WorldListEntryAccess)world).nt$getLevelSummary();
            if (summary == null) continue;
            rowList.addBottomRow((AbstractRow)new WorldRowMaker(rowList, world, summary, this.selected, this::getLevelSize).build());
        }
        ButtonWidget play = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.WORLD_PLAY_SELECTED).posX(x)).below(rowList, 12)).width(150)).enableIf(() -> this.selected.test(WorldRow::isPrimaryActionActive))).onPress(() -> this.selected.ifPresent(row -> row.getEntry().m_101704_()))).build(this.selectWorldScreen::addWidget);
        ButtonWidget rename = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Worlds.BETA_RENAME).posX(x)).below(play, 4)).width(70)).enableIf(() -> this.selected.test(WorldRow::canEdit))).onPress(() -> this.selected.ifPresent(row -> row.getEntry().m_101739_()))).build(this.selectWorldScreen::addWidget);
        ButtonWidget delete = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE).rightOf(rename, 10)).width(70)).enableIf(() -> this.selected.test(WorldRow::canDelete))).onPress(() -> this.selected.ifPresent(row -> row.getEntry().m_101738_()))).build(this.selectWorldScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.WORLD_CREATE).rightOf(play, 8)).width(150)).onPress(() -> CreateWorldScreen.m_232896_((Minecraft)this.minecraft, (Screen)this.selectWorldScreen))).build(this.selectWorldScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.GUI_CANCEL).rightOf(delete, 8)).width(150)).onPress(this.selectWorldScreen::m_7379_)).build(this.selectWorldScreen::addWidget);
    }
}

