/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select;

import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.WorldRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonRenderer;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.RowData;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.mixin.access.WorldListEntryAccess;
import mod.adrenix.nostalgic.mixin.access.WorldSelectionListAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;

class WorldRow
extends AbstractRow<WorldRowMaker, WorldRow> {
    private final Function<LevelSummary, Supplier<String>> getLevelSize;
    private final WorldSelectionList.WorldListEntry entry;
    private final NullableHolder<WorldRow> selected;
    private final FaviconTexture favicon;
    private final BlankWidget icon;
    private final LevelSummary summary;
    private long lastClickTime;

    WorldRow(WorldRowMaker builder) {
        super(builder);
        this.favicon = ((WorldListEntryAccess)builder.entry).nt$getIcon();
        this.selected = builder.selected;
        this.summary = builder.summary;
        this.entry = builder.entry;
        this.getLevelSize = builder.getLevelSize;
        boolean isIcon = (Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get();
        this.icon = ((BlankBuilder)((BlankBuilder)BlankWidget.create().pos(isIcon ? 3 : 4, 3)).size(isIcon ? 32 : 0)).renderer(this::renderIcon).build(this::addWidget);
        this.init();
        ((WorldRowMaker)this.getBuilder()).preRenderer(this::renderBox);
    }

    private void init() {
        boolean isMetadata = (Boolean)CandyTweak.ADD_WORLD_METADATA.get();
        boolean isIcon = (Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get();
        String name = this.summary.m_78361_();
        if (name.isEmpty()) {
            name = "World";
        }
        TextWidget header = ((TextBuilder)((TextBuilder)TextWidget.create(name).rightOf(this.icon, isIcon ? 3 : 0)).extendWidthToEnd(this, 4)).build(this::addWidget);
        Supplier<String> levelSize = this.getLevelSize.apply(this.summary);
        long lastPlayed = this.summary.m_78366_();
        String unknown = Lang.Worlds.BETA_UNKNOWN_LAST_PLAYED.getString(new Object[0]);
        String date = WorldSelectionListAccess.NT$DATE_FORMAT().format(new Date(lastPlayed));
        String time = String.format("%s (%s, ", this.summary.m_78358_(), lastPlayed != -1L ? date : unknown);
        TextWidget data = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(() -> Component.m_237113_((String)(time + (String)levelSize.get() + ")"))).color(Color.GRAY).rightOf(this.icon, isIcon ? 3 : 0)).below(header, 2)).extendWidthToEnd(this, 4)).build(this::addWidget);
        if (Color.RED.matches(this.summary.m_78376_().m_7383_()) || isMetadata) {
            ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.summary.m_78376_()).color(isMetadata ? Color.GRAY : Color.RED).rightOf(this.icon, isIcon ? 3 : 0)).below(data, 2)).extendWidthToEnd(this, 4)).build(this::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().noClickSound()).attach(new Object[]{RowData.WIDGET_SYNCED_WITH_HEIGHT})).backgroundRenderer(ButtonRenderer.EMPTY).whenFocused(() -> this.selected.set(this))).onPress(this::onPress)).pos(this::m_252754_, this::m_252907_)).size(this::m_5711_, this::m_93694_)).build(this::addWidget);
    }

    public WorldSelectionList.WorldListEntry getEntry() {
        return this.entry;
    }

    public boolean isPrimaryActionActive() {
        return !this.summary.m_164916_();
    }

    public boolean canEdit() {
        return !this.summary.m_164916_();
    }

    public boolean canDelete() {
        return true;
    }

    private void onPress() {
        this.selected.set(this);
        if (Util.m_137550_() - this.lastClickTime >= 250L) {
            this.lastClickTime = Util.m_137550_();
        } else {
            this.entry.m_101704_();
        }
    }

    private void renderIcon(BlankWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (((Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get()).booleanValue()) {
            RenderUtil.deferredRenderer(() -> graphics.m_280163_(this.favicon.m_289196_(), widget.m_252754_(), widget.m_252907_(), 0.0f, 0.0f, 32, 32, 32, 32));
        }
    }

    private void renderBox(WorldRow row, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!row.equals(this.selected.get())) {
            return;
        }
        Color background = Color.BLACK;
        Color outline = Color.GRAY;
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, (float)this.m_252754_(), (float)this.m_252907_(), (float)this.getEndX(), (float)this.getEndY(), background);
        RenderUtil.outline(graphics, (float)this.m_252754_(), (float)this.m_252907_(), (float)this.m_5711_(), (float)this.m_93694_(), outline);
        RenderUtil.endBatching();
    }
}

