/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.toast;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.toast.ModToast;
import mod.adrenix.nostalgic.client.gui.toast.ToastId;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;

public abstract class ToastNotification {
    private static final SimpleTimer TIMER = SimpleTimer.create(5L, TimeUnit.SECONDS).immediate().build();

    public static void add(ToastId id, long time) {
        boolean isRejection;
        if (!id.isActive()) {
            return;
        }
        boolean bl = isRejection = ToastId.LAN_REJECTION.equals((Object)id) && ModToast.getInstance(id).isClosed();
        if (TIMER.hasElapsed() || isRejection) {
            Arrays.stream(ToastId.values()).forEach(toast -> ModToast.getInstance(toast).close());
            ModToast.getInstance(id).setTimer(time).open();
        }
    }

    public static void changeOnLan() {
        ToastNotification.add(ToastId.LAN_CHANGE, 8500L);
    }

    public static void hostRejectedChanges() {
        ToastNotification.add(ToastId.LAN_REJECTION, 12000L);
    }

    public static void changeOnClient() {
        if (!NetUtil.isMultiplayer()) {
            return;
        }
        ToastNotification.add(ToastId.CLIENTBOUND_TWEAK, 8500L);
    }

    public static void changeOnServer() {
        if (!NetUtil.isMultiplayer()) {
            return;
        }
        ToastNotification.add(ToastId.SERVERBOUND_TWEAK, 8500L);
    }

    public static void handshake() {
        if (!NostalgicTweaks.isNetworkVerified() || NetUtil.isSingleplayer()) {
            return;
        }
        ToastNotification.add(ToastId.HANDSHAKE, 10000L);
    }
}

