/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.tooltip;

import java.util.Collection;
import java.util.Optional;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.util.common.CollectionUtil;

public interface TooltipManager {
    public Collection<DynamicWidget<?, ?>> getTooltipWidgets();

    default public Collection<DynamicWidget<?, ?>> getMouseTooltipWidgets() {
        return this.getTooltipWidgets();
    }

    default public Collection<DynamicWidget<?, ?>> getFocusTooltipWidgets() {
        return this.getTooltipWidgets();
    }

    default public void setTooltipUsingMouse() {
        DynamicWidget widget2;
        TooltipManager tooltipManager = this;
        if (tooltipManager instanceof DynamicWidget && (widget2 = (DynamicWidget)((Object)tooltipManager)).isInvisible()) {
            return;
        }
        Optional<DynamicWidget> withMouse = this.getMouseTooltipWidgets().stream().filter(DynamicWidget::hasTooltipBuilder).filter(DynamicWidget::isVisible).filter(widget -> widget.m_5953_(widget.getMouseX(), widget.getMouseY())).findFirst();
        if (withMouse.isPresent()) {
            withMouse.get().setTooltip();
        } else {
            CollectionUtil.fromClass(this.getMouseTooltipWidgets(), TooltipManager.class).forEach(TooltipManager::setTooltipUsingMouse);
        }
    }

    default public void setTooltipUsingFocused() {
        DynamicWidget widget;
        TooltipManager tooltipManager = this;
        if (tooltipManager instanceof DynamicWidget && (widget = (DynamicWidget)((Object)tooltipManager)).isInvisible()) {
            return;
        }
        Optional<DynamicWidget> withFocus = this.getFocusTooltipWidgets().stream().filter(DynamicWidget::isVisible).filter(DynamicWidget::isFocusedAndActive).filter(DynamicWidget::hasTooltipBuilder).findFirst();
        if (withFocus.isPresent()) {
            withFocus.get().setTooltip();
        } else {
            CollectionUtil.fromClass(this.getFocusTooltipWidgets(), TooltipManager.class).forEach(TooltipManager::setTooltipUsingFocused);
        }
    }

    default public void resetTooltipTimers() {
        for (DynamicWidget<?, ?> widget : this.getTooltipWidgets()) {
            widget.resetTooltipTimer();
            if (!(widget instanceof TooltipManager)) continue;
            TooltipManager manager = (TooltipManager)((Object)widget);
            manager.resetTooltipTimers();
        }
    }
}

