/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicPriority;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.SelfBuilder;
import mod.adrenix.nostalgic.util.client.renderer.RenderPass;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.function.FloatSupplier;
import mod.adrenix.nostalgic.util.common.function.ToFloatFunction;
import mod.adrenix.nostalgic.util.common.timer.FlagTimer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicBuilder<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
implements SelfBuilder<Builder, Widget> {
    protected final NullableHolder<Widget> widget = NullableHolder.empty();
    @Nullable
    protected Consumer<Widget> afterSync = null;
    @Nullable
    protected Consumer<Widget> beforeSync = null;
    @Nullable
    protected Consumer<Widget> whenFocused = null;
    protected BooleanSupplier canFocus = BooleanSupplier.ALWAYS;
    protected RenderPass renderPass = RenderPass.MIDDLE;
    protected boolean focusOnClick = true;
    protected int tabOrderGroup = 0;
    protected final UniqueArrayList<Object> attachedData = new UniqueArrayList();
    @Nullable
    protected ToIntFunction<Widget> x = null;
    @Nullable
    protected ToIntFunction<Widget> y = null;
    @Nullable
    protected ToIntFunction<Widget> width = null;
    @Nullable
    protected ToIntFunction<Widget> height = null;
    @Nullable
    protected ToFloatFunction<Widget> scaleWidth = null;
    @Nullable
    protected ToFloatFunction<Widget> scaleHeight = null;
    @Nullable
    protected RelativeLayout relativeLayout = null;
    protected final UniqueArrayList<DynamicWidget<?, ?>> hoverSync = new UniqueArrayList();
    protected final UniqueArrayList<DynamicWidget<?, ?>> followers = new UniqueArrayList();
    protected boolean forceRelativeX = false;
    protected boolean forceRelativeY = false;
    protected boolean relativeAnchor = false;
    protected int relativeX = 0;
    protected int relativeY = 0;
    protected int defaultX = 0;
    protected int defaultY = 0;
    protected int defaultWidth = 20;
    protected int defaultHeight = 20;
    protected Supplier<TextureIcon> iconSupplier = () -> TextureIcon.EMPTY;
    protected Supplier<TextureIcon> hoverIconSupplier = () -> TextureIcon.EMPTY;
    protected Supplier<TextureIcon> disabledIconSupplier = () -> TextureIcon.EMPTY;
    protected int iconWidth = 0;
    protected int iconHeight = 0;
    protected int hoverIconWidth = 0;
    protected int hoverIconHeight = 0;
    protected int disabledIconWidth = 0;
    protected int disabledIconHeight = 0;
    protected boolean brightenOnHover = false;
    protected boolean darkenOnDisable = true;
    protected FloatSupplier brightenAmount = () -> this.iconSupplier.get().getMaxBrightenAmount();
    protected FloatSupplier darkenAmount = () -> 0.4f;
    @Nullable
    protected Supplier<List<Component>> multilineTooltip = null;
    @Nullable
    protected Supplier<List<Component>> multilineInfoTooltip = null;
    @Nullable
    protected Supplier<List<Component>> disabledMultilineTooltip = null;
    @Nullable
    protected Supplier<List<Component>> disabledMultilineInfoTooltip = null;
    @Nullable
    protected Supplier<Component> tooltip = null;
    @Nullable
    protected Supplier<Component> infoTooltip = null;
    @Nullable
    protected Supplier<Component> disabledTooltip = null;
    @Nullable
    protected Supplier<Component> disabledInfoTooltip = null;
    @Nullable
    protected FlagTimer disabledTooltipTimer = null;
    @Nullable
    protected FlagTimer tooltipTimer = null;
    @Nullable
    protected FlagTimer hideTimer = null;
    @Nullable
    protected Predicate<Widget> active = null;
    @Nullable
    protected Predicate<Widget> visible = null;
    @Nullable
    protected Consumer<Widget> onActiveChange = null;
    @Nullable
    protected Consumer<Widget> onVisibleChange = null;
    private boolean lastActive = true;
    private boolean lastVisible = false;
    private final HashSet<DynamicField> managing = new HashSet();
    private final LinkedHashMap<Class<?>, DynamicFunction<Builder, Widget>> lowFunctions = new LinkedHashMap();
    private final LinkedHashMap<Class<?>, DynamicFunction<Builder, Widget>> highFunctions = new LinkedHashMap();
    private final LinkedHashMap<Class<?>, DynamicFunction<Builder, Widget>> layouts = new LinkedHashMap();
    private boolean hasInitialized = false;
    protected boolean isProcessingLayout = false;

    protected abstract Widget construct();

    public NullableHolder<Widget> getWidget() {
        return this.widget;
    }

    public Builder attach(Object ... data) {
        this.attachedData.addAll(List.of(data));
        return this.self();
    }

    public Builder detach(Object ... data) {
        this.attachedData.removeAll(List.of(data));
        return this.self();
    }

    public Builder afterSync(Consumer<Widget> updater) {
        this.afterSync = updater;
        return this.self();
    }

    public Builder afterSync(Runnable updater) {
        return this.afterSync((Widget widget) -> updater.run());
    }

    public Builder beforeSync(Consumer<Widget> updater) {
        this.beforeSync = updater;
        return this.self();
    }

    public Builder beforeSync(Runnable updater) {
        return this.beforeSync((Widget widget) -> updater.run());
    }

    public Builder hoverOrFocusSync(DynamicWidget<?, ?> ... syncTo) {
        this.hoverSync.addAll(List.of(syncTo));
        return this.self();
    }

    public Builder renderWhen(RenderPass pass) {
        this.renderPass = pass;
        return this.self();
    }

    public Builder focusWhen(BooleanSupplier when) {
        this.canFocus = when;
        return this.self();
    }

    public Builder whenFocused(Consumer<Widget> consumer) {
        this.whenFocused = consumer;
        return this.self();
    }

    public Builder whenFocused(Runnable runnable) {
        return this.whenFocused((Widget widget) -> runnable.run());
    }

    public Builder cannotFocus() {
        this.canFocus = BooleanSupplier.NEVER;
        return this.self();
    }

    public Builder skipFocusOnClick() {
        this.focusOnClick = false;
        return this.self();
    }

    public Builder tabOrderGroup(int tabOrderGroup) {
        this.tabOrderGroup = tabOrderGroup;
        return this.self();
    }

    protected float getScaleWidth(Widget widget) {
        return NullableResult.getOrElse(this.scaleWidth, Float.valueOf(1.0f), resizer -> Float.valueOf(resizer.applyAsFloat(widget))).floatValue();
    }

    protected float getScaleHeight(Widget widget) {
        return NullableResult.getOrElse(this.scaleHeight, Float.valueOf(1.0f), resizer -> Float.valueOf(resizer.applyAsFloat(widget))).floatValue();
    }

    public boolean isManaging(DynamicField ... fields) {
        for (DynamicField field : fields) {
            boolean isManaged;
            switch (field) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    boolean bl;
                    if (this.x != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case Y: {
                    boolean bl;
                    if (this.y != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WIDTH: {
                    boolean bl;
                    if (this.width != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case HEIGHT: {
                    boolean bl;
                    if (this.height != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case ACTIVE: {
                    boolean bl;
                    if (this.active != null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case VISIBLE: {
                    boolean bl = isManaged = this.visible != null;
                }
            }
            if (!isManaged && !this.managing.contains((Object)field)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotManaging(DynamicField ... fields) {
        return !this.isManaging(fields);
    }

    public Builder addFunction(DynamicFunction<Builder, Widget> function) {
        this.managing.addAll(function.getManaging(this.self()));
        if (function instanceof DynamicLayout) {
            this.layouts.put(function.getClass(), function);
        } else if (function.priority() == DynamicPriority.LOW) {
            this.lowFunctions.put(function.getClass(), function);
        } else {
            this.highFunctions.put(function.getClass(), function);
        }
        return this.self();
    }

    public void resetLayout() {
        this.x = null;
        this.y = null;
        this.width = null;
        this.height = null;
        this.scaleWidth = null;
        this.scaleHeight = null;
        this.relativeLayout = null;
        this.managing.clear();
        this.followers.clear();
        this.layouts.clear();
        this.lowFunctions.values().forEach(function -> this.managing.addAll(function.getManaging(this.self())));
        this.highFunctions.values().forEach(function -> this.managing.addAll(function.getManaging(this.self())));
    }

    protected void init(Widget widget) {
        this.widget.set(widget);
        ((DynamicWidget)widget).m_252865_(this.defaultX);
        ((DynamicWidget)widget).m_253211_(this.defaultY);
        ((DynamicWidget)widget).setWidth(this.defaultWidth);
        ((DynamicWidget)widget).setHeight(this.defaultHeight);
        this.lastActive = ((DynamicWidget)widget).active;
        this.lastVisible = ((DynamicWidget)widget).visible;
        this.syncDimensions(widget);
        this.lowFunctions.forEach((classType, function) -> function.apply(widget));
        this.syncLayout(widget);
        this.highFunctions.forEach((classType, function) -> function.apply(widget));
        DynamicWidget.syncWithoutCache(this.followers);
        this.relativeX = ((DynamicWidget)widget).x;
        this.relativeY = ((DynamicWidget)widget).y;
        this.hasInitialized = true;
    }

    private void findAndExecute(Class<? extends DynamicLayout> layout, Widget widget) {
        DynamicFunction<Builder, Widget> function = this.layouts.get(layout);
        if (function != null) {
            if (this.hasInitialized) {
                function.ifReapplyThenApply(widget);
            } else {
                function.apply(widget);
            }
        }
    }

    public int getRelativeLayoutX() {
        DynamicWidget widget = (DynamicWidget)this.widget.get();
        RelativeLayout layout = this.relativeLayout;
        if (widget == null || this.relativeLayout == null) {
            return 0;
        }
        return this.relativeAnchor ? layout.getAnchoredX(widget) : layout.getRelativeX(widget);
    }

    public int getRelativeLayoutY() {
        DynamicWidget widget = (DynamicWidget)this.widget.get();
        RelativeLayout layout = this.relativeLayout;
        if (widget == null || this.relativeLayout == null) {
            return 0;
        }
        return this.relativeAnchor ? layout.getAnchoredY(widget) : layout.getRelativeY(widget);
    }

    public void relativeSync() {
        if (this.relativeLayout == null) {
            return;
        }
        DynamicWidget widget = (DynamicWidget)this.widget.get();
        if (widget == null) {
            return;
        }
        int dx = this.getRelativeLayoutX() + this.relativeX;
        int dy = this.getRelativeLayoutY() + this.relativeY;
        if (this.forceRelativeX || this.isNotManaging(DynamicField.X)) {
            widget.m_252865_(dx);
        }
        if (this.forceRelativeY || this.isNotManaging(DynamicField.Y)) {
            widget.m_253211_(dy);
        }
    }

    public void sync() {
        DynamicWidget widget = (DynamicWidget)this.widget.get();
        if (widget == null) {
            return;
        }
        this.isProcessingLayout = true;
        this.syncDimensions(widget);
        this.lowFunctions.forEach((classType, function) -> function.ifReapplyThenApply(widget));
        this.syncLayout(widget);
        this.highFunctions.forEach((classType, function) -> function.ifReapplyThenApply(widget));
        this.syncLastState(widget);
        DynamicWidget.syncWithoutCache(this.followers);
        this.isProcessingLayout = false;
    }

    protected void preSync() {
        if (this.beforeSync != null && this.widget.isPresent()) {
            this.beforeSync.accept((DynamicWidget)this.widget.get());
        }
    }

    protected void postSync() {
        if (this.afterSync != null && this.widget.isPresent()) {
            this.afterSync.accept((DynamicWidget)this.widget.get());
        }
    }

    private void syncLastState(Widget widget) {
        if (this.onActiveChange != null && this.lastActive != ((DynamicWidget)widget).active) {
            this.onActiveChange.accept(widget);
        }
        if (this.onVisibleChange != null && this.lastVisible != ((DynamicWidget)widget).visible) {
            this.onVisibleChange.accept(widget);
        }
        this.lastActive = ((DynamicWidget)widget).active;
        this.lastVisible = ((DynamicWidget)widget).visible;
    }

    private void syncDimensions(Widget widget) {
        NullableAction.attempt(this.x, function -> widget.m_252865_(function.applyAsInt(widget)));
        NullableAction.attempt(this.y, function -> widget.m_253211_(function.applyAsInt(widget)));
        NullableAction.attempt(this.width, function -> widget.setWidth(function.applyAsInt(widget)));
        NullableAction.attempt(this.height, function -> widget.setHeight(function.applyAsInt(widget)));
    }

    private void syncLayout(Widget widget) {
        this.findAndExecute(DynamicLayout.XPos.FromScreenEnd.class, widget);
        this.findAndExecute(DynamicLayout.XPos.FromWidgetEnd.class, widget);
        this.findAndExecute(DynamicLayout.XYPos.LeftOf.class, widget);
        this.findAndExecute(DynamicLayout.XYPos.RightOf.class, widget);
        this.findAndExecute(DynamicLayout.XPos.AlignFlush.class, widget);
        this.findAndExecute(DynamicLayout.YPos.AlignVertical.class, widget);
        this.findAndExecute(DynamicLayout.YPos.Above.class, widget);
        this.findAndExecute(DynamicLayout.YPos.Below.class, widget);
        this.findAndExecute(DynamicLayout.YPos.BelowAll.class, widget);
        this.findAndExecute(DynamicLayout.Width.ExtendToWidgetStart.class, widget);
        this.findAndExecute(DynamicLayout.Width.ExtendToWidgetEnd.class, widget);
        this.findAndExecute(DynamicLayout.Height.ExtendToWidgetStart.class, widget);
        this.findAndExecute(DynamicLayout.Height.ExtendToWidgetEnd.class, widget);
        this.findAndExecute(DynamicLayout.Width.OfWidget.class, widget);
        this.findAndExecute(DynamicLayout.Width.OfScreen.class, widget);
        this.findAndExecute(DynamicLayout.Height.OfWidget.class, widget);
        this.findAndExecute(DynamicLayout.Height.OfScreen.class, widget);
        this.findAndExecute(DynamicLayout.Width.ExtendToScreen.class, widget);
        this.findAndExecute(DynamicLayout.Width.ExtendToLargestEnd.class, widget);
        this.findAndExecute(DynamicLayout.Height.ExtendToScreen.class, widget);
        this.findAndExecute(DynamicLayout.Height.ExtendToLargestEnd.class, widget);
        this.findAndExecute(DynamicLayout.YPos.FromScreenEnd.class, widget);
        this.findAndExecute(DynamicLayout.YPos.FromWidgetEnd.class, widget);
        this.findAndExecute(DynamicLayout.XPos.CenterInScreen.class, widget);
        this.findAndExecute(DynamicLayout.YPos.CenterInScreen.class, widget);
        this.findAndExecute(DynamicLayout.XPos.CenterInWidget.class, widget);
        this.findAndExecute(DynamicLayout.YPos.CenterInWidget.class, widget);
        this.syncDimensions(widget);
        NullableAction.attempt(this.active, predicate -> widget.setActive(predicate.test(widget)));
        NullableAction.attempt(this.visible, predicate -> widget.setVisible(predicate.test(widget)));
    }
}

