/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import net.minecraft.client.gui.GuiGraphics;

public class IconManager<Widget extends DynamicWidget<?, Widget>> {
    private boolean isCacheMode = false;
    private final DynamicBuilder<?, Widget> builder;
    private final Widget widget;
    private IconWidget cache;
    private IconWidget iconWidget;
    private IconWidget hoverIconWidget;
    private IconWidget disabledIconWidget;
    private TextureIcon lastIcon;

    public IconManager(Widget widget) {
        this.widget = widget;
        this.builder = ((DynamicWidget)widget).getBuilder();
    }

    public static Supplier<TextureIcon> getHovered(DynamicBuilder<?, ?> builder) {
        return builder.hoverIconSupplier;
    }

    public static Supplier<TextureIcon> getDisabled(DynamicBuilder<?, ?> builder) {
        return builder.disabledIconSupplier;
    }

    public IconWidget get() {
        if (this.isCacheMode) {
            return this.cache;
        }
        IconWidget toReturn = this.getIconWidget();
        if (this.lastIcon == null || this.lastIcon != toReturn.getIcon()) {
            this.lastIcon = toReturn.getIcon();
        }
        return toReturn;
    }

    public void pushCache() {
        this.cache = this.get();
        this.isCacheMode = true;
    }

    public void popCache() {
        this.isCacheMode = false;
        this.cache = null;
    }

    private IconWidget getIconWidget() {
        IconWidget toReturn;
        IconWidget iconWidget = this.getDefault();
        IconWidget hoverIconWidget = this.getHover();
        IconWidget disabledIconWidget = this.getDisabled();
        if (hoverIconWidget.isEmpty()) {
            toReturn = iconWidget;
        } else {
            IconWidget iconWidget2 = toReturn = ((DynamicWidget)this.widget).isHoveredOrFocused() && ((DynamicWidget)this.widget).isActive() ? hoverIconWidget : iconWidget;
        }
        if (((DynamicWidget)this.widget).isInactive() && !disabledIconWidget.isEmpty()) {
            toReturn = disabledIconWidget;
        }
        return toReturn;
    }

    public void pos(int x, int y) {
        this.get().pos(x, y);
    }

    public int getWidth() {
        return this.get().m_5711_();
    }

    public int getHeight() {
        return this.get().m_93694_();
    }

    public boolean isEmpty() {
        return this.get().isEmpty();
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public void apply(Consumer<IconWidget> consumer) {
        consumer.accept(this.getDisabled());
        consumer.accept(this.getDefault());
        consumer.accept(this.getHover());
    }

    public IconWidget getDefault() {
        IconWidget iconWidget = this.iconWidget = this.iconWidget != null ? this.iconWidget : (IconWidget)((IconFactory)IconWidget.create(this.builder.iconSupplier).size(this.builder.iconWidth, this.builder.iconHeight)).build();
        if (this.builder.iconSupplier.get() != this.iconWidget.getIcon()) {
            this.iconWidget.setIcon(this.builder.iconSupplier);
            this.iconWidget.setSize(this.builder.iconWidth, this.builder.iconHeight);
        }
        return this.iconWidget;
    }

    public IconWidget getHover() {
        IconWidget iconWidget = this.hoverIconWidget = this.hoverIconWidget != null ? this.hoverIconWidget : (IconWidget)((IconFactory)IconWidget.create(this.builder.hoverIconSupplier).size(this.builder.hoverIconWidth, this.builder.hoverIconHeight)).build();
        if (this.builder.hoverIconSupplier.get() != this.hoverIconWidget.getIcon()) {
            this.hoverIconWidget.setIcon(this.builder.hoverIconSupplier);
            this.hoverIconWidget.setSize(this.builder.hoverIconWidth, this.builder.hoverIconHeight);
        }
        return this.hoverIconWidget;
    }

    public IconWidget getDisabled() {
        IconWidget iconWidget = this.disabledIconWidget = this.disabledIconWidget != null ? this.disabledIconWidget : (IconWidget)((IconFactory)IconWidget.create(this.builder.disabledIconSupplier).size(this.builder.disabledIconWidth, this.builder.disabledIconHeight)).build();
        if (this.builder.disabledIconSupplier.get() != this.disabledIconWidget.getIcon()) {
            this.disabledIconWidget.setIcon(this.builder.disabledIconSupplier);
            this.disabledIconWidget.setSize(this.builder.disabledIconWidth, this.builder.disabledIconHeight);
        }
        return this.disabledIconWidget;
    }

    public static float getLightenAmount(DynamicWidget<?, ?> widget, float brightness) {
        if (widget.isHoveredOrFocused() && ((DynamicBuilder)widget.getBuilder()).brightenOnHover) {
            return ((DynamicBuilder)widget.getBuilder()).brightenAmount.getAsFloat();
        }
        return brightness;
    }

    public static float getDarkenAmount(DynamicWidget<?, ?> widget, float brightness) {
        if (!widget.isActive() && ((DynamicBuilder)widget.getBuilder()).darkenOnDisable) {
            return ((DynamicBuilder)widget.getBuilder()).darkenAmount.getAsFloat();
        }
        return brightness;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        float brightness = 1.0f;
        if (this.getHover().isEmpty()) {
            brightness = IconManager.getLightenAmount(this.widget, brightness);
        }
        if (this.getDisabled().isEmpty()) {
            brightness = IconManager.getDarkenAmount(this.widget, brightness);
        }
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        this.get().m_88315_(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

