/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.SelfBuilder;
import mod.adrenix.nostalgic.util.common.function.FloatSupplier;
import mod.adrenix.nostalgic.util.common.function.ToFloatFunction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public interface LayoutBuilder<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
extends SelfBuilder<Builder, Widget> {
    default public Builder pos(int x, int y) {
        ((DynamicBuilder)this.self()).defaultX = x;
        ((DynamicBuilder)this.self()).defaultY = y;
        return this.self();
    }

    default public Builder pos(IntSupplier posX, IntSupplier posY) {
        return this.pos((Widget widget) -> posX.getAsInt(), (Widget widget) -> posY.getAsInt());
    }

    default public Builder pos(ToIntFunction<Widget> posX, ToIntFunction<Widget> posY) {
        ((DynamicBuilder)this.self()).x = posX;
        ((DynamicBuilder)this.self()).y = posY;
        return this.self();
    }

    default public Builder posX(int x) {
        ((DynamicBuilder)this.self()).defaultX = x;
        return this.self();
    }

    default public Builder posX(IntSupplier supplier) {
        return this.posX((Widget widget) -> supplier.getAsInt());
    }

    default public Builder posX(ToIntFunction<Widget> function) {
        ((DynamicBuilder)this.self()).x = function;
        return this.self();
    }

    default public Builder posY(int y) {
        ((DynamicBuilder)this.self()).defaultY = y;
        return this.self();
    }

    default public Builder posY(IntSupplier supplier) {
        return this.posY((Widget widget) -> supplier.getAsInt());
    }

    default public Builder posY(ToIntFunction<Widget> function) {
        ((DynamicBuilder)this.self()).y = function;
        return this.self();
    }

    default public Builder width(int width) {
        ((DynamicBuilder)this.self()).defaultWidth = width;
        return this.self();
    }

    default public Builder width(IntSupplier width) {
        return this.width((Widget widget) -> width.getAsInt());
    }

    default public Builder width(ToIntFunction<Widget> width) {
        ((DynamicBuilder)this.self()).width = width;
        return this.self();
    }

    default public Builder height(int height) {
        ((DynamicBuilder)this.self()).defaultHeight = height;
        return this.self();
    }

    default public Builder height(IntSupplier height) {
        return this.height((Widget widget) -> height.getAsInt());
    }

    default public Builder height(ToIntFunction<Widget> height) {
        ((DynamicBuilder)this.self()).height = height;
        return this.self();
    }

    default public Builder size(int width, int height) {
        ((DynamicBuilder)this.self()).defaultWidth = width;
        ((DynamicBuilder)this.self()).defaultHeight = height;
        return this.self();
    }

    default public Builder size(IntSupplier width, IntSupplier height) {
        return this.size((Widget widget) -> width.getAsInt(), (Widget widget) -> height.getAsInt());
    }

    default public Builder size(ToIntFunction<Widget> width, ToIntFunction<Widget> height) {
        ((DynamicBuilder)this.self()).width = width;
        ((DynamicBuilder)this.self()).height = height;
        return this.self();
    }

    default public Builder size(int size) {
        ((DynamicBuilder)this.self()).defaultWidth = size;
        ((DynamicBuilder)this.self()).defaultHeight = size;
        return this.self();
    }

    default public Builder size(IntSupplier size) {
        return this.size((Widget widget) -> size.getAsInt());
    }

    default public Builder size(ToIntFunction<Widget> size) {
        ((DynamicBuilder)this.self()).width = size;
        ((DynamicBuilder)this.self()).height = size;
        return this.self();
    }

    default public Builder widthOfScreen(ToFloatFunction<Widget> ofAmount) {
        ToFloatFunction<DynamicWidget> clamp = widget -> Mth.m_14036_((float)ofAmount.applyAsFloat(widget), (float)0.0f, (float)1.0f);
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.OfScreen(this.self(), clamp));
        return this.self();
    }

    default public Builder widthOfScreen(FloatSupplier ofAmount) {
        return this.widthOfScreen((Widget widget) -> ofAmount.getAsFloat());
    }

    default public Builder widthOfScreen(float ofAmount) {
        return this.widthOfScreen(() -> ofAmount);
    }

    default public Builder widthOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, ToFloatFunction<Widget> ofAmount) {
        if (ofWidget == null) {
            return this.self();
        }
        ToFloatFunction<DynamicWidget> clamp = widget -> Mth.m_14036_((float)ofAmount.applyAsFloat(widget), (float)0.0f, (float)1.0f);
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.OfWidget(this.self(), ofWidget, clamp));
        return this.self();
    }

    default public Builder widthOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, FloatSupplier ofAmount) {
        return this.widthOfWidget(ofWidget, (Widget widget) -> ofAmount.getAsFloat());
    }

    default public Builder widthOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, float ofAmount) {
        return this.widthOfWidget(ofWidget, () -> ofAmount);
    }

    default public Builder extendWidthTo(@Nullable DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
        if (extendTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.ExtendToWidgetStart(this.self(), extendTo, margin));
        return this.self();
    }

    default public Builder extendWidthTo(@Nullable DynamicWidget<?, ?> extendTo, IntSupplier margin) {
        return this.extendWidthTo(extendTo, (Widget widget) -> margin.getAsInt());
    }

    default public Builder extendWidthTo(@Nullable DynamicWidget<?, ?> extendTo, int margin) {
        return this.extendWidthTo(extendTo, () -> margin);
    }

    default public Builder extendWidthToEnd(@Nullable DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
        if (extendTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.ExtendToWidgetEnd(this.self(), extendTo, margin));
        return this.self();
    }

    default public Builder extendWidthToEnd(@Nullable DynamicWidget<?, ?> extendTo, IntSupplier margin) {
        return this.extendWidthToEnd(extendTo, (Widget widget) -> margin.getAsInt());
    }

    default public Builder extendWidthToEnd(@Nullable DynamicWidget<?, ?> extendTo, int margin) {
        return this.extendWidthToEnd(extendTo, () -> margin);
    }

    default public Builder extendWidthToLargest(Collection<DynamicWidget<?, ?>> all) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.ExtendToLargestEnd(all));
        return this.self();
    }

    default public Builder extendWidthToLargest(DynamicWidget<?, ?> ... all) {
        return this.extendWidthToLargest(List.of(all));
    }

    default public Builder extendWidthToScreenEnd(ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Width.ExtendToScreen(this.self(), margin));
        return this.self();
    }

    default public Builder extendWidthToScreenEnd(IntSupplier margin) {
        return this.extendWidthToScreenEnd((Widget widget) -> margin.getAsInt());
    }

    default public Builder extendWidthToScreenEnd(int margin) {
        return this.extendWidthToScreenEnd(() -> margin);
    }

    default public Builder heightOfScreen(ToFloatFunction<Widget> ofAmount) {
        ToFloatFunction<DynamicWidget> clamp = widget -> Mth.m_14036_((float)ofAmount.applyAsFloat(widget), (float)0.0f, (float)1.0f);
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.OfScreen(this.self(), clamp));
        return this.self();
    }

    default public Builder heightOfScreen(FloatSupplier ofAmount) {
        return this.heightOfScreen((Widget widget) -> ofAmount.getAsFloat());
    }

    default public Builder heightOfScreen(float ofAmount) {
        return this.heightOfScreen(() -> ofAmount);
    }

    default public Builder heightOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, ToFloatFunction<Widget> ofAmount) {
        if (ofWidget == null) {
            return this.self();
        }
        ToFloatFunction<DynamicWidget> clamp = widget -> Mth.m_14036_((float)ofAmount.applyAsFloat(widget), (float)0.0f, (float)1.0f);
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.OfWidget(this.self(), ofWidget, clamp));
        return this.self();
    }

    default public Builder heightOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, FloatSupplier ofAmount) {
        return this.heightOfWidget(ofWidget, (Widget widget) -> ofAmount.getAsFloat());
    }

    default public Builder heightOfWidget(@Nullable DynamicWidget<?, ?> ofWidget, float ofAmount) {
        return this.heightOfWidget(ofWidget, () -> ofAmount);
    }

    default public Builder extendHeightTo(@Nullable DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
        if (extendTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.ExtendToWidgetStart(this.self(), extendTo, margin));
        return this.self();
    }

    default public Builder extendHeightTo(@Nullable DynamicWidget<?, ?> extendTo, IntSupplier margin) {
        return this.extendHeightTo(extendTo, (Widget widget) -> margin.getAsInt());
    }

    default public Builder extendHeightTo(@Nullable DynamicWidget<?, ?> extendTo, int margin) {
        return this.extendHeightTo(extendTo, () -> margin);
    }

    default public Builder extendHeightToEnd(@Nullable DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
        if (extendTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.ExtendToWidgetEnd(this.self(), extendTo, margin));
        return this.self();
    }

    default public Builder extendHeightToEnd(@Nullable DynamicWidget<?, ?> extendTo, IntSupplier margin) {
        return this.extendHeightToEnd(extendTo, (Widget widget) -> margin.getAsInt());
    }

    default public Builder extendHeightToEnd(@Nullable DynamicWidget<?, ?> extendTo, int margin) {
        return this.extendHeightToEnd(extendTo, () -> margin);
    }

    default public Builder extendHeightToLargest(Collection<DynamicWidget<?, ?>> all) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.ExtendToLargestEnd(all));
        return this.self();
    }

    default public Builder extendHeightToLargest(DynamicWidget<?, ?> ... all) {
        return this.extendHeightToLargest(List.of(all));
    }

    default public Builder extendHeightToScreenEnd(ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.Height.ExtendToScreen(this.self(), margin));
        return this.self();
    }

    default public Builder extendHeightToScreenEnd(IntSupplier margin) {
        return this.extendHeightToScreenEnd((Widget widget) -> margin.getAsInt());
    }

    default public Builder extendHeightToScreenEnd(int margin) {
        return this.extendHeightToScreenEnd(() -> margin);
    }

    default public Builder leftOf(@Nullable DynamicWidget<?, ?> leftOf, ToIntFunction<Widget> margin) {
        if (leftOf == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XYPos.LeftOf(this.self(), leftOf, margin));
        return this.self();
    }

    default public Builder leftOf(@Nullable DynamicWidget<?, ?> leftOf, IntSupplier margin) {
        return this.leftOf(leftOf, (Widget widget) -> margin.getAsInt());
    }

    default public Builder leftOf(@Nullable DynamicWidget<?, ?> leftOf, int margin) {
        return this.leftOf(leftOf, () -> margin);
    }

    default public Builder rightOf(@Nullable DynamicWidget<?, ?> rightOf, ToIntFunction<Widget> margin) {
        if (rightOf == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XYPos.RightOf(this.self(), rightOf, margin));
        return this.self();
    }

    default public Builder rightOf(@Nullable DynamicWidget<?, ?> rightOf, IntSupplier margin) {
        return this.rightOf(rightOf, (Widget widget) -> margin.getAsInt());
    }

    default public Builder rightOf(@Nullable DynamicWidget<?, ?> rightOf, int margin) {
        return this.rightOf(rightOf, () -> margin);
    }

    default public Builder above(@Nullable DynamicWidget<?, ?> above, ToIntFunction<Widget> margin) {
        if (above == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.Above(this.self(), above, margin));
        return this.self();
    }

    default public Builder above(@Nullable DynamicWidget<?, ?> above, IntSupplier margin) {
        return this.above(above, (Widget widget) -> margin.getAsInt());
    }

    default public Builder above(@Nullable DynamicWidget<?, ?> above, int margin) {
        return this.above(above, () -> margin);
    }

    default public Builder below(@Nullable DynamicWidget<?, ?> below, ToIntFunction<Widget> margin) {
        if (below == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.Below(this.self(), below, margin));
        return this.self();
    }

    default public Builder below(@Nullable DynamicWidget<?, ?> below, IntSupplier margin) {
        return this.below(below, (Widget widget) -> margin.getAsInt());
    }

    default public Builder below(@Nullable DynamicWidget<?, ?> below, int margin) {
        return this.below(below, () -> margin);
    }

    default public Builder belowAll(Collection<? extends DynamicWidget<?, ?>> all, ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.BelowAll(this.self(), new LinkedHashSet(all), margin));
        return this.self();
    }

    default public Builder belowAll(Collection<? extends DynamicWidget<?, ?>> all, IntSupplier margin) {
        return this.belowAll(all, (Widget widget) -> margin.getAsInt());
    }

    default public Builder belowAll(Collection<? extends DynamicWidget<?, ?>> all, int margin) {
        return this.belowAll(all, () -> margin);
    }

    default public Builder belowAll(ToIntFunction<Widget> margin, DynamicWidget<?, ?> ... all) {
        LinkedHashSet widgets = new LinkedHashSet(List.of(all));
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.BelowAll(this.self(), widgets, margin));
        return this.self();
    }

    default public Builder belowAll(IntSupplier margin, DynamicWidget<?, ?> ... all) {
        return this.belowAll((Widget widget) -> margin.getAsInt(), all);
    }

    default public Builder belowAll(int margin, DynamicWidget<?, ?> ... all) {
        return this.belowAll(() -> margin, all);
    }

    default public Builder fromWidgetEndX(DynamicWidget<?, ?> fromEnd, ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XPos.FromWidgetEnd(this.self(), fromEnd, margin));
        return this.self();
    }

    default public Builder fromWidgetEndX(DynamicWidget<?, ?> fromEnd, IntSupplier margin) {
        return this.fromWidgetEndX(fromEnd, (Widget widget) -> margin.getAsInt());
    }

    default public Builder fromWidgetEndX(DynamicWidget<?, ?> fromEnd, int margin) {
        return this.fromWidgetEndX(fromEnd, () -> margin);
    }

    default public Builder fromScreenEndX(ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XPos.FromScreenEnd(this.self(), margin));
        return this.self();
    }

    default public Builder fromScreenEndX(IntSupplier margin) {
        return this.fromScreenEndX((Widget widget) -> margin.getAsInt());
    }

    default public Builder fromScreenEndX(int margin) {
        return this.fromScreenEndX(() -> margin);
    }

    default public Builder fromWidgetEndY(DynamicWidget<?, ?> fromEnd, ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.FromWidgetEnd(this.self(), fromEnd, margin));
        return this.self();
    }

    default public Builder fromWidgetEndY(DynamicWidget<?, ?> fromEnd, IntSupplier margin) {
        return this.fromWidgetEndY(fromEnd, (Widget widget) -> margin.getAsInt());
    }

    default public Builder fromWidgetEndY(DynamicWidget<?, ?> fromEnd, int margin) {
        return this.fromWidgetEndY(fromEnd, () -> margin);
    }

    default public Builder fromScreenEndY(ToIntFunction<Widget> margin) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.FromScreenEnd(this.self(), margin));
        return this.self();
    }

    default public Builder fromScreenEndY(IntSupplier margin) {
        return this.fromScreenEndY((Widget widget) -> margin.getAsInt());
    }

    default public Builder fromScreenEndY(int margin) {
        return this.fromScreenEndY(() -> margin);
    }

    default public Builder alignFlushTo(@Nullable DynamicWidget<?, ?> flushTo, ToIntFunction<Widget> offset) {
        if (flushTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XPos.AlignFlush(this.self(), flushTo, offset));
        return this.self();
    }

    default public Builder alignFlushTo(@Nullable DynamicWidget<?, ?> flushTo, IntSupplier offset) {
        return this.alignFlushTo(flushTo, (Widget widget) -> offset.getAsInt());
    }

    default public Builder alignFlushTo(@Nullable DynamicWidget<?, ?> flushTo, int offset) {
        return this.alignFlushTo(flushTo, () -> offset);
    }

    default public Builder alignFlushTo(@Nullable DynamicWidget<?, ?> flushTo) {
        return this.alignFlushTo(flushTo, 0);
    }

    default public Builder alignVerticalTo(@Nullable DynamicWidget<?, ?> flushTo, ToIntFunction<Widget> offset) {
        if (flushTo == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.AlignVertical(this.self(), flushTo, offset));
        return this.self();
    }

    default public Builder alignVerticalTo(@Nullable DynamicWidget<?, ?> flushTo, IntSupplier offset) {
        return this.alignVerticalTo(flushTo, (Widget widget) -> offset.getAsInt());
    }

    default public Builder alignVerticalTo(@Nullable DynamicWidget<?, ?> flushTo, int offset) {
        return this.alignVerticalTo(flushTo, () -> offset);
    }

    default public Builder alignVerticalTo(@Nullable DynamicWidget<?, ?> flushTo) {
        return this.alignVerticalTo(flushTo, 0);
    }

    default public Builder centerInScreenX(ToIntFunction<Widget> extraWidth) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XPos.CenterInScreen(this.self(), extraWidth));
        return this.self();
    }

    default public Builder centerInScreenX(IntSupplier extraWidth) {
        return this.centerInScreenX((Widget widget) -> extraWidth.getAsInt());
    }

    default public Builder centerInScreenX(int extraWidth) {
        return this.centerInScreenX(() -> extraWidth);
    }

    default public Builder centerInScreenX() {
        return this.centerInScreenX(0);
    }

    default public Builder centerInScreenY(ToIntFunction<Widget> extraHeight) {
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.CenterInScreen(this.self(), extraHeight));
        return this.self();
    }

    default public Builder centerInScreenY(IntSupplier extraHeight) {
        return this.centerInScreenY((Widget widget) -> extraHeight.getAsInt());
    }

    default public Builder centerInScreenY(int extraHeight) {
        return this.centerInScreenY(() -> extraHeight);
    }

    default public Builder centerInScreenY() {
        return this.centerInScreenY(0);
    }

    default public Builder centerInWidgetX(@Nullable DynamicWidget<?, ?> centerIn, ToIntFunction<Widget> extraWidth) {
        if (centerIn == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.XPos.CenterInWidget(this.self(), centerIn, extraWidth));
        return this.self();
    }

    default public Builder centerInWidgetX(@Nullable DynamicWidget<?, ?> centerIn, IntSupplier extraWidth) {
        return this.centerInWidgetX(centerIn, (Widget widget) -> extraWidth.getAsInt());
    }

    default public Builder centerInWidgetX(@Nullable DynamicWidget<?, ?> centerIn, int extraWidth) {
        return this.centerInWidgetX(centerIn, () -> extraWidth);
    }

    default public Builder centerInWidgetX(@Nullable DynamicWidget<?, ?> centerIn) {
        return this.centerInWidgetX(centerIn, 0);
    }

    default public Builder centerInWidgetY(@Nullable DynamicWidget<?, ?> centerIn, ToIntFunction<Widget> extraHeight) {
        if (centerIn == null) {
            return this.self();
        }
        ((DynamicBuilder)this.self()).addFunction(new DynamicLayout.YPos.CenterInWidget(this.self(), centerIn, extraHeight));
        return this.self();
    }

    default public Builder centerInWidgetY(@Nullable DynamicWidget<?, ?> centerIn, IntSupplier extraHeight) {
        return this.centerInWidgetY(centerIn, (Widget widget) -> extraHeight.getAsInt());
    }

    default public Builder centerInWidgetY(@Nullable DynamicWidget<?, ?> centerIn, int extraHeight) {
        return this.centerInWidgetY(centerIn, () -> extraHeight);
    }

    default public Builder centerInWidgetY(@Nullable DynamicWidget<?, ?> centerIn) {
        return this.centerInWidgetY(centerIn, 0);
    }

    default public Builder relativeTo(@Nullable RelativeLayout relativeLayout) {
        ((DynamicBuilder)this.self()).relativeLayout = relativeLayout;
        return this.self();
    }

    default public Builder forceRelativeX() {
        ((DynamicBuilder)this.self()).forceRelativeX = true;
        return this.self();
    }

    default public Builder forceRelativeY() {
        ((DynamicBuilder)this.self()).forceRelativeY = true;
        return this.self();
    }

    default public Builder anchor() {
        ((DynamicBuilder)this.self()).relativeAnchor = true;
        return this.self();
    }

    default public Builder removeAnchor() {
        ((DynamicBuilder)this.self()).relativeAnchor = false;
        return this.self();
    }

    default public Builder addFollowers(Collection<? extends DynamicWidget<?, ?>> widgets) {
        ((DynamicBuilder)this.self()).followers.addAll(widgets);
        return this.self();
    }

    default public Builder addFollowers(DynamicWidget<?, ?> ... widgets) {
        return this.addFollowers(List.of(widgets));
    }

    default public Builder resetX() {
        ((DynamicBuilder)this.self()).x = null;
        return this.self();
    }

    default public Builder resetY() {
        ((DynamicBuilder)this.self()).y = null;
        return this.self();
    }

    default public Builder resetWidth() {
        ((DynamicBuilder)this.self()).width = null;
        return this.self();
    }

    default public Builder resetHeight() {
        ((DynamicBuilder)this.self()).height = null;
        return this.self();
    }
}

