/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.group;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupResizer;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupSync;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class Group
extends DynamicWidget<GroupBuilder, Group>
implements RelativeLayout,
WidgetHolder {
    final IconWidget icon;
    final UniqueArrayList<DynamicWidget<?, ?>> widgets;

    public static GroupBuilder create(WidgetHolder parent) {
        return new GroupBuilder(parent);
    }

    protected Group(GroupBuilder builder) {
        super(builder);
        this.widgets = builder.widgets;
        this.icon = (IconWidget)IconTemplate.text(builder.icon).build();
        ((GroupBuilder)this.getBuilder()).widgets.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)this::setWidgetRelative));
        ((GroupBuilder)this.getBuilder()).addFunction(new GroupSync());
        ((GroupBuilder)this.getBuilder()).addFunction(new GroupResizer());
        builder.parent.addWidgets(this.widgets);
        CollectionUtil.fromCast(this.getWidgetStream().map(DynamicWidget::getBuilder), LayoutBuilder.class).forEach(layout -> layout.relativeTo(this));
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    protected void setWidgetRelative(DynamicWidget<?, ?> widget) {
        ((GroupBuilder)this.builder).parent.addWidget(widget);
        Object obj = widget.getBuilder();
        if (obj instanceof LayoutBuilder) {
            LayoutBuilder layout = (LayoutBuilder)obj;
            layout.relativeTo(this);
        }
    }

    @Override
    public void addWidget(DynamicWidget<?, ?> widget) {
        this.setWidgetRelative(widget);
        this.widgets.add(widget);
    }

    @Override
    public void removeWidget(DynamicWidget<?, ?> widget) {
        ((GroupBuilder)this.builder).parent.removeWidget(widget);
        this.widgets.remove(widget);
    }

    public boolean isBordered() {
        return ((GroupBuilder)this.builder).border;
    }

    public Color getColor() {
        return ((GroupBuilder)this.builder).borderColor;
    }

    public boolean isTitled() {
        return ((GroupBuilder)this.builder).groupTitle != null;
    }

    public Component getTitle() {
        return TextUtil.ellipsis(arg_0 -> ((Font)GuiUtil.font()).m_92895_(arg_0), ((GroupBuilder)this.builder).groupTitle.get(), this.width - (this.isBordered() ? 32 : 0));
    }

    public int getInsidePaddingX() {
        return this.isBordered() ? 9 : 0;
    }

    public int getInsidePaddingY() {
        return this.isBordered() || this.isTitled() ? 12 : 0;
    }

    public int getInsideX() {
        return this.x + this.getInsidePaddingX() + ((GroupBuilder)this.builder).paddingLeft;
    }

    public int getInsideY() {
        return this.y + this.getInsidePaddingY() + ((GroupBuilder)this.builder).paddingTop;
    }

    public int getInsideWidth() {
        return this.width - (this.isBordered() ? 18 : 0) - ((GroupBuilder)this.builder).paddingRight - ((GroupBuilder)this.builder).paddingLeft;
    }

    public int getInsideHeight() {
        return this.height - (this.isBordered() ? 21 : 0) - ((GroupBuilder)this.builder).paddingBottom - ((GroupBuilder)this.builder).paddingTop;
    }

    @Override
    public int getRelativeX(DynamicWidget<?, ?> widget) {
        return this.getInsideX();
    }

    @Override
    public int getRelativeY(DynamicWidget<?, ?> widget) {
        return this.getInsideY();
    }

    @Override
    public int getAnchoredX(DynamicWidget<?, ?> widget) {
        return this.getInsideX();
    }

    @Override
    public int getAnchoredY(DynamicWidget<?, ?> widget) {
        return this.getInsideY();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        if (((GroupBuilder)this.builder).backgroundColor.isPresent()) {
            RenderUtil.fill(graphics, (float)this.x, (float)this.y, (float)this.getEndX(), (float)this.getEndY(), ((GroupBuilder)this.builder).backgroundColor);
        }
        if (this.isBordered()) {
            this.renderBorder(graphics, mouseX, mouseY, partialTick);
        } else if (((GroupBuilder)this.builder).outline) {
            Color color = ((GroupBuilder)this.builder).outlineColor;
            float thickness = ((GroupBuilder)this.builder).outlineThickness;
            RenderUtil.outline(graphics, (float)this.x, (float)this.y, (float)this.width, (float)this.height, thickness, color);
        } else if (((GroupBuilder)this.builder).groupTitle != null) {
            int textX = this.x;
            int textY = this.y;
            if (((GroupBuilder)this.builder).icon.isPresent()) {
                this.icon.pos(textX, textY);
                this.icon.m_88315_(graphics, mouseX, mouseY, partialTick);
                textX = this.icon.getEndX() + 4;
            }
            DrawText.begin(graphics, this.getTitle()).pos(textX, textY).draw();
        }
        this.renderDebug(graphics);
    }

    private void renderBorder(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)this.x, (double)this.y, 0.0);
        Color color = ((GroupBuilder)this.builder).borderColor;
        float yOffset = this.isTitled() ? (float)GuiUtil.textHeight() / 2.0f - 2.0f : 0.0f;
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, 0.0f, yOffset + 2.0f, 2.0f, (float)this.height, color);
        RenderUtil.fill(graphics, 2.0f, (float)this.height - 2.0f, (float)this.width - 2.0f, (float)this.height, color);
        RenderUtil.fill(graphics, (float)this.width - 2.0f, yOffset + 2.0f, (float)this.width, (float)this.height, color);
        if (((GroupBuilder)this.builder).groupTitle != null) {
            Component title = this.getTitle();
            float atText = this.getInsideX() - this.x;
            float beforeText = atText - 4.0f;
            float afterText = beforeText + (float)GuiUtil.font().m_92852_((FormattedText)title) + 7.0f;
            if (((GroupBuilder)this.builder).icon.isPresent()) {
                this.icon.pos(Math.round(atText), 0);
                this.icon.m_88315_(graphics, mouseX, mouseY, partialTick);
                float iconOffset = (float)this.icon.m_5711_() + 4.0f;
                atText += iconOffset;
                afterText += iconOffset;
            }
            RenderUtil.fill(graphics, 0.0f, yOffset, beforeText, yOffset + 2.0f, color);
            RenderUtil.fill(graphics, afterText, yOffset, (float)this.width, yOffset + 2.0f, color);
            DrawText.begin(graphics, title).posX(atText).draw();
        } else {
            RenderUtil.fill(graphics, 0.0f, 0.0f, (float)this.width, 2.0f, color);
        }
        RenderUtil.endBatching();
        graphics.m_280168_().m_85849_();
    }
}

