/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.group;

import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.PaddingManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;

public class GroupBuilder
extends DynamicBuilder<GroupBuilder, Group>
implements LayoutBuilder<GroupBuilder, Group>,
ActiveBuilder<GroupBuilder, Group>,
VisibleBuilder<GroupBuilder, Group>,
PaddingManager<GroupBuilder> {
    final WidgetHolder parent;
    final UniqueArrayList<DynamicWidget<?, ?>> widgets;
    Supplier<Component> groupTitle = null;
    TextureIcon icon = TextureIcon.EMPTY;
    Color outlineColor = Color.TRANSPARENT;
    Color backgroundColor = Color.TRANSPARENT;
    Color borderColor = Color.WHITE;
    boolean outline = false;
    boolean border = false;
    float outlineThickness = 2.0f;
    int bottomOffset = 0;
    int paddingTop = 0;
    int paddingBottom = 0;
    int paddingLeft = 0;
    int paddingRight = 0;

    protected GroupBuilder(WidgetHolder parent) {
        this.parent = parent;
        this.widgets = new UniqueArrayList();
        this.canFocus = BooleanSupplier.NEVER;
    }

    @Override
    public GroupBuilder self() {
        return this;
    }

    @Override
    public GroupBuilder paddingLeft(int padding) {
        this.paddingLeft = padding;
        return this;
    }

    @Override
    public GroupBuilder paddingTop(int padding) {
        this.paddingTop = padding;
        return this;
    }

    @Override
    public GroupBuilder paddingRight(int padding) {
        this.paddingRight = padding;
        return this;
    }

    @Override
    public GroupBuilder paddingBottom(int padding) {
        this.paddingBottom = padding;
        return this;
    }

    public GroupBuilder addWidget(DynamicWidget<?, ?> widget) {
        if (this.widget.isEmpty()) {
            this.widgets.add(widget);
        } else {
            ((Group)this.widget.getOrThrow()).addWidget(widget);
        }
        return this;
    }

    public GroupBuilder bottomOffset(int offset) {
        this.bottomOffset = offset;
        return this;
    }

    public GroupBuilder outline(Color color, float thickness) {
        this.border = false;
        this.outline = true;
        this.outlineColor = color;
        this.outlineThickness = thickness;
        return this;
    }

    public GroupBuilder outline(Color color) {
        return this.outline(color, 2.0f);
    }

    public GroupBuilder border(Color color) {
        this.outline = false;
        this.border = true;
        this.borderColor = color;
        return this;
    }

    public GroupBuilder background(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public GroupBuilder icon(TextureIcon icon) {
        this.icon = icon;
        return this;
    }

    public GroupBuilder title(Supplier<Component> supplier) {
        this.groupTitle = supplier;
        return this;
    }

    public GroupBuilder title(Translation langKey) {
        return this.title(() -> langKey.get(new Object[0]));
    }

    public GroupBuilder title(Component title) {
        return this.title(() -> title);
    }

    public GroupBuilder title(String title) {
        return this.title((Component)Component.m_237113_((String)title));
    }

    protected boolean isHeightOverridden() {
        return this.height != null;
    }

    @Override
    protected Group construct() {
        return new Group(this);
    }
}

