/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.group;

import java.util.List;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicPriority;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;

class GroupResizer
implements DynamicFunction<GroupBuilder, Group> {
    private final RecursionAvoidance sync = RecursionAvoidance.create();
    private int resizedCache = 0;

    GroupResizer() {
    }

    private int getHeight(Group group) {
        DynamicWidget.syncWithoutCache(group.widgets);
        int padding = group.isBordered() ? 9 : 0;
        int maxEndY = group.getVisibleWidgets().mapToInt(DynamicWidget::getEndY).max().orElse(0);
        int offset = ((GroupBuilder)group.getBuilder()).bottomOffset + ((GroupBuilder)group.getBuilder()).paddingBottom;
        return Math.max(Math.abs(maxEndY + padding + offset - group.m_252907_()), 20);
    }

    private boolean isResizeNeeded(Group group, WidgetCache cache) {
        this.resizedCache = this.getHeight(group);
        if (((GroupBuilder)group.getBuilder()).isHeightOverridden() && group.m_93694_() >= this.resizedCache) {
            return false;
        }
        boolean isHeightChanged = group.m_93694_() != this.resizedCache;
        boolean isCacheChanged = CacheValue.isAnyExpired(cache.width, cache.height);
        return isHeightChanged || isCacheChanged;
    }

    @Override
    public void apply(Group group, GroupBuilder builder) {
        group.setHeight(this.resizedCache);
        this.sync.process(builder::sync);
    }

    @Override
    public boolean isReapplyNeeded(Group group, GroupBuilder builder, WidgetCache cache) {
        if (group.getVisibleWidgets().findAny().isEmpty()) {
            return false;
        }
        return this.isResizeNeeded(group, cache);
    }

    @Override
    public List<DynamicField> getManaging(GroupBuilder builder) {
        return List.of(DynamicField.HEIGHT);
    }

    @Override
    public DynamicPriority priority() {
        return DynamicPriority.HIGH;
    }
}

