/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.input;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.TooltipBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInput;
import mod.adrenix.nostalgic.client.gui.widget.input.suggestion.InputSuggester;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInputMaker<Builder extends AbstractInputMaker<Builder, Input>, Input extends AbstractInput<Builder, Input>>
extends DynamicBuilder<Builder, Input>
implements LayoutBuilder<Builder, Input>,
ActiveBuilder<Builder, Input>,
VisibleBuilder<Builder, Input>,
TooltipBuilder<Builder, Input>,
IconBuilder<Builder, Input> {
    @Nullable
    protected BiConsumer<Input, String> responder;
    @Nullable
    protected Function<Input, String> sync;
    @Nullable
    protected Function<Input, ? extends InputSuggester<Input>> suggesterProvider;
    protected UniqueArrayList<Consumer<String>> listeners;
    protected BiFunction<String, Integer, FormattedCharSequence> formatter;
    protected Predicate<String> filter;
    protected String whenEmpty = "";
    protected String startWith = "";
    protected String cursor = "_";
    protected int maxLength = 120;
    protected int iconPadding = 2;
    protected long responseDelay = 100L;
    protected boolean delayedResponse = false;
    protected boolean searchShortcut = false;
    protected boolean editable = true;
    @Nullable
    protected Color hoverBackgroundColor = null;
    @Nullable
    protected Color hoverBorderColor = null;
    protected Color backgroundColor = Color.BLACK;
    protected Color backgroundFocusColor = Color.BLACK;
    protected Color borderColor = Color.LIGHT_GRAY;
    protected Color borderFocusColor = Color.WHITE;
    protected Color cursorColor = Color.WHITE;
    protected Color cursorVerticalColor = Color.LIGHT_GRAY;
    protected Color textColor = Color.WHITE;
    protected Color textUnfocusedColor = Color.WHITE;
    protected Color textEmptyColor = Color.LIGHT_GRAY;

    protected AbstractInputMaker() {
        this.brightenOnHover = true;
        this.listeners = new UniqueArrayList();
        this.formatter = (string, maxLength) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);
        this.filter = Objects::nonNull;
    }

    public Builder suggester(@Nullable Function<Input, ? extends InputSuggester<Input>> provider) {
        this.suggesterProvider = provider;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder addListener(Consumer<String> listener) {
        this.listeners.add(listener);
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder removeListener(Consumer<String> listener) {
        this.listeners.remove(listener);
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder onSync(Function<Input, String> function) {
        this.sync = function;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder onSync(Supplier<String> supplier) {
        return this.onSync((Input widget) -> (String)supplier.get());
    }

    public Builder onInput(BiConsumer<Input, String> responder) {
        this.responder = responder;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder onInput(Consumer<String> responder) {
        return this.onInput((Input widget, String typed) -> responder.accept((String)typed));
    }

    public Builder delayedResponse(long delay) {
        this.responseDelay = delay;
        return this.delayedResponse();
    }

    public Builder delayedResponse() {
        this.delayedResponse = true;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder startAsNonEditable() {
        this.editable = false;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder setFilter(Predicate<String> filter) {
        this.filter = filter;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder formatter(BiFunction<String, Integer, FormattedCharSequence> formatter) {
        this.formatter = formatter;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder cursorChar(char cursor) {
        this.cursor = Character.toString(cursor);
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder cursorChar(String cursor) {
        if (cursor.isEmpty()) {
            return (Builder)((AbstractInputMaker)this.self());
        }
        this.cursor = cursor.substring(0, 1);
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder maxLength(int maxLength) {
        this.maxLength = maxLength;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder searchShortcut() {
        this.searchShortcut = true;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder startWith(String value) {
        this.startWith = value;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder whenEmpty(String whenEmpty) {
        this.whenEmpty = whenEmpty;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder whenEmpty(Component whenEmpty) {
        return this.whenEmpty(whenEmpty.getString());
    }

    public Builder whenEmpty(Translation langKey) {
        return this.whenEmpty((Component)langKey.get(new Object[0]));
    }

    public Builder emptyColor(Color color) {
        this.textEmptyColor = color;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder emptyColor(IntSupplier color) {
        return this.emptyColor(new Color(color));
    }

    public Builder emptyColor(int color) {
        return this.emptyColor(new Color(color));
    }

    public Builder iconPadding(int padding) {
        this.iconPadding = padding;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder background(Color unfocused, Color focused) {
        this.backgroundColor = unfocused;
        this.backgroundFocusColor = focused;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder background(IntSupplier unfocused, IntSupplier focused) {
        return this.background(new Color(unfocused), new Color(focused));
    }

    public Builder background(int unfocused, int focused) {
        return this.background(new Color(unfocused), new Color(focused));
    }

    public Builder background(Color color) {
        return this.background(color, color.brighter());
    }

    public Builder background(IntSupplier color) {
        return this.background(new Color(color), new Color(color).brighter());
    }

    public Builder background(int color) {
        return this.background(new Color(color), new Color(color).brighter());
    }

    public Builder border(Color unfocused, Color focused) {
        this.borderColor = unfocused;
        this.borderFocusColor = focused;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder border(IntSupplier unfocused, IntSupplier focused) {
        return this.border(new Color(unfocused), new Color(focused));
    }

    public Builder border(int unfocused, int focused) {
        return this.border(new Color(unfocused), new Color(focused));
    }

    public Builder border(Color color) {
        return this.border(color, color.brighter());
    }

    public Builder border(IntSupplier color) {
        return this.border(new Color(color), new Color(color).brighter());
    }

    public Builder border(int color) {
        return this.border(new Color(color), new Color(color).brighter());
    }

    public Builder hover(Color border, Color background) {
        this.hoverBorderColor = border;
        this.hoverBackgroundColor = background;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder hover(IntSupplier border, IntSupplier background) {
        return this.hover(new Color(border), new Color(background));
    }

    public Builder hover(int border, int background) {
        return this.hover(new Color(border), new Color(background));
    }

    public Builder textColor(Color focused, Color unfocused) {
        this.textColor = focused;
        this.textUnfocusedColor = unfocused;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder textColor(IntSupplier focused, IntSupplier unfocused) {
        return this.textColor(new Color(focused), new Color(unfocused));
    }

    public Builder textColor(int focused, int unfocused) {
        return this.textColor(new Color(focused), new Color(unfocused));
    }

    public Builder textColor(Color color) {
        this.textColor = color;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder textColor(IntSupplier color) {
        return this.textColor(new Color(color));
    }

    public Builder textColor(int color) {
        return this.textColor(new Color(color));
    }

    public Builder cursorColor(Color color) {
        this.cursorColor = color;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder cursorColor(IntSupplier color) {
        return this.cursorColor(new Color(color));
    }

    public Builder cursorColor(int color) {
        return this.cursorColor(new Color(color));
    }

    public Builder cursorVerticalColor(Color color) {
        this.cursorVerticalColor = color;
        return (Builder)((AbstractInputMaker)this.self());
    }

    public Builder cursorVerticalColor(IntSupplier color) {
        return this.cursorVerticalColor(new Color(color));
    }

    public Builder cursorVerticalColor(int color) {
        return this.cursorVerticalColor(new Color(color));
    }
}

