/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.input;

import java.util.ArrayList;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInput;
import mod.adrenix.nostalgic.client.gui.widget.input.ColorInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.HexInput;
import mod.adrenix.nostalgic.client.gui.widget.input.InputModule;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ColorInput
extends AbstractInput<ColorInputBuilder, ColorInput> {
    protected final BlankWidget colorSample;
    protected boolean insertingText;

    public static ColorInputBuilder create(Color color) {
        return new ColorInputBuilder(color);
    }

    protected ColorInput(ColorInputBuilder builder) {
        super(builder);
        this.setInput(HexInput.update(builder.startWith, builder.opaqueColor));
        builder.formatter(this::formatHex);
        this.module = InputModule.color((ColorInput)this.self());
        this.cursorPos = 1;
        this.highlightPos = 1;
        this.minCursorPos = 1;
        this.colorSample = ((BlankBuilder)((BlankBuilder)BlankWidget.create().size(GuiUtil.textHeight())).renderer(this::renderSample).leftOf(this.controls, 1)).build(this.internal::add);
        if (builder.displayColorBox) {
            ((BlankBuilder)this.printer.getBuilder()).extendWidthTo(this.colorSample, 4);
        }
        this.internal.moveToEnd(this.printer);
    }

    public ButtonBuilder getPickerButton() {
        return ButtonTemplate.colorPicker(this::getColor, ((ColorInputBuilder)this.builder).onPickerClose, ((ColorInputBuilder)this.builder).opaqueColor);
    }

    public Color getColor() {
        return new Color(HexUtil.parseRGBA(this.input));
    }

    protected FormattedCharSequence formatHex(String format, int beginIndex) {
        ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
        for (int i = beginIndex; i < format.length() + beginIndex; ++i) {
            Style style = switch (i) {
                case 1, 2 -> Style.f_131099_.m_131140_(ChatFormatting.RED);
                case 3, 4 -> Style.f_131099_.m_131140_(ChatFormatting.GREEN);
                case 5, 6 -> Style.f_131099_.m_131140_(ChatFormatting.BLUE);
                case 7, 8 -> Style.f_131099_.m_131140_(ChatFormatting.WHITE);
                default -> Style.f_131099_;
            };
            int begin = Math.min(i, this.input.length());
            int end = Math.min(i + 1, this.input.length());
            sequences.add(FormattedCharSequence.m_13714_((String)this.input.substring(begin, end), (Style)style));
        }
        return FormattedCharSequence.m_13744_(sequences);
    }

    @Override
    public void insertText(String text) {
        if (this.insertingText) {
            return;
        }
        this.insertingText = true;
        for (int i = 0; i < text.length(); ++i) {
            this.deleteChars(1);
        }
        super.insertText(text);
        this.insertingText = false;
    }

    protected void renderSample(BlankWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!((ColorInputBuilder)this.builder).displayColorBox) {
            return;
        }
        RenderUtil.fill(graphics, (float)widget.m_252754_(), (float)widget.m_252907_(), (float)widget.getEndX(), (float)widget.getEndY(), this.getColor());
    }
}

