/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.input;

import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInput;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInputMaker;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;

public class InputModule<Builder extends AbstractInputMaker<Builder, Input>, Input extends AbstractInput<Builder, Input>> {
    private final Input widget;
    private final Overlay overlay;
    private final ButtonWidget copy;
    private final ButtonWidget paste;
    private final ButtonWidget trash;

    static <Builder extends AbstractInputMaker<Builder, Input>, Input extends AbstractInput<Builder, Input>> InputModule<Builder, Input> generic(Input widget) {
        return new InputModule<Builder, Input>(widget, ModuleType.GENERIC);
    }

    static <Builder extends AbstractInputMaker<Builder, Input>, Input extends AbstractInput<Builder, Input>> InputModule<Builder, Input> color(Input widget) {
        return new InputModule<Builder, Input>(widget, ModuleType.COLOR);
    }

    private InputModule(Input widget, ModuleType type) {
        this.widget = widget;
        this.overlay = Overlay.create().size(66, 24).setX(() -> widget.getEndX() - 66).above((LayoutElement)widget, -3).backgroundColor(((AbstractInput)widget).getBackgroundColor()).addListener((DynamicWidget<?, ?>)widget).postRenderer(this::renderOutline).unmovable().shadowless().borderless().build();
        this.copy = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().pos(2, 2)).icon(Icons.COPY)).tooltip(Lang.Input.COPY, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Input.COPY_INFO, 35)).onPress(() -> Minecraft.m_91087_().f_91068_.m_90911_(widget.input))).build(this.overlay::addWidget);
        this.paste = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.CLIPBOARD)).tooltip(Lang.Input.PASTE, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Input.PASTE_INFO, 35)).rightOf(this.copy, 1)).build(this.overlay::addWidget);
        switch (type) {
            case GENERIC: {
                ((ButtonBuilder)this.paste.getBuilder()).onPress(() -> widget.insertText(Minecraft.m_91087_().f_91068_.m_90876_()));
                break;
            }
            case COLOR: {
                ((ButtonBuilder)this.paste.getBuilder()).onPress(() -> widget.setInput(Minecraft.m_91087_().f_91068_.m_90876_()));
            }
        }
        this.trash = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.TRASH_CAN)).tooltip(Lang.Input.CLEAR, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Input.CLEAR_INFO, 35)).rightOf(this.paste, 1)).onPress(() -> widget.setInput(""))).build(this.overlay::addWidget);
        switch (type) {
            case GENERIC: {
                ((ButtonBuilder)this.trash.getBuilder()).onPress(() -> widget.setInput(""));
                break;
            }
            case COLOR: {
                ((ButtonBuilder)this.trash.getBuilder()).onPress(() -> widget.setInput("#"));
            }
        }
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public ButtonWidget getCopy() {
        return this.copy;
    }

    public ButtonWidget getPaste() {
        return this.paste;
    }

    public ButtonWidget getTrash() {
        return this.trash;
    }

    private void renderOutline(Overlay overlay, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color color = ((AbstractInput)this.widget).getBorderColor();
        float x0 = (float)overlay.getX();
        float y0 = (float)overlay.getY();
        float x1 = (float)overlay.getEndX() - 1.0f;
        float y1 = (float)overlay.getEndY();
        RenderUtil.beginBatching();
        RenderUtil.vLine(graphics, x0, y0, y1 - 2.0f, color);
        RenderUtil.vLine(graphics, x1, y0, y1, color);
        RenderUtil.hLine(graphics, x0, y0, x1, color);
        RenderUtil.endBatching();
    }

    private static enum ModuleType {
        GENERIC,
        COLOR;

    }
}

