/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.keybinding;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButton;
import mod.adrenix.nostalgic.client.gui.widget.keybinding.KeybindingBuilder;
import mod.adrenix.nostalgic.tweak.factory.TweakBinding;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class KeybindingWidget
extends AbstractButton<KeybindingBuilder, KeybindingWidget> {
    private final TweakBinding tweak;
    private final KeyMapping mapping;

    public static KeybindingBuilder create(TweakBinding tweak) {
        return new KeybindingBuilder(tweak);
    }

    protected KeybindingWidget(KeybindingBuilder builder, Consumer<KeybindingWidget> onPress) {
        super(builder, onPress);
        this.tweak = builder.tweak;
        this.mapping = builder.mapping;
        builder.title(this::setTitle);
    }

    public void reset() {
        InputConstants.Key defaultKey = this.mapping.m_90861_();
        Minecraft.m_91087_().f_91066_.m_92159_(this.mapping, defaultKey);
        this.tweak.setCacheAndDiskThenSave(defaultKey.m_84873_());
        KeyMapping.m_90854_();
        this.m_93692_(false);
    }

    protected void setKey(int keyCode, int scanCode) {
        if (KeyboardUtil.isEsc(keyCode)) {
            Minecraft.m_91087_().f_91066_.m_92159_(this.mapping, InputConstants.f_84822_);
            this.tweak.setCacheAndDiskThenSave(InputConstants.f_84822_.m_84873_());
        } else {
            InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
            Minecraft.m_91087_().f_91066_.m_92159_(this.mapping, key);
            this.tweak.setCacheAndDiskThenSave(key.m_84873_());
        }
        KeyMapping.m_90854_();
        this.m_93692_(false);
    }

    protected Component setTitle() {
        if (this.m_93696_()) {
            return Component.m_237113_((String)"> ").m_7220_((Component)this.mapping.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" <").m_130940_(ChatFormatting.YELLOW);
        }
        if (this.mapping.m_90862_()) {
            return Lang.Binding.UNBOUND.withStyle(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC);
        }
        if (KeyboardUtil.isMappingConflict(this.mapping)) {
            return this.mapping.m_90863_().m_6881_().m_130940_(ChatFormatting.RED);
        }
        return this.mapping.m_90863_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_93696_() && this.isActive() && modifiers == 0) {
            this.setKey(keyCode, scanCode);
            this.m_93692_(false);
            return true;
        }
        return false;
    }
}

