/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.list;

import java.util.Optional;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.RowResizer;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRow<Builder extends AbstractRowMaker<Builder, Row>, Row extends AbstractRow<Builder, Row>>
extends DynamicWidget<Builder, Row>
implements ContainerEventHandler,
RelativeLayout,
WidgetHolder {
    protected final UniqueArrayList<DynamicWidget<?, ?>> widgets;
    protected final RecursionAvoidance pathFinder;
    protected final RowList rowList;
    protected boolean initialized;

    protected AbstractRow(Builder builder) {
        super(builder);
        if (((AbstractRowMaker)builder).highlightColor == null) {
            ((AbstractRowMaker)builder).highlightColor = Color.WHITE;
        }
        this.widgets = ((AbstractRowMaker)builder).widgets;
        this.rowList = ((AbstractRowMaker)builder).rowList;
        this.pathFinder = RecursionAvoidance.create();
        this.setScreen(this.rowList.getScreen());
        ((AbstractRowMaker)this.getBuilder()).addFunction(new RowResizer());
        this.widgets.stream().map(DynamicWidget::getBuilder).forEach(dynamic -> dynamic.whenFocused(() -> this.rowList.setScrollOn(this)));
        CollectionUtil.fromCast(this.getWidgetStream().map(DynamicWidget::getBuilder), LayoutBuilder.class).forEach(layout -> layout.relativeTo(this));
        this.widgets.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)widget -> widget.setScreen(this.rowList.getScreen())));
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    public UniqueArrayList<? extends GuiEventListener> children() {
        return this.widgets;
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        if (event instanceof FocusNavigationEvent.TabNavigation) {
            return this.pathFinder.process(() -> super.m_264064_(event));
        }
        return null;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.rowList.focusedListener;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        this.rowList.m_7522_(focused);
    }

    @Override
    @Nullable
    public ComponentPath m_264435_() {
        return super.m_264435_();
    }

    public boolean m_7282_() {
        return false;
    }

    public void m_7897_(boolean isDragging) {
    }

    @Override
    public void addWidget(DynamicWidget<?, ?> widget) {
        widget.setScreen(this.rowList.getScreen());
        Object obj = widget.getBuilder();
        if (obj instanceof LayoutBuilder) {
            LayoutBuilder layout = (LayoutBuilder)obj;
            layout.relativeTo(this);
        }
        this.widgets.add(widget);
    }

    @Override
    public void removeWidget(DynamicWidget<?, ?> widget) {
        this.widgets.remove(widget);
    }

    public void moveToFront(DynamicWidget<?, ?> widget) {
        if (!this.widgets.contains(widget)) {
            this.addWidget(widget);
        }
        this.widgets.remove(widget);
        this.widgets.add(0, widget);
    }

    public void clear() {
        this.widgets.clear();
    }

    public RowList getRowList() {
        return this.rowList;
    }

    public Optional<Animation> getHighlightAnimation() {
        return Optional.ofNullable(((AbstractRowMaker)this.getBuilder()).highlightAnimation);
    }

    @Override
    public int getRelativeX(DynamicWidget<?, ?> widget) {
        return this.m_252754_();
    }

    @Override
    public int getRelativeY(DynamicWidget<?, ?> widget) {
        return this.m_252907_();
    }

    @Override
    public int getAnchoredX(DynamicWidget<?, ?> widget) {
        return this.m_252754_();
    }

    @Override
    public int getAnchoredY(DynamicWidget<?, ?> widget) {
        return this.m_252907_();
    }

    public int getHeightWithMargin() {
        int heightWithMargin = this.m_93694_() + this.rowList.getRowMargin();
        if (this.rowList.getLastVisibleRow().stream().anyMatch(row -> row.equals(this))) {
            heightWithMargin -= this.rowList.getRowSeparatorMargin();
        }
        return heightWithMargin;
    }

    public int getDefaultRowHeight() {
        return ((RowListBuilder)this.rowList.getBuilder()).defaultRowHeight;
    }

    public Color getHighlightColor() {
        return ((AbstractRowMaker)this.getBuilder()).highlightColor;
    }

    public double getHighlightAlpha() {
        return ((AbstractRowMaker)this.getBuilder()).highlightAlpha;
    }

    public int getIndent() {
        return ((AbstractRowMaker)this.getBuilder()).indent;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        boolean isMouseOverList = this.rowList.m_5953_(mouseX, mouseY);
        boolean isMouseOverRow = MathUtil.isWithinBox(mouseX, mouseY, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
        return isMouseOverList && isMouseOverRow;
    }

    public Optional<DynamicWidget<?, ?>> getWidgetAtPoint(double mouseX, double mouseY) {
        return this.getVisibleWidgets().filter(widget -> widget.m_5953_(mouseX, mouseY)).findFirst();
    }

    public Optional<DynamicWidget<?, ?>> getFocusedWidget() {
        return this.getVisibleWidgets().filter(DynamicWidget::m_93696_).findFirst();
    }

    public boolean isWidgetFocused() {
        return this.getVisibleWidgets().anyMatch(DynamicWidget::m_93696_);
    }

    public void focusOnFirst() {
        this.getVisibleWidgets().filter(DynamicWidget::canFocus).findFirst().ifPresent(DynamicWidget::setFocused);
    }

    public boolean hasFocusable() {
        return this.getVisibleWidgets().anyMatch(DynamicWidget::canFocus);
    }

    public boolean isOutside() {
        return this.getEndY() < this.rowList.m_252907_() || this.m_252907_() > this.rowList.getEndY();
    }

    public boolean isInsideViewingArea() {
        return !this.isOutside();
    }

    protected boolean isVisibilityChanged() {
        if (this.isVisible() && this.widgets.stream().noneMatch(DynamicWidget::getVisibleTest)) {
            this.setInvisible();
            return true;
        }
        if (this.isInvisible() && this.widgets.stream().anyMatch(DynamicWidget::getVisibleTest)) {
            this.setVisible();
            return true;
        }
        return this.cache.visible.isExpired();
    }

    protected void update(int rowStartX, int rowStartY, int rowWidth) {
        int startX = rowStartX + ((AbstractRowMaker)this.getBuilder()).indent;
        int width = rowWidth - ((AbstractRowMaker)this.getBuilder()).indent;
        int yOffset = rowStartY - this.m_252907_();
        boolean isInactive = this.isInactive() || this.rowList.isInactive();
        boolean isInvisible = this.isInvisible() || this.rowList.isInvisible();
        boolean isHorizontalShift = startX != this.x || width != this.width;
        boolean isVerticalShift = rowStartY != this.y;
        this.m_253211_(rowStartY);
        this.m_252865_(startX);
        this.setWidth(width);
        Consumer<DynamicWidget> setWidgetStateOverride = widget -> {
            if (isInactive) {
                widget.setInactive();
            }
            if (isInvisible) {
                widget.setInvisible();
            }
        };
        if (this.isInsideViewingArea() || isHorizontalShift || !this.initialized) {
            DynamicWidget.sync(this.widgets);
            if (isHorizontalShift || !this.initialized) {
                this.initialized = true;
                ((AbstractRowMaker)this.getBuilder()).sync();
            }
            if (this.isInactive() || this.isInvisible() || isInactive || isInvisible) {
                this.widgets.forEach((Consumer<DynamicWidget<?, ?>>)setWidgetStateOverride);
            }
        } else if (isVerticalShift) {
            this.widgets.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)widget -> {
                widget.m_253211_(widget.m_252907_() + yOffset);
                setWidgetStateOverride.accept((DynamicWidget)widget);
            }));
        } else if (isInactive || isInvisible) {
            this.widgets.forEach((Consumer<DynamicWidget<?, ?>>)setWidgetStateOverride);
        }
    }

    protected void renderHidden(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (((AbstractRowMaker)this.getBuilder()).hiddenRenderer != null) {
            ((AbstractRowMaker)this.getBuilder()).hiddenRenderer.accept((AbstractRow)this.self(), graphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        if (((AbstractRowMaker)this.getBuilder()).preRenderer != null) {
            ((AbstractRowMaker)this.getBuilder()).preRenderer.accept((AbstractRow)this.self(), graphics, mouseX, mouseY, partialTick);
        }
        DynamicWidget.renderWithoutSync(this.widgets, graphics, mouseX, mouseY, partialTick);
        if (((AbstractRowMaker)this.getBuilder()).postRenderer != null) {
            ((AbstractRowMaker)this.getBuilder()).postRenderer.accept((AbstractRow)this.self(), graphics, mouseX, mouseY, partialTick);
        }
        this.renderDebug(graphics);
    }
}

