/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.list;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListRenderer;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.renderer.RenderPass;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.function.FloatSupplier;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class RowListBuilder
extends DynamicBuilder<RowListBuilder, RowList>
implements LayoutBuilder<RowListBuilder, RowList>,
ActiveBuilder<RowListBuilder, RowList>,
VisibleBuilder<RowListBuilder, RowList> {
    int topMargin = 0;
    int heightOverflowMargin = 0;
    int verticalMargin = 4;
    int horizontalMargin = 4;
    int separatorHeight = 1;
    int separatorPadding = 2;
    int defaultRowHeight = 20;
    int defaultRowWidth = 0;
    int scrollbarWidth = 6;
    int scrollbarLeftMargin = 0;
    Color scrollbarBackground = Color.DARK_CHARCOAL;
    Color separatorColor = Color.WHITE;
    boolean leftAlignedScrollbar = false;
    boolean centerRows = false;
    boolean renderBatched = true;
    boolean useSeparators = false;
    boolean useScissorRendering = true;
    boolean showSelectionBorder = false;
    boolean renderBackgroundDirt = false;
    boolean renderTopAndBottomDirt = false;
    boolean renderTopAndBottomShadow = false;
    boolean renderBackgroundOpacity = false;
    double rowHighlightAlpha = 0.0;
    Color rowHighlightColor = Color.WHITE;
    Animation rowHighlightAnimation = null;
    BooleanSupplier useHighlightsWhen = BooleanSupplier.ALWAYS;
    BooleanSupplier useOverrideHighlights = BooleanSupplier.NEVER;
    IntSupplier overrideHighlightOpacity = () -> 100;
    FloatSupplier backgroundOpacity = null;
    Supplier<Rectangle> scissorRectangle = null;
    Supplier<Component> emptyMessage = null;
    RowListRenderer postRenderer = RowListRenderer.EMPTY;
    RowListRenderer backgroundRenderer = RowListRenderer.EMPTY;

    protected RowListBuilder() {
        this.renderPass = RenderPass.FIRST;
    }

    @Override
    public RowListBuilder self() {
        return this;
    }

    public RowListBuilder emptyMessage(Supplier<Component> supplier) {
        this.emptyMessage = supplier;
        return this;
    }

    public RowListBuilder emptyMessage(Component message) {
        return this.emptyMessage(() -> message);
    }

    public RowListBuilder emptyMessage(Translation langKey) {
        return this.emptyMessage(() -> langKey.get(new Object[0]));
    }

    public RowListBuilder useSeparators(Color color, int height, int padding) {
        this.useSeparators = true;
        this.separatorColor = color;
        this.separatorHeight = height;
        this.separatorPadding = padding;
        return this;
    }

    public RowListBuilder useSeparators(Color color) {
        return this.useSeparators(color, 1, 2);
    }

    public RowListBuilder useSeparators(int height, int padding) {
        return this.useSeparators(Color.WHITE, height, padding);
    }

    public RowListBuilder useSeparators() {
        return this.useSeparators(Color.WHITE, 1, 2);
    }

    public RowListBuilder centerRows() {
        this.centerRows = true;
        return this;
    }

    public RowListBuilder leftAlignedScrollbar(int margin) {
        this.leftAlignedScrollbar = true;
        this.scrollbarLeftMargin = margin;
        return this;
    }

    public RowListBuilder scrollbarBackground(Color color) {
        this.scrollbarBackground = color;
        return this;
    }

    public RowListBuilder scrollbarWidth(int width) {
        this.scrollbarWidth = width;
        return this;
    }

    public RowListBuilder defaultRowWidth(int defaultWidth) {
        this.defaultRowWidth = defaultWidth;
        return this;
    }

    public RowListBuilder defaultRowHeight(int defaultHeight) {
        this.defaultRowHeight = defaultHeight;
        return this;
    }

    public RowListBuilder heightOverflowMargin(int margin) {
        this.heightOverflowMargin = margin;
        return this;
    }

    public RowListBuilder showSelectionBorder() {
        this.showSelectionBorder = true;
        return this;
    }

    public RowListBuilder highlight(double alpha, Animation animation, Color color) {
        this.rowHighlightAlpha = Mth.m_14008_((double)alpha, (double)0.0, (double)1.0);
        this.rowHighlightAnimation = animation;
        this.rowHighlightColor = color;
        return this;
    }

    public RowListBuilder highlight(double alpha, Animation animation) {
        return this.highlight(alpha, animation, Color.WHITE);
    }

    public RowListBuilder overrideHighlights(BooleanSupplier when, IntSupplier amount) {
        this.useOverrideHighlights = when;
        this.overrideHighlightOpacity = () -> Mth.m_14045_((int)amount.getAsInt(), (int)0, (int)100);
        return this;
    }

    public RowListBuilder useHighlightsWhen(BooleanSupplier when) {
        this.useHighlightsWhen = when;
        return this;
    }

    public RowListBuilder disableBatchRendering() {
        this.renderBatched = true;
        return this;
    }

    public RowListBuilder topMargin(int margin) {
        this.topMargin = margin;
        return this;
    }

    public RowListBuilder verticalMargin(int margin) {
        this.verticalMargin = margin;
        return this;
    }

    public RowListBuilder horizontalMargin(int margin) {
        this.horizontalMargin = margin;
        return this;
    }

    public RowListBuilder renderBackgroundDirt() {
        this.renderBackgroundDirt = true;
        return this;
    }

    public RowListBuilder renderTopAndBottomDirt() {
        this.renderTopAndBottomDirt = true;
        return this;
    }

    public RowListBuilder renderTopAndBottomShadow() {
        this.renderTopAndBottomShadow = true;
        return this;
    }

    public RowListBuilder disableScissorRendering() {
        this.useScissorRendering = true;
        return this;
    }

    public RowListBuilder useScissorRectangle(Supplier<Rectangle> supplier) {
        this.useScissorRendering = true;
        this.scissorRectangle = supplier;
        return this;
    }

    public RowListBuilder backgroundRenderer(RowListRenderer renderer) {
        this.backgroundRenderer = renderer;
        return this;
    }

    public RowListBuilder backgroundOpacity(IntSupplier opacity) {
        this.backgroundOpacity = () -> Mth.m_14036_((float)((float)opacity.getAsInt() / 100.0f), (float)0.0f, (float)1.0f);
        this.renderBackgroundOpacity = true;
        return this;
    }

    public RowListBuilder backgroundOpacity(int opacity) {
        return this.backgroundOpacity(() -> opacity);
    }

    public RowListBuilder renderBackgroundOpacity() {
        this.renderBackgroundOpacity = true;
        return this;
    }

    public RowListBuilder postRenderer(RowListRenderer renderer) {
        this.postRenderer = renderer;
        return this;
    }

    @Override
    protected RowList construct() {
        return new RowList(this);
    }
}

