/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.list;

import java.util.List;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicPriority;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.list.RowData;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.util.common.data.CacheValue;

class RowResizer<Builder extends AbstractRowMaker<Builder, Row>, Row extends AbstractRow<Builder, Row>>
implements DynamicFunction<Builder, Row> {
    private int resizedCache = 0;

    RowResizer() {
    }

    private int getHeight(Row row) {
        int defaultHeight = ((RowListBuilder)((AbstractRow)row).getRowList().getBuilder()).defaultRowHeight;
        int margin = ((AbstractRowMaker)((DynamicWidget)row).getBuilder()).heightOverflowMargin;
        int maxEndY = row.getVisibleWidgets().filter(widget -> !widget.has((Object)RowData.WIDGET_SYNCED_WITH_HEIGHT)).mapToInt(DynamicWidget::getEndY).max().orElse(0);
        int widgetHeight = Math.abs(((DynamicWidget)row).m_252907_() - maxEndY) + margin;
        if (widgetHeight == 0 || widgetHeight <= defaultHeight) {
            return defaultHeight;
        }
        return widgetHeight;
    }

    private boolean isResizeNeeded(Row row, WidgetCache cache) {
        if (((DynamicWidget)row).isInvisible() || !((AbstractRow)row).initialized) {
            return false;
        }
        this.resizedCache = this.getHeight(row);
        boolean isHeightChanged = ((DynamicWidget)row).m_93694_() != this.resizedCache;
        boolean isCacheChanged = CacheValue.isAnyExpired(cache.width, cache.height);
        return isHeightChanged || isCacheChanged;
    }

    @Override
    public void apply(Row row, Builder builder) {
        ((DynamicWidget)row).setHeight(this.resizedCache);
    }

    @Override
    public boolean isReapplyNeeded(Row row, Builder builder, WidgetCache cache) {
        return this.isResizeNeeded(row, cache);
    }

    @Override
    public List<DynamicField> getManaging(Builder builder) {
        return List.of(DynamicField.HEIGHT);
    }

    @Override
    public DynamicPriority priority() {
        return DynamicPriority.HIGH;
    }
}

