/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.slider;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.widget.WidgetBackground;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.slider.AbstractSliderMaker;
import mod.adrenix.nostalgic.client.gui.widget.slider.ValueSync;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.GameSprite;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.sprite.GuiSprite;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public abstract class AbstractSlider<Builder extends AbstractSliderMaker<Builder, Slider>, Slider extends AbstractSlider<Builder, Slider>>
extends DynamicWidget<Builder, Slider> {
    protected double value;
    protected Component title;
    protected boolean dragging;
    protected int handleWidth = 8;
    protected final SimpleTimer scrollTimer = SimpleTimer.create(1500L, TimeUnit.MILLISECONDS).waitFirst().build();
    protected final Animation scrollAnimator = Animate.linear();

    protected AbstractSlider(Builder builder) {
        super(builder);
        ((AbstractSliderMaker)this.builder).addFunction(new ValueSync((AbstractSlider)this.self()));
        this.applyTitle();
    }

    public void setValue(double value) {
        this.setNormalizedValue((value - this.getMin()) / (this.getMax() - this.getMin()));
    }

    public double getValue() {
        return ((AbstractSliderMaker)this.builder).valueSupplier.get().doubleValue();
    }

    public double getMin() {
        return ((AbstractSliderMaker)this.builder).minValue.doubleValue();
    }

    public double getMax() {
        return ((AbstractSliderMaker)this.builder).maxValue.doubleValue();
    }

    protected void setNormalizedValue(double value) {
        double last = this.value;
        this.value = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (this.value != last) {
            this.applyValue();
            if (((AbstractSliderMaker)this.builder).onValueChange != null) {
                ((AbstractSliderMaker)this.builder).onValueChange.accept((AbstractSlider)this.self());
            }
        }
        this.applyTitle();
    }

    protected void setFromMouse(double mouseX) {
        this.setNormalizedValue((mouseX - ((double)this.m_252754_() + (double)this.handleWidth / 2.0)) / (double)(this.width - this.handleWidth));
    }

    public double getNormalizedValue() {
        return this.value;
    }

    protected void applyValue() {
        Number numberValue = ((AbstractSliderMaker)this.builder).maxValue;
        double sliderValue = this.getMin() + Math.abs(this.getMax() - this.getMin()) * this.value;
        if (((AbstractSliderMaker)this.builder).useRounding) {
            sliderValue = BigDecimal.valueOf(this.getMin() + Math.abs(this.getMax() - this.getMin()) * this.value).setScale(((AbstractSliderMaker)this.builder).roundTo, RoundingMode.HALF_UP).doubleValue();
        }
        if (numberValue instanceof Byte) {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept((byte)Math.round(sliderValue));
        } else if (numberValue instanceof Short) {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept((short)Math.round(sliderValue));
        } else if (numberValue instanceof Integer) {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept((int)Math.round(sliderValue));
        } else if (numberValue instanceof Long) {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept(Math.round(sliderValue));
        } else if (numberValue instanceof Float) {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept(Float.valueOf((float)sliderValue));
        } else {
            ((AbstractSliderMaker)this.builder).valueConsumer.accept(sliderValue);
        }
    }

    protected void applyTitle() {
        String title = ((AbstractSliderMaker)this.builder).title.get().getString();
        String separator = ((AbstractSliderMaker)this.builder).separator.get().getString();
        String value = ((AbstractSliderMaker)this.builder).formatter.apply(((AbstractSliderMaker)this.builder).valueSupplier.get());
        String suffix = ((AbstractSliderMaker)this.builder).suffix.get().getString();
        this.title = title.isEmpty() ? Component.m_237119_() : Component.m_237113_((String)String.format("%s%s%s%s", title, separator, value, suffix));
        if (this.isInactive()) {
            this.title = this.title.m_6881_().m_130940_(ChatFormatting.GRAY);
        }
    }

    public int getHandleX() {
        return this.x + (int)(this.value * (double)(this.width - this.handleWidth));
    }

    public GuiSprite getHandleSprite() {
        if (this.isHoveredOrFocused() && this.isActive()) {
            return GameSprite.SLIDER_HANDLE_HIGHLIGHTED;
        }
        return GameSprite.SLIDER_HANDLE;
    }

    public float getHandleShaderColor() {
        return this.isActive() ? 1.0f : 0.6f;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean isValidButton;
        boolean bl = isValidButton = button == 0 || button == 2;
        if (this.isValidPoint(mouseX, mouseY) && isValidButton) {
            this.setFocused();
            if (button == 2) {
                return true;
            }
        }
        if (this.isInvalidClick(mouseX, mouseY, button)) {
            return false;
        }
        this.dragging = true;
        this.setFromMouse(mouseX);
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.dragging && this.isValidClick(mouseX, mouseY, button)) {
            this.dragging = false;
            if (((AbstractSliderMaker)this.builder).clickSoundOnRelease) {
                GuiUtil.playClick();
            }
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.dragging) {
            return false;
        }
        this.setFromMouse(mouseX);
        return true;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (this.isInvalidPoint(mouseX, mouseY)) {
            return false;
        }
        if (((AbstractSliderMaker)this.builder).interval != null && this.isActive()) {
            if (((AbstractSliderMaker)this.builder).scrollRequiresFocus && this.isUnfocused()) {
                return false;
            }
            if (!this.isHoveredOrFocused()) {
                return false;
            }
            double delta = 0.0;
            if (deltaY != 0.0) {
                delta = deltaY;
            }
            this.setValue(this.getValue() + delta * ((AbstractSliderMaker)this.builder).interval.get().doubleValue());
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isUnfocused() || this.isInactive()) {
            return false;
        }
        return switch (keyCode) {
            case 68 -> this.m_6050_(this.x, this.y, 1.0);
            case 65 -> this.m_6050_(this.x, this.y, -1.0);
            default -> false;
        };
    }

    private void renderText(GuiGraphics graphics) {
        Color color;
        int margin = 3;
        int startX = this.m_252754_() + margin;
        int endX = this.getEndX() - margin;
        int textX = this.x + this.width / 2;
        int textY = this.y + (this.height - 8) / 2;
        int textWidth = GuiUtil.font().m_92852_((FormattedText)this.title);
        int extraWidth = Math.abs(startX + textWidth - endX);
        boolean isScrolling = startX + GuiUtil.font().m_92852_((FormattedText)this.title) + margin > endX;
        Color color2 = color = this.active ? Color.WHITE : Color.QUICK_SILVER;
        if (((Boolean)CandyTweak.OLD_BUTTON_TEXT_COLOR.get()).booleanValue()) {
            color = this.isInactive() ? Color.QUICK_SILVER : (this.isHoveredOrFocused() ? Color.LEMON_YELLOW : Color.NOSTALGIC_GRAY);
        }
        if (this.scrollAnimator.isMoving()) {
            this.scrollTimer.reset();
        }
        if (isScrolling && this.scrollTimer.hasElapsed() && this.scrollAnimator.isFinished()) {
            this.scrollAnimator.setDuration(40L * (long)extraWidth, TimeUnit.MILLISECONDS);
            this.scrollAnimator.playOrRewind();
        }
        if (isScrolling) {
            float scrollX = (float)Mth.m_14139_((double)this.scrollAnimator.getValue(), (double)startX, (double)(startX - extraWidth));
            int scrollColor = color.get();
            RenderUtil.deferredRenderer(() -> {
                RenderUtil.pushScissor(startX, this.m_252907_(), endX, this.getEndY());
                RenderUtil.pauseBatching();
                DrawText.begin(graphics, this.title).pos(scrollX, (float)textY).color(scrollColor).draw();
                RenderUtil.popScissor();
                RenderUtil.resumeBatching();
            });
        } else {
            DrawText.begin(graphics, this.title).pos(textX, textY).color(color).center().draw();
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        if (((AbstractSliderMaker)this.builder).backgroundRenderer != null) {
            ((AbstractSliderMaker)this.builder).backgroundRenderer.accept((AbstractSlider)this.self(), graphics, mouseX, mouseY, partialTick);
        } else {
            WidgetBackground.SLIDER.render(this, graphics);
        }
        if (((AbstractSliderMaker)this.builder).handleRenderer != null) {
            ((AbstractSliderMaker)this.builder).handleRenderer.accept((AbstractSlider)this.self(), graphics, mouseX, mouseY, partialTick);
        } else {
            float color = this.getHandleShaderColor();
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            RenderUtil.blitSprite(this.getHandleSprite(), graphics, this.getHandleX(), this.y, 8, 20);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((AbstractSliderMaker)this.builder).effectsRenderer != null) {
            ((AbstractSliderMaker)this.builder).effectsRenderer.accept((AbstractSlider)this.self(), graphics, mouseX, mouseY, partialTick);
        }
        this.renderText(graphics);
    }
}

