/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.text;

import java.util.List;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Unmodifiable;

public interface MultiLineText {
    public static final MultiLineText EMPTY = new MultiLineText(){

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public @Unmodifiable List<Line> getLines() {
            return List.of();
        }
    };

    public @Unmodifiable List<Line> getLines();

    public int getCount();

    default public int maxWidth() {
        return this.getLines().stream().mapToInt(Line::getWidth).max().orElse(0);
    }

    public static MultiLineText create(FormattedText text, int maxWidth) {
        final List<Line> textList = GuiUtil.font().m_92923_(text, maxWidth).stream().map(Line::new).toList();
        if (textList.isEmpty()) {
            return EMPTY;
        }
        return new MultiLineText(){

            @Override
            public int getCount() {
                return textList.size();
            }

            @Override
            public @Unmodifiable List<Line> getLines() {
                return textList;
            }
        };
    }

    public static class Line {
        private final FormattedCharSequence text;
        private final int width;

        private Line(FormattedCharSequence text) {
            this.text = text;
            this.width = GuiUtil.font().m_92724_(text);
        }

        public FormattedCharSequence getText() {
            return this.text;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

