/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.text;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ScaleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.TooltipBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TextBuilder
extends DynamicBuilder<TextBuilder, TextWidget>
implements LayoutBuilder<TextBuilder, TextWidget>,
VisibleBuilder<TextBuilder, TextWidget>,
TooltipBuilder<TextBuilder, TextWidget>,
ScaleBuilder<TextBuilder, TextWidget> {
    Supplier<Component> text;
    boolean useTextWidth = false;
    boolean useSeparator = false;
    boolean disableUnderline = false;
    boolean isCenterVertical = false;
    boolean isCenterAligned = false;
    boolean useClickSound = true;
    boolean useEllipsis = false;
    int lineHeight = 0;
    int iconMargin = 0;
    LinkedHashSet<DynamicWidget<?, ?>> intersections = new LinkedHashSet();
    @Nullable
    IntSupplier maxEndX = null;
    @Nullable
    Color hoverColor = null;
    @Nullable
    Color backgroundColor = null;
    IntSupplier separatorHeight = () -> 2;
    Color separatorColor = Color.WHITE;
    Color clickableColor = Color.WHITE;
    Color fontColor = Color.WHITE;
    BooleanSupplier backgroundIf = BooleanSupplier.ALWAYS;
    BooleanSupplier highlightIf = BooleanSupplier.ALWAYS;
    BooleanSupplier italic = BooleanSupplier.NEVER;
    @Nullable
    Runnable onPress = null;
    @Nullable
    Animation highlighter = null;
    @Nullable
    BlankWidget pressArea = null;

    protected TextBuilder(Supplier<Component> supplier) {
        this.text = supplier;
        this.canFocus = () -> this.onPress != null;
    }

    protected TextBuilder(Component text) {
        this(() -> text);
    }

    @Override
    public TextBuilder self() {
        return this;
    }

    public TextBuilder useTextWidth() {
        this.useTextWidth = true;
        return this;
    }

    public TextBuilder useTextWidth(IntSupplier maxEndX) {
        this.maxEndX = maxEndX;
        return this.useTextWidth();
    }

    public TextBuilder useTextWidth(int maxEndX) {
        return this.useTextWidth(() -> maxEndX);
    }

    public TextBuilder lineHeight(int height) {
        this.lineHeight = height;
        return this;
    }

    public TextBuilder centerVertical() {
        this.isCenterVertical = true;
        this.isCenterAligned = true;
        return this;
    }

    public TextBuilder centerAligned() {
        this.isCenterAligned = true;
        return this;
    }

    public TextBuilder separator(Color color, IntSupplier height) {
        this.useSeparator = true;
        this.separatorColor = color;
        this.separatorHeight = height;
        return this;
    }

    public TextBuilder separator(Color color, int height) {
        return this.separator(color, () -> height);
    }

    public TextBuilder separator(int color, int height) {
        return this.separator(new Color(color), height);
    }

    public TextBuilder separator(Color color) {
        return this.separator(color, () -> 2);
    }

    public TextBuilder separator(int height) {
        return this.separator(this.fontColor, height);
    }

    public TextBuilder separator() {
        return this.separator(this.fontColor, () -> 2);
    }

    public TextBuilder shorten() {
        this.useEllipsis = true;
        return this;
    }

    public TextBuilder ellipsis() {
        return this.shorten();
    }

    public TextBuilder color(Color color) {
        this.fontColor = color;
        return this;
    }

    public TextBuilder color(IntSupplier color) {
        return this.color(new Color(color));
    }

    public TextBuilder color(int color) {
        return this.color(new Color(color));
    }

    public TextBuilder color(ChatFormatting formatting) {
        return this.color(Optional.ofNullable(formatting.m_126665_()).orElse(Color.WHITE.get()));
    }

    public TextBuilder background(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public TextBuilder background(int color) {
        return this.background(new Color(color));
    }

    public TextBuilder background(ChatFormatting formatting) {
        return this.color(Optional.ofNullable(formatting.m_126665_()).orElse(Color.WHITE.get()));
    }

    public TextBuilder backgroundWhen(BooleanSupplier when) {
        this.backgroundIf = when;
        return this;
    }

    public TextBuilder italicsWhen(BooleanSupplier italics) {
        this.italic = italics;
        return this;
    }

    public TextBuilder disableUnderline() {
        this.disableUnderline = true;
        return this;
    }

    public TextBuilder onPress(Runnable onPress, Color clickableColor) {
        this.onPress = onPress;
        this.clickableColor = clickableColor;
        return this;
    }

    public TextBuilder onPress(Runnable onPress, int clickableColor) {
        return this.onPress(onPress, new Color(clickableColor));
    }

    public TextBuilder onPress(Runnable onPress) {
        return this.onPress(onPress, this.fontColor);
    }

    public TextBuilder pressArea(BlankWidget pressArea) {
        this.pressArea = pressArea;
        return this;
    }

    public TextBuilder intersection(DynamicWidget<?, ?> ... widgets) {
        this.intersections.addAll(Arrays.asList(widgets));
        return this;
    }

    public TextBuilder noClickSound() {
        this.useClickSound = false;
        return this;
    }

    public TextBuilder highlighter(Animation animation) {
        this.highlighter = animation;
        return this;
    }

    public TextBuilder highlightIf(BooleanSupplier highlightIf) {
        this.highlightIf = highlightIf;
        return this;
    }

    public TextBuilder hoverOrFocusColor(Color color) {
        this.hoverColor = color;
        return this;
    }

    public TextBuilder icon(Supplier<TextureIcon> supplier, int margin) {
        int size;
        this.iconWidth = size = GuiUtil.textHeight() - 1;
        this.iconHeight = size;
        this.iconSupplier = supplier;
        this.iconMargin = margin;
        return this;
    }

    public TextBuilder icon(Supplier<TextureIcon> supplier) {
        return this.icon(supplier, 3);
    }

    public TextBuilder icon(TextureIcon icon, int margin) {
        return this.icon(() -> icon, margin);
    }

    public TextBuilder icon(TextureIcon icon) {
        return this.icon(() -> icon, 3);
    }

    public TextBuilder brightenIconOnHover(float amount) {
        this.brightenOnHover = true;
        this.brightenAmount = () -> amount;
        return this;
    }

    public TextBuilder brightenIconOnHover() {
        this.brightenOnHover = true;
        return this;
    }

    protected boolean isHeightOverridden() {
        return this.height != null;
    }

    @Override
    protected TextWidget construct() {
        if (this.lineHeight == 0) {
            this.lineHeight = GuiUtil.textHeight();
        }
        return new TextWidget(this);
    }
}

