/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.text;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicPriority;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.text.MultiLineText;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;

public class TextWidget
extends DynamicWidget<TextBuilder, TextWidget> {
    private final LinkedHashSet<ChatFormatting> formatting = new LinkedHashSet();
    private final IconManager<TextWidget> iconManager = new IconManager<TextWidget>(this);
    private MultiLineText text;

    public static TextBuilder create(Supplier<Component> supplier) {
        return new TextBuilder(supplier);
    }

    public static TextBuilder create(Component text) {
        return new TextBuilder(text);
    }

    public static TextBuilder create(Translation langKey) {
        return TextWidget.create((Component)langKey.get(new Object[0]));
    }

    public static TextBuilder create(String text) {
        return TextWidget.create((Component)Component.m_237113_((String)text));
    }

    protected TextWidget(final TextBuilder builder) {
        super(builder);
        class SyncText
        implements DynamicFunction<TextBuilder, TextWidget> {
            private final CacheValue<Component> textSupplier;
            private final CacheValue<Integer> maxEndX;

            SyncText() {
                this.textSupplier = CacheValue.create(builder.text);
                this.maxEndX = CacheValue.nullable(builder.maxEndX, IntSupplier::getAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(TextWidget text, TextBuilder builder2) {
                text.createMultiLine();
                this.textSupplier.update();
                this.maxEndX.update();
            }

            @Override
            public boolean isReapplyNeeded(TextWidget text, TextBuilder builder2, WidgetCache cache) {
                return cache.isScaleExpired() || CacheValue.isAnyExpired(cache.width, this.textSupplier, this.maxEndX);
            }

            @Override
            public List<DynamicField> getManaging(TextBuilder builder2) {
                if (builder2.useTextWidth) {
                    return List.of(DynamicField.WIDTH);
                }
                return List.of();
            }

            @Override
            public DynamicPriority priority() {
                return DynamicPriority.HIGH;
            }
        }
        ((TextBuilder)this.getBuilder()).addFunction(new SyncText());
        this.createMultiLine();
    }

    private void createMultiLine() {
        int scaledIcon = Math.round((float)this.getIconWidth() * this.getSquareScale());
        Component component = ((TextBuilder)this.getBuilder()).text.get();
        if (((TextBuilder)this.getBuilder()).useEllipsis) {
            component = TextUtil.ellipsis(this::getTextWidth, component, this.width - scaledIcon);
        }
        Component cleaned = component.getString().contains("\u00a7") ? this.getCleanText(component) : component;
        MutableComponent format = cleaned.m_6881_().m_130944_((ChatFormatting[])this.formatting.toArray(ChatFormatting[]::new));
        if (((TextBuilder)this.getBuilder()).useTextWidth) {
            int maxEndX;
            int maxLineWidth = format.getString().lines().mapToInt(this::getTextWidth).max().orElse(0);
            int maxIconWidth = this.getIconWidth();
            int maxWidth = maxLineWidth + maxIconWidth;
            if (((TextBuilder)this.getBuilder()).maxEndX != null && (maxEndX = ((TextBuilder)this.getBuilder()).maxEndX.getAsInt()) < this.m_252754_() + maxWidth) {
                maxWidth = Math.abs(maxEndX - this.m_252754_());
            }
            this.setWidth(maxWidth);
        }
        this.setAndUpdate(MultiLineText.create((FormattedText)format, Math.round((float)this.width / this.getSquareScale()) - this.getIconWidth()));
    }

    public int getTextWidth(String text) {
        return Math.round((float)GuiUtil.font().m_92895_(text) * this.getSquareScale());
    }

    private Component getCleanText(Component text) {
        return Component.m_237113_((String)text.getString().replaceAll("\u00a7r", "\u00a7r\u00a7f"));
    }

    private int getIconWidth() {
        if (this.iconManager.isEmpty()) {
            return 0;
        }
        return Math.round((float)(this.iconManager.getWidth() + ((TextBuilder)this.getBuilder()).iconMargin) * this.getSquareScale());
    }

    private void setAndUpdate(MultiLineText text) {
        this.text = text;
        int height = Math.round((float)(this.text.getCount() * ((TextBuilder)this.getBuilder()).lineHeight) * this.getSquareScale());
        if (((TextBuilder)this.getBuilder()).isHeightOverridden() && height < this.height) {
            return;
        }
        this.setHeight(height);
    }

    public boolean isUnderlined() {
        if (((TextBuilder)this.getBuilder()).disableUnderline) {
            return false;
        }
        return this.isHoveredOrFocused() && ((TextBuilder)this.getBuilder()).onPress != null;
    }

    public boolean isItalic() {
        return ((TextBuilder)this.getBuilder()).italic.getAsBoolean();
    }

    private Color getTextColor(boolean isHighlightPass) {
        if (((TextBuilder)this.getBuilder()).highlighter == null) {
            if (((TextBuilder)this.getBuilder()).hoverColor != null && this.isHoveredOrFocused()) {
                return ((TextBuilder)this.getBuilder()).hoverColor;
            }
            if (((TextBuilder)this.getBuilder()).onPress != null && this.isHoveredOrFocused()) {
                return ((TextBuilder)this.getBuilder()).clickableColor;
            }
            return ((TextBuilder)this.getBuilder()).fontColor;
        }
        if (isHighlightPass) {
            Animation animation = ((TextBuilder)this.getBuilder()).highlighter;
            if (this.isHoveredOrFocused()) {
                animation.play();
            } else {
                animation.rewind();
            }
            double override = this.m_93696_() ? 1.0 : 0.0;
            double value = ((TextBuilder)this.getBuilder()).highlightIf.getAsBoolean() ? animation.getValue() : override;
            double alpha = Mth.m_14036_((float)((float)value), (float)0.0f, (float)1.0f);
            if (alpha > 0.01568627450980392) {
                return ((TextBuilder)this.getBuilder()).clickableColor.fromAlpha(alpha);
            }
        }
        return ((TextBuilder)this.getBuilder()).fontColor;
    }

    private float getCenteredLine(MultiLineText.Line line, int index) {
        if (((TextBuilder)this.getBuilder()).isCenterVertical) {
            if (this.iconManager.isPresent()) {
                return Math.round((float)this.getIconWidth() / this.getSquareScale());
            }
            return 0.0f;
        }
        int lineWidth = line.getWidth();
        if (index == 0 && this.iconManager.isPresent()) {
            lineWidth -= Math.round((float)this.getIconWidth() / this.getSquareScale());
        }
        return (float)this.m_5711_() / this.getSquareScale() / 2.0f - (float)lineWidth / 2.0f;
    }

    private void addFormatting(ChatFormatting ... formatting) {
        this.formatting.addAll(List.of(formatting));
        this.createMultiLine();
    }

    private void clearFormatting() {
        this.formatting.clear();
        this.createMultiLine();
    }

    public String getString(boolean multiline) {
        StringBuilder builder = new StringBuilder();
        FormattedCharSink sink = (index, style, codePoint) -> {
            builder.append(Character.toString(codePoint));
            return true;
        };
        for (MultiLineText.Line line : this.text.getLines()) {
            if (multiline && !builder.isEmpty()) {
                builder.append("\n");
            }
            line.getText().m_13731_(sink);
        }
        return builder.toString();
    }

    public String getMultilineString() {
        return this.getString(true);
    }

    public String getRawString() {
        return this.getString(false);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeyboardUtil.isEnterLike(keyCode) && this.m_93696_() && ((TextBuilder)this.getBuilder()).onPress != null) {
            if (((TextBuilder)this.getBuilder()).useClickSound) {
                GuiUtil.playClick();
            }
            ((TextBuilder)this.getBuilder()).onPress.run();
            return true;
        }
        return false;
    }

    protected boolean isMouseInPressArea() {
        if (((TextBuilder)this.getBuilder()).pressArea == null) {
            return false;
        }
        int aX = ((TextBuilder)this.getBuilder()).pressArea.m_252754_();
        int aY = ((TextBuilder)this.getBuilder()).pressArea.m_252907_();
        int aW = ((TextBuilder)this.getBuilder()).pressArea.m_5711_();
        int aH = ((TextBuilder)this.getBuilder()).pressArea.m_93694_();
        return MathUtil.isWithinBox(this.getMouseX(), this.getMouseY(), aX, aY, aW, aH);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.isMouseInPressArea() || super.m_5953_(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((TextBuilder)this.getBuilder()).onPress == null || this.isInvalidClick(mouseX, mouseY, button)) {
            return false;
        }
        if (((TextBuilder)this.getBuilder()).intersections.stream().anyMatch(widget -> widget.m_6375_(mouseX, mouseY, button))) {
            return false;
        }
        boolean isAreaClicked = this.isMouseInPressArea();
        boolean isTextClicked = this.isValidClick(mouseX, mouseY, button);
        if (isAreaClicked || isTextClicked) {
            if (((TextBuilder)this.getBuilder()).useClickSound) {
                GuiUtil.playClick();
            }
            ((TextBuilder)this.getBuilder()).onPress.run();
            return true;
        }
        return false;
    }

    @Override
    public boolean isHoveredOrFocused() {
        boolean isOverIntersection;
        if (CollectionUtil.isNotEmpty(((TextBuilder)this.getBuilder()).intersections) && (isOverIntersection = ((TextBuilder)this.getBuilder()).intersections.stream().anyMatch(widget -> widget.m_5953_(this.getMouseX(), this.getMouseY())))) {
            return false;
        }
        return super.isHoveredOrFocused();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        RenderUtil.beginBatching();
        if (((TextBuilder)this.getBuilder()).backgroundColor != null && ((TextBuilder)this.getBuilder()).backgroundIf.getAsBoolean()) {
            RenderUtil.fill(graphics, (float)this.m_252754_(), (float)this.m_252907_(), (float)this.getEndX(), (float)this.getEndY(), ((TextBuilder)this.getBuilder()).backgroundColor);
        }
        this.renderText(graphics, mouseX, mouseY, partialTick, false);
        if (((TextBuilder)this.getBuilder()).highlighter != null) {
            this.renderText(graphics, mouseX, mouseY, partialTick, true);
        }
        RenderUtil.endBatching();
        this.renderDebug(graphics);
    }

    private void renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, boolean isHighlightPass) {
        if (this.isUnderlined()) {
            this.addFormatting(ChatFormatting.UNDERLINE);
        }
        if (this.isItalic()) {
            this.addFormatting(ChatFormatting.ITALIC);
        }
        this.iconManager.pushCache();
        if (((TextBuilder)this.getBuilder()).isCenterAligned) {
            int scaleHeight = Math.round((float)GuiUtil.textHeight() * this.getSquareScale());
            float centerY = MathUtil.center(this.m_252907_(), this.text.getCount() * scaleHeight, this.m_93694_());
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.m_252754_(), centerY, 0.0f);
            graphics.m_280168_().m_85841_(this.getSquareScale(), this.getSquareScale(), 1.0f);
            CollectionUtil.forLoop(this.text.getLines(), (line, index) -> DrawText.begin(graphics, line.getText()).pos(this.getCenteredLine((MultiLineText.Line)line, (int)index), (float)(index * ((TextBuilder)this.getBuilder()).lineHeight)).color(this.getTextColor(isHighlightPass)).draw());
            if (!this.text.getLines().isEmpty()) {
                int firstLineX = (int)this.getCenteredLine(this.text.getLines().get(0), 0);
                this.iconManager.pos(firstLineX - Math.round((float)this.getIconWidth() / this.getSquareScale()), 0);
                this.iconManager.render(graphics, mouseX, mouseY, partialTick);
            }
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
            graphics.m_280168_().m_85841_(this.getSquareScale(), this.getSquareScale(), 1.0f);
            this.iconManager.pos(0, 0);
            this.iconManager.render(graphics, mouseX, mouseY, partialTick);
            graphics.m_280168_().m_85849_();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(this.m_252754_() + this.getIconWidth()), (float)this.m_252907_(), 0.0f);
            graphics.m_280168_().m_85841_(this.getSquareScale(), this.getSquareScale(), 1.0f);
            CollectionUtil.forLoop(this.text.getLines(), (line, index) -> DrawText.begin(graphics, line.getText()).posY(index * ((TextBuilder)this.getBuilder()).lineHeight).color(this.getTextColor(isHighlightPass)).draw());
            graphics.m_280168_().m_85849_();
        }
        if (((TextBuilder)this.getBuilder()).useSeparator) {
            Color color = ((TextBuilder)this.getBuilder()).separatorColor;
            int barHeight = ((TextBuilder)this.getBuilder()).separatorHeight.getAsInt();
            int textWidth = Math.round((float)(this.iconManager.getWidth() + this.text.maxWidth()) * this.getSquareScale());
            float centerY = MathUtil.center(this.m_252907_(), barHeight, this.m_93694_());
            float padding = 4.0f * this.getSquareScale();
            if (((TextBuilder)this.getBuilder()).isCenterAligned) {
                int barWidth = Math.abs(this.m_5711_() - textWidth) / 2;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)this.m_252754_(), centerY, 0.0f);
                RenderUtil.fill(graphics, 0.0f, 0.0f, (float)barWidth - padding, (float)barHeight, color);
                graphics.m_280168_().m_252880_((float)(barWidth + textWidth) + padding, 0.0f, 0.0f);
                RenderUtil.fill(graphics, 0.0f, 0.0f, (float)barWidth - padding, (float)barHeight, color);
                graphics.m_280168_().m_85849_();
            } else {
                RenderUtil.fill(graphics, (float)(this.m_252754_() + textWidth) + padding, centerY, (float)this.getEndX(), centerY + (float)barHeight, color);
            }
        }
        if (CollectionUtil.isNotEmpty(this.formatting)) {
            this.clearFormatting();
        }
        this.iconManager.popCache();
    }
}

