/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.cache;

import java.util.function.Supplier;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.util.common.data.Holder;

public class CacheHolder<T> {
    private final Holder<T> local;
    private final Holder<T> network;
    private final Supplier<CacheMode> mode;

    private CacheHolder(T local, T network, Supplier<CacheMode> mode) {
        this.local = Holder.create(local);
        this.network = Holder.create(network);
        this.mode = mode;
    }

    public static <V> CacheHolder<V> from(V value, Supplier<CacheMode> supplier) {
        return new CacheHolder<V>(value, value, supplier);
    }

    public static <V> CacheHolder<V> with(V local, V network, Supplier<CacheMode> supplier) {
        return new CacheHolder<V>(local, network, supplier);
    }

    public T get() {
        return this.isLocalMode() ? this.getLocal() : this.getNetwork();
    }

    public void set(T value) {
        if (this.isNetworkMode()) {
            this.setNetwork(value);
        } else {
            this.setLocal(value);
        }
    }

    public boolean isLocalMode() {
        return this.mode.get() == CacheMode.LOCAL;
    }

    public boolean isNetworkMode() {
        return this.mode.get() == CacheMode.NETWORK;
    }

    public Holder<T> local() {
        return this.local;
    }

    public T getLocal() {
        return this.local().get();
    }

    public void setLocal(T value) {
        this.local().set(value);
    }

    public void setLocal(Number number) {
        if (this.local.get().getClass().isAssignableFrom(number.getClass())) {
            this.local.set(number);
        }
    }

    public Holder<T> network() {
        return this.network;
    }

    public T getNetwork() {
        return this.network.get();
    }

    public void setNetwork(T value) {
        this.network().set(value);
    }

    public void setNetwork(Number number) {
        if (this.network.get().getClass().isAssignableFrom(number.getClass())) {
            this.network.set(number);
        }
    }
}

