/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.factory;

import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.factory.Config;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.config.factory.ConfigPermissions;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.io.PathUtil;

public abstract class ConfigBuilder {
    private static ConfigHandler<?> instance = null;

    public static <T extends ConfigMeta> ConfigHandler<T> temp(Class<T> config, Path path) {
        return new ConfigHandler<T>(config, path, ConfigPermissions.READ_ONLY, () -> {}, () -> {});
    }

    public static <T extends ConfigMeta> ConfigHandler<T> temp(Class<T> config, Path path, Runnable onLoad) {
        return new ConfigHandler<T>(config, path, ConfigPermissions.READ_ONLY, onLoad, () -> {});
    }

    public static <T extends ConfigMeta> void create(Class<T> config, Runnable onLoad) {
        ConfigBuilder.create(config, onLoad, () -> {});
    }

    public static <T extends ConfigMeta> void create(Class<T> config, Runnable onLoad, Runnable onSave) {
        String name = config.getSimpleName();
        if (instance != null) {
            throw new RuntimeException(String.format("[Config Factory] %s is already built", name));
        }
        Config structure = config.getAnnotation(Config.class);
        if (structure == null) {
            throw new RuntimeException(String.format("[Config Factory] No @Config annotation is attached to %s", name));
        }
        Path path = PathUtil.getConfigPath().resolve(structure.filename() + ".json");
        instance = new ConfigHandler<T>(config, path, ConfigPermissions.READ_WRITE, onLoad, onSave);
        instance.init();
        NostalgicTweaks.LOGGER.info(String.format("[Config Factory] Successfully built %s", name));
    }

    public static <T extends ConfigMeta> ConfigHandler<T> getHandler() {
        if (instance == null) {
            throw new RuntimeException("[Config Factory] A config has not yet been built");
        }
        return instance;
    }

    public static <T extends ConfigMeta> T getConfig(Class<T> config) {
        if (instance == null) {
            throw new RuntimeException("[Config Factory] A config has not yet been built");
        }
        if (ClassUtil.isNotInstanceOf(instance.getLoaded(), config)) {
            throw new RuntimeException("[Config Factory] Loaded config is not an instance of the given class type");
        }
        return (T)instance.getLoaded();
    }
}

