/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.forge.event;

import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.forge.mixin.tweak.candy.debug_screen.ForgeGuiAccess;
import mod.adrenix.nostalgic.helper.candy.level.fog.OverworldFogRenderer;
import mod.adrenix.nostalgic.helper.candy.level.fog.VoidFogRenderer;
import mod.adrenix.nostalgic.helper.candy.level.fog.WaterFogRenderer;
import mod.adrenix.nostalgic.helper.gameplay.InteractionHelper;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nostalgic_tweaks", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public abstract class ClientEventHandler {
    private static final FlagHolder ARMOR_LEVEL_PUSHED = FlagHolder.off();
    private static final FlagHolder AIR_LEVEL_PUSHED = FlagHolder.off();
    private static final FlagHolder FOOD_DISABLED = FlagHolder.off();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void setupHighestGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        NamedGuiOverlay overlay = event.getOverlay();
        GuiGraphics graphics = event.getGuiGraphics();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ForgeGui forgeGui = (ForgeGui)Minecraft.m_91087_().f_91065_;
        boolean isForgeDebugOff = CandyTweak.OLD_DEBUG.get() != Generic.MODERN;
        boolean isExperienceOff = (Boolean)CandyTweak.HIDE_EXPERIENCE_BAR.get();
        boolean isFoodOff = (Boolean)CandyTweak.HIDE_HUNGER_BAR.get();
        boolean isMounted = NullableResult.getOrElse(player, false, local -> local.m_245714_() != null);
        if (overlay.id() == VanillaGuiOverlay.HOTBAR.id() && isExperienceOff) {
            forgeGui.leftHeight -= 7;
            forgeGui.rightHeight -= 7;
            if (isMounted) {
                forgeGui.leftHeight += 7;
                forgeGui.rightHeight += 7;
            }
        }
        if (overlay.id() == VanillaGuiOverlay.DEBUG_TEXT.id() && isForgeDebugOff) {
            if (Minecraft.m_91087_().f_91066_.f_92063_) {
                ((ForgeGuiAccess)forgeGui).nt$getDebugScreen().m_94056_(graphics);
            }
            event.setCanceled(true);
        }
        if (overlay.id() == VanillaGuiOverlay.FPS_GRAPH.id() && isForgeDebugOff) {
            event.setCanceled(true);
        }
        if (overlay.id() == VanillaGuiOverlay.EXPERIENCE_BAR.id() && isExperienceOff) {
            event.setCanceled(true);
        }
        if (overlay.id() == VanillaGuiOverlay.FOOD_LEVEL.id() && isFoodOff) {
            event.setCanceled(true);
        }
        if (overlay.id() == VanillaGuiOverlay.ARMOR_LEVEL.id() && isFoodOff) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(GuiUtil.getGuiWidth() / 2 + 90), 0.0f, 0.0f);
            ARMOR_LEVEL_PUSHED.enable();
            FOOD_DISABLED.enable();
        }
        if (overlay.id() == VanillaGuiOverlay.AIR_LEVEL.id() && isFoodOff) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(GuiUtil.getGuiWidth() / 2 - 100), 0.0f, 0.0f);
            AIR_LEVEL_PUSHED.enable();
        }
        if (overlay.id() == VanillaGuiOverlay.FOOD_LEVEL.id() && event.isCanceled()) {
            FOOD_DISABLED.enable();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void setupGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        boolean useFood;
        ForgeGui forgeGui = (ForgeGui)Minecraft.m_91087_().f_91065_;
        GuiGraphics graphics = event.getGuiGraphics();
        if (ARMOR_LEVEL_PUSHED.ifEnabledThenDisable()) {
            graphics.m_280168_().m_85849_();
        }
        if (AIR_LEVEL_PUSHED.ifEnabledThenDisable()) {
            graphics.m_280168_().m_85849_();
        }
        boolean useArmor = event.getOverlay().id() == VanillaGuiOverlay.ARMOR_LEVEL.id() && (Boolean)FOOD_DISABLED.get() != false;
        boolean bl = useFood = event.getOverlay().id() == VanillaGuiOverlay.FOOD_LEVEL.id() && (Boolean)FOOD_DISABLED.get() == false;
        if (useArmor || useFood) {
            if (useArmor && NullableResult.getOrElse(Minecraft.m_91087_().f_91074_, 0, LivingEntity::m_21230_) == 0) {
                forgeGui.rightHeight -= 10;
            }
            StaminaRenderer.render(graphics, forgeGui.rightHeight);
            if (StaminaRenderer.isVisible()) {
                forgeGui.rightHeight += 10;
            }
        }
        FOOD_DISABLED.disable();
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        if (OverworldFogRenderer.setupFog(event.getCamera(), event.getMode(), () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setFogShape(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (WaterFogRenderer.setupFog(event.getCamera(), arg_0 -> ((ViewportEvent.RenderFog)event).setFogShape(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (VoidFogRenderer.setupFog(event.getCamera(), event.getMode(), () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void computeFogColor(ViewportEvent.ComputeFogColor event) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        if (WaterFogRenderer.setupColor(event.getCamera(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0))) {
            return;
        }
        OverworldFogRenderer.setupColor(event.getCamera(), () -> ((ViewportEvent.ComputeFogColor)event).getRed(), () -> ((ViewportEvent.ComputeFogColor)event).getGreen(), () -> ((ViewportEvent.ComputeFogColor)event).getBlue(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0));
        VoidFogRenderer.setupColor(event.getCamera(), () -> ((ViewportEvent.ComputeFogColor)event).getRed(), () -> ((ViewportEvent.ComputeFogColor)event).getGreen(), () -> ((ViewportEvent.ComputeFogColor)event).getBlue(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0));
    }

    @SubscribeEvent
    public static void onUseItem(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (player == null || hitResult == null || !event.isUseItem()) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockState blockState;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Item itemInHand = player.m_21120_(event.getHand()).m_41720_();
            if (InteractionHelper.shouldNotUseItem(itemInHand, blockState = player.m_9236_().m_8055_(blockHitResult.m_82425_()))) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }

    @SubscribeEvent
    public static void keyPressed(ScreenEvent.KeyPressed.Post event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        int modifiers = event.getModifiers();
        Screen screen = event.getScreen();
        if (screen instanceof DynamicScreen) {
            DynamicScreen dynamic = (DynamicScreen)screen;
            event.setCanceled(dynamic.isKeyPressed(keyCode, scanCode, modifiers));
        }
    }

    @SubscribeEvent
    public static void mouseClicked(ScreenEvent.MouseButtonPressed.Post event) {
        int button;
        double mouseY;
        double mouseX;
        DynamicScreen dynamic;
        Screen screen;
        if (!event.wasHandled() && (screen = event.getScreen()) instanceof DynamicScreen && (dynamic = (DynamicScreen)screen).isMouseClicked(mouseX = event.getMouseX(), mouseY = event.getMouseY(), button = event.getButton())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void mouseReleased(ScreenEvent.MouseButtonReleased.Post event) {
        int button;
        double mouseY;
        double mouseX;
        DynamicScreen dynamic;
        Screen screen;
        if (!event.wasHandled() && (screen = event.getScreen()) instanceof DynamicScreen && (dynamic = (DynamicScreen)screen).isMouseReleased(mouseX = event.getMouseX(), mouseY = event.getMouseY(), button = event.getButton())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void mouseDragged(ScreenEvent.MouseDragged.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof DynamicScreen) {
            DynamicScreen dynamic = (DynamicScreen)screen;
            double mouseX = event.getMouseX();
            double mouseY = event.getMouseY();
            double dragX = event.getDragX();
            double dragY = event.getDragY();
            int button = event.getMouseButton();
            dynamic.isMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
    }
}

