/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.forge.mixin.embeddium.candy.world_lighting;

import it.unimi.dsi.fastutil.longs.LongCollection;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTracker;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import mod.adrenix.nostalgic.forge.mixin.util.FlywheelForgeHelper;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.data.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumWorldRenderer.class})
public abstract class SodiumWorldRendererMixin {
    @Shadow
    private ClientLevel world;
    @Shadow
    private RenderSectionManager renderSectionManager;

    @Inject(remap=false, method={"setupTerrain"}, at={@At(value="HEAD")})
    private void nt_embeddium_world_lighting$onSetupTerrain(Camera camera, Viewport viewport, int frame, boolean spectator, boolean updateChunksImmediately, CallbackInfo callback) {
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue() && LightingHelper.isRelightCheckEnqueued()) {
            ChunkTracker.forEachChunk((LongCollection)ChunkTrackerHolder.get((ClientLevel)this.world).getReadyChunks(), (x, z) -> {
                for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
                    this.renderSectionManager.scheduleRebuild(x, y, z, false);
                }
            });
        }
        if (((Boolean)LightingHelper.RELIGHT_ALL_CHUNKS.get()).booleanValue()) {
            ChunkTrackerHolder.get((ClientLevel)this.world).getReadyChunks().forEach(packedPos -> {
                Pair<Long, Byte> packedRelight = new Pair<Long, Byte>(packedPos, (byte)1);
                LightingHelper.PACKED_RELIGHT_QUEUE.add(packedRelight);
            });
            LightingHelper.RELIGHT_ALL_CHUNKS.disable();
        }
        if (ModTracker.FLYWHEEL.isInstalled()) {
            FlywheelForgeHelper.sendLightUpdate(this.world);
        }
    }

    @Inject(remap=false, method={"setupTerrain"}, at={@At(value="RETURN")})
    private void nt_embeddium_world_lighting$onFinishSetupTerrain(Camera camera, Viewport viewport, int frame, boolean spectator, boolean updateChunksImmediately, CallbackInfo callback) {
        if (LightingHelper.isRelightCheckEnqueued()) {
            LightingHelper.setRelightingAsFinished();
        }
    }
}

