/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleHelper {
    public static void destroy(Consumer<Particle> add, ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        int posX = blockPos.m_123341_();
        int posY = blockPos.m_123342_();
        int posZ = blockPos.m_123343_();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    double dx = (double)posX + ((double)x + 0.5) / 4.0;
                    double dy = (double)posY + ((double)y + 0.5) / 4.0;
                    double dz = (double)posZ + ((double)z + 0.5) / 4.0;
                    double speedX = dx - (double)posX - 0.5;
                    double speedY = dy - (double)posY - 0.5;
                    double speedZ = dz - (double)posZ - 0.5;
                    add.accept((Particle)new TerrainParticle(clientLevel, dx, dy, dz, speedX, speedY, speedZ, blockState, blockPos));
                }
            }
        }
    }

    @Nullable
    public static Particle getParticle(Particle particle, ParticleType<?> type, double x, double y, double z) {
        if (((Boolean)CandyTweak.OLD_SWEEP_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123766_) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_DAMAGE_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123798_) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_CRIT_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123797_) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_MAGIC_HIT_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123808_) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_UNDERWATER_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123768_) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_WATER_DRIP_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123803_) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_LAVA_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123756_) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_LAVA_DRIP_PARTICLES.get()).booleanValue() && type == ParticleTypes.f_123800_) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_NETHER_PARTICLES.get()).booleanValue() && GameUtil.isInNether() && ParticleHelper.typeEqualTo(type, new ParticleType[]{ParticleTypes.f_123783_, ParticleTypes.f_123790_, ParticleTypes.f_123785_, ParticleTypes.f_123784_})) {
            return null;
        }
        if (ParticleHelper.getPlayerParticle(particle, type, x, y, z) == null) {
            return null;
        }
        ResourceLocation key = BuiltInRegistries.f_257034_.m_7981_(type);
        if (key != null && ((StringSet)CandyTweak.DISABLED_PARTICLES.get()).contains(key.toString())) {
            return null;
        }
        return particle;
    }

    @Nullable
    private static Particle getPlayerParticle(Particle particle, ParticleType<?> type, double x, double y, double z) {
        boolean isEffectParticle = ParticleHelper.typeEqualTo(type, new ParticleType[]{ParticleTypes.f_123770_, ParticleTypes.f_123811_});
        if (!(((Boolean)CandyTweak.HIDE_FIRST_PERSON_MAGIC_PARTICLES.get()).booleanValue() && CameraUtil.isFirstPerson() && isEffectParticle)) {
            return particle;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            double playerX = player.m_20185_();
            double playerY = player.m_20186_();
            double playerZ = player.m_20189_();
            boolean isNearX = MathUtil.tolerance(x, playerX, 2.0);
            boolean isNearY = MathUtil.tolerance(y, playerY, 2.0);
            boolean isNearZ = MathUtil.tolerance(z, playerZ, 2.0);
            if (isNearX && isNearY && isNearZ) {
                return null;
            }
        }
        return particle;
    }

    private static boolean typeEqualTo(ParticleType<?> check, ParticleType<?> ... types) {
        for (ParticleType<?> type : types) {
            if (type != check) continue;
            return true;
        }
        return false;
    }
}

