/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.SupporterOverlay;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.CycleIndex;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public abstract class SupporterRenderer {
    private static final RenderType AUTHOR_VISIBLE_SHADER = RenderType.m_173215_((String)"nt_author_shader", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173086_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard((ResourceLocation)TextureLocation.NT_LOGO_64, false, false)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
    private static final RenderType AUTHOR_SEE_THROUGH_SHADER = RenderType.m_173215_((String)"nt_author_see_through_shader", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173088_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard((ResourceLocation)TextureLocation.NT_LOGO_64, false, false)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110663_(RenderStateShard.f_110111_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    private static final RenderType SUPPORTER_VISIBLE_SHADER = RenderType.m_173215_((String)"nt_supporter_shader", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173086_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard((ResourceLocation)TextureLocation.NT_SUPPORTER_64, false, false)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
    private static final RenderType SUPPORTER_SEE_THROUGH_SHADER = RenderType.m_173215_((String)"nt_supporter_see_through_shader", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173088_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard((ResourceLocation)TextureLocation.NT_SUPPORTER_64, false, false)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110663_(RenderStateShard.f_110111_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    private static final Animation ADRENIX_COLOR = Animate.linear(2L, TimeUnit.SECONDS);
    private static final Animation RAINBOW_COLOR = Animate.linear(2L, TimeUnit.SECONDS);
    private static final Animation CAPTAIN_MOVER = Animate.linear(100L, TimeUnit.MILLISECONDS);
    private static final CycleIndex CAPTAIN_CYCLE = new CycleIndex("Captain_3".split(""), true);

    public static boolean isSupporter(Component displayName) {
        if (!((Boolean)CandyTweak.SUPPORTER_TAGS.get()).booleanValue()) {
            return false;
        }
        for (String name : SupporterOverlay.getNameKeys()) {
            if (!name.equals(displayName.getString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotSupporter(Component displayName) {
        return !SupporterRenderer.isSupporter(displayName);
    }

    private static void drawText(IntegerHolder endX, String text, float x, float y, Matrix4f matrix, MultiBufferSource bufferSource, int textColor, int backgroundColor, int packedLight) {
        Font font = GuiUtil.font();
        font.m_271703_(text, x, y, textColor, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundColor, packedLight);
        int lastX = font.m_271703_(text, x, y, textColor, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        endX.set(lastX);
    }

    private static void drawBadge(Badge badge, MultiBufferSource bufferSource, PoseStack poseStack, int packedLight, int endX) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)endX + 3.0f, -2.5f, 0.0f);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer seeThrough = bufferSource.m_6299_(badge.getSeeThroughShader());
        seeThrough.m_252986_(matrix, 0.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        seeThrough.m_252986_(matrix, 64.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        seeThrough.m_252986_(matrix, 64.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        seeThrough.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        VertexConsumer visible = bufferSource.m_6299_(badge.getVisibleShader());
        visible.m_252986_(matrix, 0.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        visible.m_252986_(matrix, 64.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        visible.m_252986_(matrix, 64.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        visible.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        poseStack.m_85849_();
    }

    public static int render(Component displayName, float x, float y, PoseStack poseStack, MultiBufferSource bufferSource, int backgroundColor, int packedLight) {
        String name = displayName.getString();
        Matrix4f fontMatrix = poseStack.m_85850_().m_252922_();
        IntegerHolder endX = IntegerHolder.create((int)x);
        int transparent = Color.TRANSPARENT.get();
        int translucent = Color.BLACK.fromAlpha(0.016f).get();
        switch (name) {
            case "Adrenix": {
                ADRENIX_COLOR.playOrRewind();
                int color = Color.HSBtoRGB(360.0f, 1.0f, Mth.m_14179_((float)((float)ADRENIX_COLOR.getValue()), (float)0.4f, (float)1.0f));
                SupporterRenderer.drawText(endX, name, x, y, fontMatrix, bufferSource, color, backgroundColor, packedLight);
                SupporterRenderer.drawBadge(Badge.AUTHOR, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            case "PoeticRainbow": {
                if (RAINBOW_COLOR.isFinished()) {
                    RAINBOW_COLOR.reset();
                    RAINBOW_COLOR.tick();
                }
                RAINBOW_COLOR.play();
                SupporterRenderer.drawText(IntegerHolder.create((int)x), name, x, y, fontMatrix, bufferSource, translucent, backgroundColor, packedLight);
                CollectionUtil.forLoop(Arrays.stream(name.split("")), (letter, index) -> {
                    float offset = (float)index.intValue() / (float)name.length();
                    float degrees = 360.0f * (1.0f - (float)RAINBOW_COLOR.getValue() + offset);
                    float hsb = MathUtil.normalizeInRange(degrees, 0.0f, 360.0f);
                    int color = Color.HSBtoRGB(hsb / 360.0f, 1.0f, 1.0f);
                    SupporterRenderer.drawText(endX, letter, ((Integer)endX.get()).intValue(), y, fontMatrix, bufferSource, color, transparent, packedLight);
                });
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            case "Captain_3": {
                if (CAPTAIN_MOVER.isFinished()) {
                    CAPTAIN_MOVER.reset();
                    CAPTAIN_CYCLE.cycle();
                }
                CAPTAIN_MOVER.play();
                SupporterRenderer.drawText(IntegerHolder.create((int)x), name, x, y, fontMatrix, bufferSource, translucent, backgroundColor, packedLight);
                CollectionUtil.forLoop(Arrays.stream(name.split("")), (letter, index) -> {
                    int color = SupporterOverlay.getNames().getOrDefault(name, Color.WHITE).get();
                    int jumpY = (int)y + CAPTAIN_CYCLE.get() == index ? -1 : 0;
                    SupporterRenderer.drawText(endX, letter, ((Integer)endX.get()).intValue(), jumpY, fontMatrix, bufferSource, color, transparent, packedLight);
                });
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            default: {
                Color color = SupporterOverlay.getNames().getOrDefault(name, Color.WHITE);
                SupporterRenderer.drawText(endX, name, x, y, fontMatrix, bufferSource, color.get(), backgroundColor, packedLight);
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
            }
        }
        return (Integer)endX.get();
    }

    private static enum Badge {
        AUTHOR(AUTHOR_SEE_THROUGH_SHADER, AUTHOR_VISIBLE_SHADER),
        SUPPORTER(SUPPORTER_SEE_THROUGH_SHADER, SUPPORTER_VISIBLE_SHADER);

        private final RenderType seeThrough;
        private final RenderType visible;

        private Badge(RenderType seeThrough, RenderType visible) {
            this.seeThrough = seeThrough;
            this.visible = visible;
        }

        private RenderType getSeeThroughShader() {
            return this.seeThrough;
        }

        private RenderType getVisibleShader() {
            return this.visible;
        }
    }
}

