/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.block;

import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ChestHelper {
    private static final ConcurrentHashMap<Block, BitSet> BLOCK_CACHE = new ConcurrentHashMap();

    public static void init() {
        CandyTweak.CHEST_LIGHT_BLOCK.whenChanged(ChestHelper::invalidateAndRelight);
        CandyTweak.OLD_CHEST.whenChanged(ChestHelper::invalidateAndRelight);
        CandyTweak.OLD_ENDER_CHEST.whenChanged(ChestHelper::invalidateAndRelight);
        CandyTweak.OLD_TRAPPED_CHEST.whenChanged(ChestHelper::invalidateAndRelight);
        CandyTweak.OLD_MOD_CHESTS.whenChanged(ChestHelper::invalidateAndRelight);
        CandyTweak.TRANSLUCENT_CHESTS.whenChanged(ChestHelper::invalidateAndRelight);
    }

    private static void invalidateAndRelight() {
        BLOCK_CACHE.clear();
        LightingHelper.RELIGHT_ALL_CHUNKS.enable();
    }

    public static boolean isOld(Block block) {
        BitSet cache = BLOCK_CACHE.get(block);
        if (cache != null) {
            return cache.get(0);
        }
        BitSet bitSet = new BitSet(2);
        boolean isOldChest = (Boolean)CandyTweak.OLD_CHEST.get() != false && block.getClass().equals(ChestBlock.class);
        boolean isOldEnder = (Boolean)CandyTweak.OLD_ENDER_CHEST.get() != false && block.getClass().equals(EnderChestBlock.class);
        boolean isOldTrap = (Boolean)CandyTweak.OLD_TRAPPED_CHEST.get() != false && block.getClass().equals(TrappedChestBlock.class);
        boolean isOldMod = ((ItemSet)CandyTweak.OLD_MOD_CHESTS.get()).containsKey(ItemUtil.getResourceKey(block));
        boolean isOld = isOldChest || isOldEnder || isOldTrap || isOldMod;
        bitSet.set(0, isOld);
        bitSet.set(1, ((ItemSet)CandyTweak.TRANSLUCENT_CHESTS.get()).containsKey(ItemUtil.getResourceKey(block)));
        BLOCK_CACHE.put(block, bitSet);
        return isOld;
    }

    public static boolean isOld(BlockState blockState) {
        return ChestHelper.isOld(blockState.m_60734_());
    }

    public static boolean isTranslucent(Block block) {
        BitSet cache = BLOCK_CACHE.get(block);
        if (cache != null) {
            return cache.get(0) && cache.get(1);
        }
        ChestHelper.isOld(block);
        BitSet bitSet = BLOCK_CACHE.get(block);
        return bitSet.get(0) && bitSet.get(1);
    }

    public static boolean isTranslucent(BlockState blockState) {
        return ChestHelper.isTranslucent(blockState.m_60734_());
    }
}

